/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.io.index;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.index.ArtifactPredicateBuilder;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.model.ArtifactIndexData;

public class VolatileArtifactIndex
implements ArtifactIndex {
    private static final Log log = LogFactory.getLog(VolatileArtifactIndex.class);
    private Map<String, ArtifactIndexData> index = new LinkedHashMap<String, ArtifactIndexData>();

    @Override
    public ArtifactIndexData indexArtifact(Artifact artifact) {
        UUID indexDataId = UUID.randomUUID();
        ArtifactIdentifier artifactIdentifier = artifact.getIdentifier();
        ArtifactIndexData indexData = new ArtifactIndexData(indexDataId.toString(), artifactIdentifier.getCollection(), artifactIdentifier.getAuid(), artifactIdentifier.getUri(), artifactIdentifier.getVersion(), Boolean.valueOf(false));
        this.index.put(indexDataId.toString(), indexData);
        return indexData;
    }

    @Override
    public ArtifactIndexData getArtifactIndexData(String indexDataId) {
        return this.index.get(indexDataId);
    }

    @Override
    public ArtifactIndexData getArtifactIndexData(UUID indexDataId) {
        return this.getArtifactIndexData(indexDataId.toString());
    }

    @Override
    public ArtifactIndexData commitArtifact(String indexDataId) {
        ArtifactIndexData indexedData = this.index.get(indexDataId);
        indexedData.setCommitted(Boolean.valueOf(true));
        return indexedData;
    }

    @Override
    public ArtifactIndexData commitArtifact(UUID indexDataId) {
        return this.commitArtifact(indexDataId.toString());
    }

    @Override
    public void deleteArtifact(String indexDataId) {
        this.index.remove(indexDataId);
    }

    @Override
    public void deleteArtifact(UUID indexDataId) {
        this.deleteArtifact(indexDataId.toString());
    }

    @Override
    public boolean artifactExists(String artifactId) {
        return this.index.containsKey(artifactId);
    }

    @Override
    public Iterator<String> getCollectionIds() {
        Stream<ArtifactIndexData> artifactStream = this.index.values().stream();
        Stream<ArtifactIndexData> committedArtifacts = artifactStream.filter(x -> x.getCommitted());
        Map<String, List<ArtifactIndexData>> collections = committedArtifacts.collect(Collectors.groupingBy(ArtifactIndexData::getCollection));
        return collections.keySet().iterator();
    }

    @Override
    public Map<String, List<ArtifactIndexData>> getAus(String collection) {
        return this.getCommittedArtifacts(collection).collect(Collectors.groupingBy(ArtifactIndexData::getAuid));
    }

    @Override
    public Iterator<ArtifactIndexData> getArtifactsInAU(String collection, String auid) {
        ArtifactPredicateBuilder query = new ArtifactPredicateBuilder();
        query.filterByCommitStatus(true);
        query.filterByCollection(collection);
        query.filterByAuid(auid);
        return this.index.values().stream().filter(query.build()).iterator();
    }

    @Override
    public Iterator<ArtifactIndexData> getArtifactsinAUWithURL(String collection, String auid, String prefix) {
        ArtifactPredicateBuilder query = new ArtifactPredicateBuilder();
        query.filterByCommitStatus(true);
        query.filterByCollection(collection);
        query.filterByAuid(auid);
        query.filterByURIPrefix(prefix);
        return this.index.values().stream().filter(query.build()).iterator();
    }

    @Override
    public Iterator<ArtifactIndexData> query(ArtifactPredicateBuilder query) {
        return this.index.values().stream().filter(query.build()).iterator();
    }

    public Stream<ArtifactIndexData> getCommittedArtifacts(String collection) {
        ArtifactPredicateBuilder query = new ArtifactPredicateBuilder();
        query.filterByCommitStatus(true);
        query.filterByCollection(collection);
        return this.index.values().stream().filter(query.build());
    }
}

