/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.io.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.warc.WARCReaderFactory;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.storage.WARCArtifactStore;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.model.ArtifactIndexData;
import org.lockss.laaws.rs.util.ArtifactFactory;

public class LocalWARCArtifactStore
extends WARCArtifactStore {
    private static final Log log = LogFactory.getLog(LocalWARCArtifactStore.class);
    private static final String WARC_FILE_SUFFIX = ".warc";
    private ArtifactIndex index;

    public LocalWARCArtifactStore(ArtifactIndex index, File baseDir) {
        log.info((Object)String.format("Loading all WARCs under %s", baseDir.getAbsolutePath()));
        this.index = index;
        if (baseDir.exists() && baseDir.isDirectory()) {
            Collection<File> warcs = LocalWARCArtifactStore.scanDirectories(baseDir);
            warcs.stream().forEach(this::addWARC);
        }
    }

    public static Collection<File> scanDirectories(File warcFilesDir) {
        ArrayList<File> warcFiles = new ArrayList<File>();
        Arrays.stream(warcFilesDir.listFiles(x -> x.isDirectory())).map(x -> LocalWARCArtifactStore.scanDirectories(x)).forEach(warcFiles::addAll);
        warcFiles.addAll(Arrays.asList(warcFilesDir.listFiles((dir, name) -> new File(dir, name).isFile() && name.toLowerCase().endsWith(WARC_FILE_SUFFIX))));
        return warcFiles;
    }

    public void addWARC(File warcFile) {
        try {
            for (ArchiveRecord record : WARCReaderFactory.get((File)warcFile)) {
                ArchiveRecordHeader headers = record.getHeader();
                String recordType = (String)headers.getHeaderValue("WARC-Type");
                log.info((Object)String.format("Importing WARC record (ID: %s, type: %s), headers: %s", record.getHeader().getHeaderValue("WARC-Record-ID"), recordType, record.getHeader()));
                Artifact artifact = ArtifactFactory.fromArchiveRecord((ArchiveRecord)record);
                if (artifact == null) continue;
                artifact.setIdentifier(new ArtifactIdentifier("collection1", "auid", headers.getUrl(), headers.getVersion()));
                if (this.index == null) {
                    throw new RuntimeException("No artifact index");
                }
                ArtifactIdentifier id = artifact.getIdentifier();
                log.info((Object)String.format("Indexing artifact (%s, %s, %s, %s)", id.getCollection(), id.getAuid(), id.getUri(), id.getVersion()));
                ArtifactIndexData data = this.index.indexArtifact(artifact);
                this.index.commitArtifact(data.getId());
            }
        }
        catch (IOException e) {
            log.error((Object)String.format("An IO exception occurred while iterating over records from %s: %s", warcFile, e));
        }
    }

    public ArtifactIdentifier addArtifact(Artifact artifact) throws IOException {
        return null;
    }

    public Artifact getArtifact(ArtifactIndexData indexData) throws IOException {
        return null;
    }

    @Override
    public void updateArtifact(ArtifactIndexData indexData, Artifact artifact) {
    }

    @Override
    public void deleteArtifact(ArtifactIndexData indexData) {
    }
}

