/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.io.storage;

import com.google.common.io.CountingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.archive.format.warc.WARCConstants;
import org.archive.io.warc.WARCRecordInfo;
import org.lockss.laaws.rs.io.storage.ArtifactStore;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.util.ArtifactUtil;

public abstract class WARCArtifactStore
implements ArtifactStore,
WARCConstants {
    private static final Log log = LogFactory.getLog(WARCArtifactStore.class);
    public static final String CRLF = "\r\n";
    public static byte[] CRLF_BYTES;

    public long writeArtifact(Artifact artifact, OutputStream outputStream) throws IOException, HttpException {
        ArtifactIdentifier identifier = artifact.getIdentifier();
        WARCRecordInfo record = new WARCRecordInfo();
        record.setRecordId(URI.create(UUID.randomUUID().toString()));
        record.setCreate14DigitDate(identifier.getVersion());
        record.setType(WARCConstants.WARCRecordType.response);
        record.setUrl(identifier.getUri());
        record.setMimetype("application/http; msgtype=response");
        record.addExtraHeader("X-Lockss-Collection", identifier.getCollection());
        record.addExtraHeader("X-Lockss-AuId", identifier.getAuid());
        record.addExtraHeader("X-Lockss-Uri", identifier.getUri());
        record.addExtraHeader("X-Lockss-Version", identifier.getVersion());
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(0x100000, "writeArtifactDfos", null, new File("/tmp"));
        IOUtils.copy((InputStream)ArtifactUtil.getHttpResponseStreamFromArtifact((Artifact)artifact), (OutputStream)dfos);
        dfos.close();
        record.setContentStream(dfos.isInMemory() ? new ByteArrayInputStream(dfos.getData()) : new FileInputStream(dfos.getFile()));
        record.setContentLength(dfos.getByteCount());
        CountingOutputStream cout = new CountingOutputStream(outputStream);
        WARCArtifactStore.write(record, (OutputStream)cout);
        return cout.getCount();
    }

    public static void write(WARCRecordInfo record, OutputStream out) throws IOException {
        int bytesWritten;
        out.write(WARCArtifactStore.createRecordHeader(record).getBytes("UTF-8"));
        out.write(CRLF_BYTES);
        if (record.getContentStream() != null && (long)(bytesWritten = IOUtils.copy((InputStream)record.getContentStream(), (OutputStream)out)) != record.getContentLength()) {
            log.warn((Object)String.format("Expected %d bytes, but wrote %d", record.getContentLength(), bytesWritten));
        }
        out.write(CRLF_BYTES);
        out.write(CRLF_BYTES);
    }

    protected static String createRecordHeader(WARCRecordInfo record) {
        StringBuilder sb = new StringBuilder();
        sb.append("WARC/1.0").append(CRLF);
        sb.append("WARC-Record-ID").append(": ").append('<').append(record.getRecordId().toString()).append('>').append(CRLF);
        sb.append("Content-Length").append(": ").append(Long.toString(record.getContentLength())).append(CRLF);
        sb.append("WARC-Date").append(": ").append(record.getCreate14DigitDate()).append(CRLF);
        sb.append("WARC-Type").append(": ").append(record.getType()).append(CRLF);
        if (!StringUtils.isEmpty((String)record.getUrl())) {
            sb.append("WARC-Target-URI").append(": ").append(record.getUrl()).append(CRLF);
        }
        if (record.getContentLength() > 0L) {
            sb.append("Content-Type").append(": ").append(record.getMimetype()).append(CRLF);
        }
        if (record.getExtraHeaders() != null) {
            Iterator i = record.getExtraHeaders().iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append(CRLF);
            }
        }
        return sb.toString();
    }

    static {
        try {
            CRLF_BYTES = CRLF.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

