/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.io.storage.hdfs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.archive.format.warc.WARCConstants;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.util.ArchiveUtils;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.event.AbstractStoreEvent;
import org.springframework.data.hadoop.store.event.FileWrittenEvent;
import org.springframework.data.hadoop.store.event.StoreEventPublisher;
import org.springframework.data.hadoop.store.output.AbstractDataStreamWriter;
import org.springframework.data.hadoop.store.support.OutputContext;
import org.springframework.data.hadoop.store.support.StreamsHolder;

public class WARCFileWriter
extends AbstractDataStreamWriter
implements DataStoreWriter<WARCRecordInfo>,
WARCConstants {
    private static final Log log = LogFactory.getLog(WARCFileWriter.class);
    private static final String SCHEME = "urn:uuid";
    private static final String SCHEME_COLON = "urn:uuid:";
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte COLON = 58;
    private static final byte SP = 32;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String CRLF = "\r\n";
    private static byte[] CRLF_BYTES;
    private StreamsHolder<OutputStream> streamsHolder;

    public WARCFileWriter(Configuration configuration, Path basePath, CodecInfo codec) {
        super(configuration, basePath, codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.streamsHolder != null) {
            IOException rethrow = null;
            try {
                this.streamsHolder.close();
                Path path = this.renameFile(this.streamsHolder.getPath());
                StoreEventPublisher storeEventPublisher = this.getStoreEventPublisher();
                if (storeEventPublisher != null) {
                    storeEventPublisher.publishEvent((AbstractStoreEvent)new FileWrittenEvent((Object)this, path));
                }
            }
            catch (IOException e) {
                rethrow = e;
                log.error((Object)"Error in close", (Throwable)e);
            }
            finally {
                this.streamsHolder = null;
            }
            if (rethrow != null) {
                throw rethrow;
            }
        }
    }

    public synchronized void flush() throws IOException {
        if (this.streamsHolder != null) {
            OutputStream stream = (OutputStream)this.streamsHolder.getStream();
            stream.flush();
            if ((this.isAppendable() || this.isSyncable()) && stream instanceof Syncable) {
                ((Syncable)stream).hflush();
            }
        }
    }

    public synchronized void hflush() throws IOException {
        if (this.streamsHolder != null) {
            ((Syncable)this.streamsHolder.getStream()).hflush();
        }
    }

    protected void handleTimeout() {
        try {
            if (this.isAppendable()) {
                log.info((Object)"Timeout detected for this writer; flushing stream");
                this.hflush();
            } else {
                log.info((Object)"Timeout detected for this writer; closing stream");
                this.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Error closing", (Throwable)e);
        }
        this.getOutputContext().rollStrategies();
    }

    public StreamsHolder<OutputStream> getOutput() throws IOException {
        if (this.streamsHolder == null) {
            this.streamsHolder = super.getOutput();
            if (!this.isAppendable() && this.getPosition(this.streamsHolder) == 0L) {
                log.info((Object)"Writing a WARC Info record");
                WARCFileWriter.write(this.createWARCInfoRecord(), (OutputStream)this.streamsHolder.getStream());
            }
        }
        return this.streamsHolder;
    }

    public WARCRecordInfo createWARCInfoRecord() throws IOException {
        WARCRecordInfo record = new WARCRecordInfo();
        record.setType(WARCConstants.WARCRecordType.warcinfo);
        record.setCreate14DigitDate(ArchiveUtils.get14DigitDate());
        record.setMimetype("application/warc-fields");
        record.addExtraHeader("WARC-Filename", this.streamsHolder.getPath().getName());
        record.setRecordId(WARCFileWriter.generateRecordId());
        byte[] contents = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write("Not implemented".getBytes(UTF8));
        contents = baos.toByteArray();
        record.setContentStream((InputStream)new ByteArrayInputStream(contents));
        record.setContentLength((long)contents.length);
        return record;
    }

    private static URI generateRecordId() {
        URI uri;
        try {
            uri = new URI(SCHEME_COLON + UUID.randomUUID().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    private static String makeRecordId() {
        StringBuilder id = new StringBuilder();
        id.append("<").append(SCHEME_COLON);
        id.append(UUID.randomUUID().toString());
        id.append(">");
        return id.toString();
    }

    public synchronized void write(WARCRecordInfo record) throws IOException {
        if (this.streamsHolder == null) {
            this.streamsHolder = this.getOutput();
        }
        record.setWARCFilename(this.streamsHolder.getPath().getName());
        record.setWARCFileOffset(Long.valueOf(this.getPosition(this.streamsHolder)));
        OutputStream out = (OutputStream)this.streamsHolder.getStream();
        WARCFileWriter.write(record, out);
        this.setWritePosition(this.getPosition(this.streamsHolder));
        this.hflush();
        OutputContext context = this.getOutputContext();
        if (context.getRolloverState()) {
            log.info((Object)"Rollover conditions were met; closing current stream");
            this.close();
            context.rollStrategies();
        }
    }

    public long getPosition() throws IOException {
        return this.getPosition(this.getOutput());
    }

    public static void write(WARCRecordInfo record, OutputStream out) throws IOException {
        if (record.getContentLength() == 0L && (record.getExtraHeaders() == null || record.getExtraHeaders().size() <= 0)) {
            throw new IllegalArgumentException("Cannot write record of content-length zero and base headers only");
        }
        out.write(WARCFileWriter.createRecordHeader(record).getBytes("UTF-8"));
        out.write(CRLF_BYTES);
        if (record.getContentStream() != null && record.getContentLength() > 0L) {
            IOUtils.copy((InputStream)record.getContentStream(), (OutputStream)out);
        }
        out.write(CRLF_BYTES);
        out.write(CRLF_BYTES);
    }

    protected static String createRecordHeader(WARCRecordInfo record) {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("WARC/1.0").append(CRLF);
        sb.append("WARC-Type").append(": ").append(record.getType()).append(CRLF);
        if (!StringUtils.isEmpty((String)record.getUrl())) {
            sb.append("WARC-Target-URI").append(": ").append(record.getUrl()).append(CRLF);
        }
        sb.append("WARC-Date").append(": ").append(record.getCreate14DigitDate()).append(CRLF);
        if (record.getExtraHeaders() != null) {
            Iterator i = record.getExtraHeaders().iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append(CRLF);
            }
        }
        sb.append("WARC-Record-ID").append(": ").append('<').append(record.getRecordId().toString()).append('>').append(CRLF);
        if (record.getContentLength() > 0L) {
            sb.append("Content-Type").append(": ").append(record.getMimetype()).append(CRLF);
        }
        sb.append("Content-Length").append(": ").append(Long.toString(record.getContentLength())).append(CRLF);
        return sb.toString();
    }

    static {
        try {
            CRLF_BYTES = CRLF.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

