/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.io.storage.mock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.archive.io.warc.WARCRecord;
import org.lockss.laaws.rs.io.storage.WARCArtifactStore;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.model.ArtifactIndexData;
import org.lockss.laaws.rs.util.ArtifactFactory;

public class VolatileWARCArtifactStore
extends WARCArtifactStore {
    private static final Log log = LogFactory.getLog(VolatileWARCArtifactStore.class);
    private Map<String, Map<String, Map<String, byte[]>>> repository = new HashMap<String, Map<String, Map<String, byte[]>>>();

    public ArtifactIdentifier addArtifact(Artifact artifact) throws IOException {
        ArtifactIdentifier aid = artifact.getIdentifier();
        Map collection = this.repository.getOrDefault(aid.getCollection(), new HashMap());
        Map au = collection.getOrDefault(aid.getAuid(), new HashMap());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeArtifact(artifact, baos);
            au.put(aid.getUri() + String.valueOf(aid.getVersion()), baos.toByteArray());
        }
        catch (HttpException e) {
            throw new IOException(e);
        }
        collection.put(aid.getAuid(), au);
        this.repository.put(aid.getCollection(), collection);
        return aid;
    }

    public Artifact getArtifact(ArtifactIndexData indexedData) throws IOException {
        if (indexedData == null) {
            return null;
        }
        return this.getVolatileArtifact(indexedData.getCollection(), indexedData.getAuid(), indexedData.getUri(), indexedData.getVersion());
    }

    public Artifact getVolatileArtifact(String collectionId, String auid, String uri, String version) throws IOException {
        Map<String, Map<String, byte[]>> collection = this.repository.get(collectionId);
        Map<String, byte[]> au = collection.get(auid);
        ByteArrayInputStream warcRecordStream = new ByteArrayInputStream(au.get(uri + version));
        WARCRecord record = new WARCRecord((InputStream)warcRecordStream, null, 0L, true, true);
        Artifact artifact = ArtifactFactory.fromHttpResponseStream((InputStream)record);
        ArtifactIdentifier identifier = new ArtifactIdentifier(collectionId, auid, uri, version);
        artifact.setIdentifier(identifier);
        return artifact;
    }

    @Override
    public void updateArtifact(ArtifactIndexData indexData, Artifact artifact) {
    }

    @Override
    public void deleteArtifact(ArtifactIndexData indexData) {
        Map<String, Map<String, byte[]>> collection = this.repository.get(indexData.getCollection());
        Map<String, byte[]> au = collection.get(indexData.getAuid());
        au.remove(indexData.getUri() + indexData.getVersion());
    }
}

