/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.controller;

import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.lockss.laaws.rs.api.ReposApi;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactData;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.util.ArtifactDataFactory;
import org.lockss.laaws.rs.util.ArtifactDataUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Controller
public class ReposApiController
implements ReposApi {
    private static final Log log = LogFactory.getLog(ReposApiController.class);
    public static final String APPLICATION_HTTP_RESPONSE_VALUE = "application/http;msgtype=response";
    public static final MediaType APPLICATION_HTTP_RESPONSE = MediaType.parseMediaType((String)"application/http;msgtype=response");
    @Autowired
    LockssRepository repo;

    @Override
    public ResponseEntity<List<String>> reposGet() {
        ArrayList collectionIds = new ArrayList();
        try {
            this.repo.getCollectionIds().forEach(x -> collectionIds.add(x));
        }
        catch (IOException e) {
            log.error((Object)"IOException was caught trying to enumerate collection IDs");
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(collectionIds, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Void> reposArtifactsArtifactidDelete(@ApiParam(value="Repository to add artifact into", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="ArtifactData ID", required=true) @PathVariable(value="artifactid") String artifactid) {
        try {
            if (!this.repo.artifactExists(artifactid)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            this.repo.deleteArtifact(repository, artifactid);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (IOException e) {
            log.error((Object)String.format("IOException occurred while attempting to delete artifact from repository (artifactId: %s)", artifactid));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<StreamingResponseBody> reposArtifactsArtifactidGet(@ApiParam(value="Repository to add artifact into", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="ArtifactData ID", required=true) @PathVariable(value="artifactid") String artifactId) {
        log.info((Object)String.format("Retrieving artifact: %s from collection %s", artifactId, repository));
        try {
            if (!this.repo.artifactExists(artifactId)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            ArtifactData artifactData = this.repo.getArtifactData(repository, artifactId);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/http; msgtype=response"));
            headers.setContentLength(artifactData.getContentLength());
            ArtifactIdentifier id = artifactData.getIdentifier();
            headers.set("X-Lockss-ArtifactId", id.getId());
            headers.set("X-Lockss-Collection", id.getCollection());
            headers.set("X-Lockss-AuId", id.getAuid());
            headers.set("X-Lockss-Uri", id.getUri());
            headers.set("X-Lockss-Version", String.valueOf(id.getVersion()));
            return new ResponseEntity(outputStream -> {
                try {
                    ArtifactDataUtil.writeHttpResponse((HttpResponse)ArtifactDataUtil.getHttpResponseFromArtifact((ArtifactIdentifier)artifactData.getIdentifier(), (StatusLine)artifactData.getHttpStatus(), (HttpHeaders)artifactData.getMetadata(), (InputStream)artifactData.getInputStream()), (OutputStream)outputStream);
                }
                catch (HttpException e) {
                    e.printStackTrace();
                }
            }, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (IOException e) {
            log.error((Object)String.format("IOException occurred while attempting to retrieve artifact from repository (artifactId: %s): %s", artifactId, e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<String> reposArtifactsArtifactidPut(@ApiParam(value="Repository to add artifact into", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="ArtifactData ID", required=true) @PathVariable(value="artifactid") String artifactId, @ApiParam(value="New commit status of artifact") @RequestPart(value="committed", required=false) Boolean committed) {
        if (committed == null) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        try {
            if (!this.repo.artifactExists(artifactId)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            log.info((Object)String.format("Updating commit status for %s (%s -> %s)", artifactId, this.repo.isArtifactCommitted(artifactId), committed));
            this.repo.commitArtifact(repository, artifactId);
        }
        catch (IOException e) {
            log.error((Object)String.format("IOException occurred while attempting to update artifact metadata (artifactId: %s): %s", artifactId, e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Override
    public ResponseEntity<List<String>> reposArtifactsGet(@ApiParam(value="Collection ID", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="ArtifactData ID") @RequestParam(value="artifact", required=false) String artifact, @ApiParam(value="ArtifactData AUID") @RequestParam(value="auid", required=false) String auid, @ApiParam(value="ArtifactData URI") @RequestParam(value="uri", required=false) String uri, @ApiParam(value="ArtifactData aspect") @RequestParam(value="aspect", required=false) String aspect, @ApiParam(value="Date and time associated with artifact's content") @RequestParam(value="timestamp", required=false) Integer timestamp, @ApiParam(value="Date and time of artifact acquisition into repository") @RequestParam(value="acquired", required=false) Integer acquired, @ApiParam(value="ArtifactData content digest") @RequestParam(value="hash", required=false) String hash, @ApiParam(value="ArtifactData committed status", defaultValue="true") @RequestParam(value="committed", required=false, defaultValue="true") Boolean committed, @ApiParam(value="Include artifact aspects in results (default: false)", defaultValue="false") @RequestParam(value="includeAllAspects", required=false, defaultValue="false") Boolean includeAllAspects, @ApiParam(value="Includes all versions if set (default: false)", defaultValue="false") @RequestParam(value="includeAllVersions", required=false, defaultValue="false") Boolean includeAllVersions, @ApiParam(value="Maximum number of results to return (used for pagination)", defaultValue="1000") @RequestParam(value="limit", required=false, defaultValue="1000") Integer limit, @ApiParam(value="Begin listing with given artifact (used for pagination)") @RequestParam(value="next_artifact", required=false) String nextArtifact) {
        ArrayList<String> artifacts = new ArrayList<String>();
        artifacts.add("Not implemented");
        return new ResponseEntity(artifacts, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Artifact> reposArtifactsPost(@ApiParam(value="", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="Archival Unit ID (AUID) of new artifact", required=true) @RequestPart(value="auid", required=true) String auid, @ApiParam(value="URI represented by this artifact", required=true) @RequestPart(value="uri", required=true) String uri, @ApiParam(value="ArtifactData version", required=true) @RequestPart(value="version", required=true) Integer version, @ApiParam(value="ArtifactData") @RequestPart(value="artifact", required=true) MultipartFile artifactPart, MultipartFile ... aspectParts) {
        log.info((Object)String.format("Adding artifact %s, %s, %s, %d", repository, auid, uri, version));
        try {
            log.info((Object)String.format("MultipartFile: Type: ArtifactData, Content-type: %s", artifactPart.getContentType()));
            if (!ReposApiController.isHttpResponseType(MediaType.parseMediaType((String)artifactPart.getContentType())).booleanValue()) {
                log.error((Object)String.format("Failed to add artifact; expected %s but got %s", APPLICATION_HTTP_RESPONSE, MediaType.parseMediaType((String)artifactPart.getContentType())));
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            ArtifactData artifactData = ArtifactDataFactory.fromHttpResponseStream((InputStream)artifactPart.getInputStream());
            ArtifactIdentifier id = new ArtifactIdentifier(repository, auid, uri, version);
            artifactData.setIdentifier(id);
            artifactData.setContentLength(artifactPart.getSize());
            Artifact artifact = this.repo.addArtifact(artifactData);
            log.info((Object)String.format("Wrote artifact to %s", artifactData.getStorageUrl()));
            for (MultipartFile aspectPart : aspectParts) {
                log.warn((Object)String.format("Ignoring MultipartFile: Type: Aspect, Content-type: %s", aspectPart.getContentType()));
            }
            return new ResponseEntity((Object)artifact, HttpStatus.OK);
        }
        catch (IOException e) {
            log.error((Object)"Caught IOException while attempting to add an artifact to the repository");
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static Boolean isHttpResponseType(MediaType type) {
        return APPLICATION_HTTP_RESPONSE.isCompatibleWith(type) && type.getParameters().equals(APPLICATION_HTTP_RESPONSE.getParameters());
    }
}

