/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.0).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.rs.api;

import org.springframework.core.io.Resource;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

@Api(value = "warcs", description = "the warcs API")
public interface WarcsApi {

    WarcsApiDelegate getDelegate();

    @ApiOperation(value = "Get a WARC archive", nickname = "getWarcArchive", notes = "Get the contents of a single WARC record as a WARC archive", response = Resource.class, tags={ "wayback", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The contents of the requested WARC archive", response = Resource.class),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 404, message = "WARC archive not found"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/warcs/{fileName}",
        produces = { "application/warc" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getWarcArchive(@ApiParam(value = "Name of the WARC archive",required=true) @PathVariable("fileName") String fileName,@ApiParam(value = "The Accept header" ) @RequestHeader(value="Accept", required=false) String accept,@ApiParam(value = "The Accept-Encoding header" ) @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding,@ApiParam(value = "The Range header" ) @RequestHeader(value="Range", required=false) String range) {
        return getDelegate().getWarcArchive(fileName, accept, acceptEncoding, range);
    }

}
