/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import org.lockss.laaws.rs.api.CdxApiDelegate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="cdx", description="the cdx API")
public interface CdxApi {
    public CdxApiDelegate getDelegate();

    @ApiOperation(value="Get OpenWayback CDX records", nickname="getCdxOwb", notes="Get the OpenWayback CDX records of a URL in a collection", response=String.class, tags={"wayback"})
    @ApiResponses(value={@ApiResponse(code=200, message="The OpenWayback CDX records of the URL in the collection", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Collection/URL not found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/cdx/owb/{collectionid}"}, produces={"application/xml"}, method={RequestMethod.GET})
    default public ResponseEntity<String> getCdxOwb(@ApiParam(value="Identifier of the collection", required=true) @PathVariable(value="collectionid") String collectionid, @ApiParam(value="Query string. Supported fields are url, type\\ \\ (urlquery/prefixquery), offset and limit.") @Valid @RequestParam(value="q", required=false) String q, @ApiParam(value=".") @Valid @RequestParam(value="count", required=false) Integer count, @ApiParam(value=".") @Valid @RequestParam(value="start_page", required=false) Integer startPage, @ApiParam(value="The Accept header") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="The Accept-Encoding header") @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding) {
        return this.getDelegate().getCdxOwb(collectionid, q, count, startPage, accept, acceptEncoding);
    }

    @ApiOperation(value="Get PyWayback CDX records", nickname="getCdxPywb", notes="Get the PyWayback CDX records of a URL in a collection", response=String.class, tags={"wayback"})
    @ApiResponses(value={@ApiResponse(code=200, message="The PyWayback CDX records of the URL in the collection", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Collection/URL not found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/cdx/pywb/{collectionid}"}, produces={"text/plain"}, method={RequestMethod.GET})
    default public ResponseEntity<String> getCdxPywb(@ApiParam(value="Identifier of the collection", required=true) @PathVariable(value="collectionid") String collectionid, @ApiParam(value="The URL for which the CDX records are requested") @Valid @RequestParam(value="url", required=false) String url, @ApiParam(value=".") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="", allowableValues="exact, prefix, host, domain, range") @Valid @RequestParam(value="matchType", required=false) String matchType, @ApiParam(value="", allowableValues="default, closest, reverse") @Valid @RequestParam(value="sort", required=false) String sort, @ApiParam(value="Timestamp for sort=closest mode") @Valid @RequestParam(value="closest", required=false) String closest, @ApiParam(value="Output format", allowableValues="cdx, json") @Valid @RequestParam(value="output", required=false) String output, @ApiParam(value="Comma-separated list of fields to include in output") @Valid @RequestParam(value="fl", required=false) String fl, @ApiParam(value="The Accept header") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="The Accept-Encoding header") @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding) {
        return this.getDelegate().getCdxPywb(collectionid, url, limit, matchType, sort, closest, output, fl, accept, acceptEncoding);
    }
}

