/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.lockss.laaws.rs.api.CollectionsApiDelegate;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactPageInfo;
import org.lockss.laaws.rs.model.AuidPageInfo;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Api(value="collections", description="the collections API")
public interface CollectionsApi {
    public CollectionsApiDelegate getDelegate();

    @ApiOperation(value="Create an artifact", nickname="createArtifact", notes="", response=Artifact.class, tags={"collections"})
    @ApiResponses(value={@ApiResponse(code=201, message="Artifact created", response=Artifact.class), @ApiResponse(code=302, message="Duplicate content; artifact not created"), @ApiResponse(code=400, message="Invalid input"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=403, message="Client not authorized to create artifacts"), @ApiResponse(code=502, message="Internal error creating artifact")})
    @RequestMapping(value={"/collections/{collectionid}/artifacts"}, produces={"application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    default public ResponseEntity<Artifact> createArtifact(@ApiParam(value="Collection containing the artifact", required=true) @PathVariable(value="collectionid") String collectionid, @ApiParam(value="Archival Unit ID (AUID) of new artifact", required=true) @RequestParam(value="auid", required=true) String auid, @ApiParam(value="URI represented by this artifact", required=true) @RequestParam(value="uri", required=true) String uri, @ApiParam(value="file detail") @Valid @RequestPart(value="file") MultipartFile content, @ApiParam(value="Artifact collection/crawl date (milliseconds since epoch; UTC)") @RequestParam(value="collectionDate", required=false) Long collectionDate) {
        return this.getDelegate().createArtifact(collectionid, auid, uri, content, collectionDate);
    }

    @ApiOperation(value="Remove an artifact from the repository", nickname="deleteArtifact", notes="", tags={"collections"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully removed artifact"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=403, message="Client not authorized to delete artifact"), @ApiResponse(code=404, message="Artifact not found"), @ApiResponse(code=409, message="Cannot delete committed artifact")})
    @RequestMapping(value={"/collections/{collectionid}/artifacts/{artifactid}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Void> deleteArtifact(@ApiParam(value="Collection containing the artifact", required=true) @PathVariable(value="collectionid") String collectionid, @ApiParam(value="Identifier of the artifact", required=true) @PathVariable(value="artifactid") String artifactid) {
        return this.getDelegate().deleteArtifact(collectionid, artifactid);
    }

    @ApiOperation(value="Get artifact content and metadata", nickname="getArtifact", notes="", response=Resource.class, tags={"collections"})
    @ApiResponses(value={@ApiResponse(code=200, message="Artifact created", response=Resource.class), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=403, message="Client not authorized to retrieve artifact"), @ApiResponse(code=404, message="Artifact not found"), @ApiResponse(code=502, message="Could not read from external resource")})
    @RequestMapping(value={"/collections/{collectionid}/artifacts/{artifactid}"}, produces={"multipart/form-data"}, method={RequestMethod.GET})
    default public ResponseEntity<Resource> getArtifact(@ApiParam(value="Collection containing the artifact", required=true) @PathVariable(value="collectionid") String collectionid, @ApiParam(value="Identifier of the artifact", required=true) @PathVariable(value="artifactid") String artifactid, @ApiParam(value="Controls whether to include the artifact content part in multipart response", allowableValues="NEVER, IF_SMALL, ALWAYS", defaultValue="ALWAYS") @Valid @RequestParam(value="includeContent", required=false, defaultValue="ALWAYS") String includeContent) {
        return this.getDelegate().getArtifact(collectionid, artifactid, includeContent);
    }

    @ApiOperation(value="Get artifacts in a collection and Archival Unit", nickname="getArtifacts", notes="Get a list of all artifacts in a collection and Archival Unit or a pageful of the list defined by the continuation token and size", response=ArtifactPageInfo.class, tags={"collections"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested artifacts", response=ArtifactPageInfo.class), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=403, message="Client not authorized to retrieve data"), @ApiResponse(code=404, message="Collection not found"), @ApiResponse(code=502, message="Could not read from external resource")})
    @RequestMapping(value={"/collections/{collectionid}/aus/{auid}/artifacts"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<ArtifactPageInfo> getArtifacts(@ApiParam(value="Identifier of the collection containing the artifacts", required=true) @PathVariable(value="collectionid") String collectionid, @ApiParam(value="Identifier of the Archival Unit containing the artifacts", required=true) @PathVariable(value="auid") String auid, @ApiParam(value="The URL contained by the artifacts") @Valid @RequestParam(value="url", required=false) String url, @ApiParam(value="The prefix to be matched by the artifact URLs") @Valid @RequestParam(value="urlPrefix", required=false) String urlPrefix, @ApiParam(value="The version of the artifact") @Valid @RequestParam(value="version", required=false) String version, @ApiParam(value="Indication of whether uncommitted artifacts should be returned") @Valid @RequestParam(value="includeUncommitted", required=false) Boolean includeUncommitted, @ApiParam(value="The requested maximum number of artifacts per response") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="The continuation token of the next page of artifacts to be returned") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getArtifacts(collectionid, auid, url, urlPrefix, version, includeUncommitted, limit, continuationToken);
    }

    @ApiOperation(value="Get the size of Archival Unit artifacts in a collection", nickname="getArtifactsSize", notes="", response=Long.class, tags={"collections"})
    @ApiResponses(value={@ApiResponse(code=200, message="The size of the artifacts", response=Long.class), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=403, message="Client not authorized to retrieve data"), @ApiResponse(code=404, message="Collection not found"), @ApiResponse(code=502, message="Could not read from external resource")})
    @RequestMapping(value={"/collections/{collectionid}/aus/{auid}/size"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<Long> getArtifactsSize(@ApiParam(value="Identifier of the collection containing the artifacts", required=true) @PathVariable(value="collectionid") String collectionid, @ApiParam(value="Identifier of the Archival Unit containing the artifacts", required=true) @PathVariable(value="auid") String auid, @ApiParam(value="The URL contained by the artifacts") @Valid @RequestParam(value="url", required=false) String url, @ApiParam(value="The prefix to be matched by the artifact URLs") @Valid @RequestParam(value="urlPrefix", required=false) String urlPrefix, @ApiParam(value="The version of the artifact") @Valid @RequestParam(value="version", required=false) String version) {
        return this.getDelegate().getArtifactsSize(collectionid, auid, url, urlPrefix, version);
    }

    @ApiOperation(value="Get Archival Unit IDs (AUIDs) in a collection", nickname="getAus", notes="Get a list of all Archival Unit identifiers in a collection or a pageful of the list defined by the continuation token and size", response=AuidPageInfo.class, tags={"collections"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested Archival Unit identifiers", response=AuidPageInfo.class), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=403, message="Client not authorized to retrieve data"), @ApiResponse(code=404, message="Collection not found"), @ApiResponse(code=502, message="Could not read from external resource")})
    @RequestMapping(value={"/collections/{collectionid}/aus"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<AuidPageInfo> getAus(@ApiParam(value="Identifier of the collection containing the Archival Units", required=true) @PathVariable(value="collectionid") String collectionid, @ApiParam(value="The requested maximum number of Archival Unit identifiers per response") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="The continuation token of the next page of Archival Unit identifiers to be returned") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getAus(collectionid, limit, continuationToken);
    }

    @ApiOperation(value="Get collection identifiers of the committed artifacts in the repository", nickname="getCollections", notes="", response=String.class, responseContainer="List", tags={"collections"})
    @ApiResponses(value={@ApiResponse(code=200, message="Status 200", response=String.class, responseContainer="List")})
    @RequestMapping(value={"/collections"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<String>> getCollections() {
        return this.getDelegate().getCollections();
    }

    @ApiOperation(value="Update the committed property of an artifact", nickname="updateArtifact", notes="", response=Artifact.class, tags={"collections"})
    @ApiResponses(value={@ApiResponse(code=200, message="Artifact updated", response=Artifact.class), @ApiResponse(code=400, message="Invalid input"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=403, message="Client not authorized to update artifact"), @ApiResponse(code=404, message="Artifact not found")})
    @RequestMapping(value={"/collections/{collectionid}/artifacts/{artifactid}"}, produces={"application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.PUT})
    default public ResponseEntity<Artifact> updateArtifact(@ApiParam(value="Collection containing the artifact", required=true) @PathVariable(value="collectionid") String collectionid, @ApiParam(value="Identifier of the artifact", required=true) @PathVariable(value="artifactid") String artifactid, @ApiParam(value="New commit status of artifact") @RequestParam(value="committed", required=false) Boolean committed) {
        return this.getDelegate().updateArtifact(collectionid, artifactid, committed);
    }
}

