/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.lockss.laaws.rs.api.WarcsApiDelegate;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="warcs", description="the warcs API")
public interface WarcsApi {
    public WarcsApiDelegate getDelegate();

    @ApiOperation(value="Get a WARC archive", nickname="getWarcArchive", notes="Get the contents of a single WARC record as a WARC archive", response=Resource.class, tags={"wayback"})
    @ApiResponses(value={@ApiResponse(code=200, message="The contents of the requested WARC archive", response=Resource.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="WARC archive not found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/warcs/{fileName}"}, produces={"application/warc"}, method={RequestMethod.GET})
    default public ResponseEntity<Resource> getWarcArchive(@ApiParam(value="Name of the WARC archive", required=true) @PathVariable(value="fileName") String fileName, @ApiParam(value="The Accept header") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="The Accept-Encoding header") @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding, @ApiParam(value="The Range header") @RequestHeader(value="Range", required=false) String range) {
        return this.getDelegate().getWarcArchive(fileName, accept, acceptEncoding, range);
    }
}

