/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.configuration;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.lockss.app.LockssApp;
import org.lockss.config.Configuration;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.storage.ArtifactDataStore;
import org.lockss.laaws.rs.io.storage.hdfs.HdfsWarcArtifactDataStore;
import org.lockss.laaws.rs.io.storage.local.LocalWarcArtifactDataStore;
import org.lockss.laaws.rs.io.storage.local.TestingWarcArtifactDataStore;
import org.lockss.laaws.rs.io.storage.warc.VolatileWarcArtifactDataStore;
import org.lockss.log.L4JLogger;
import org.lockss.util.PatternIntMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.data.hadoop.config.annotation.builders.HadoopConfigBuilder;

@Configuration
public class ArtifactDataStoreConfig {
    public static final String PARAM_FREE_SPACE_MAP = "org.lockss.repo.testing.freeSpaceMap";
    private static final L4JLogger log = L4JLogger.getLogger();
    private static final String DATASTORE_SPEC_KEY = "repo.datastore.spec";
    private static final String HDFS_SERVER_KEY = "repo.datastore.hdfs.server";
    private static final String HDFS_BASEDIR_KEY = "repo.datastore.hdfs.basedir";
    public static final String LOCAL_BASEDIRS_KEY = "repo.datastore.local.basedirs";
    public static final String LOCAL_BASEDIRS_FALLBACK_KEY = "repo.datastore.local.basedir";
    @Resource
    private Environment env;
    @Autowired
    ArtifactIndex index;
    TestingWarcArtifactDataStore twads;

    @Bean
    public ArtifactDataStore setArtifactStore() throws Exception {
        String repoSpec = this.env.getProperty("repo.spec");
        String datastoreSpec = this.env.getProperty(DATASTORE_SPEC_KEY);
        if (!repoSpec.equals("custom")) {
            log.warn("Ignoring data store specification because a predefined repository specification is being used");
            return null;
        }
        if (datastoreSpec != null) {
            String dsType;
            switch (dsType = datastoreSpec.trim().toLowerCase()) {
                case "hdfs": {
                    String hdfsServer = this.env.getProperty(HDFS_SERVER_KEY);
                    Path hdfsBaseDir = Paths.get(this.env.getProperty(HDFS_BASEDIR_KEY), new String[0]);
                    log.info(String.format("Configuring HDFS artifact data store [%s, %s]", hdfsServer, hdfsBaseDir));
                    HadoopConfigBuilder config = new HadoopConfigBuilder();
                    config.fileSystemUri(hdfsServer);
                    return new HdfsWarcArtifactDataStore(this.index, (org.apache.hadoop.conf.Configuration)config.build(), hdfsBaseDir);
                }
                case "local": 
                case "testing": {
                    String baseDirsProp = this.env.getProperty(LOCAL_BASEDIRS_KEY);
                    if (baseDirsProp == null && (baseDirsProp = this.env.getProperty(LOCAL_BASEDIRS_FALLBACK_KEY)) == null) {
                        log.error("No local base directories specified");
                        throw new IllegalArgumentException("No local base dirs");
                    }
                    String[] dirs = baseDirsProp.split(";");
                    File[] baseDirs = (File[])Arrays.stream(dirs).map(File::new).toArray(File[]::new);
                    switch (dsType) {
                        case "local": {
                            log.info("Configuring local artifact data store [baseDirs: {}]", Arrays.asList(baseDirs));
                            return new LocalWarcArtifactDataStore(this.index, baseDirs);
                        }
                        case "testing": {
                            log.info("Configuring testing artifact data store [baseDirs: {}]", Arrays.asList(baseDirs));
                            this.twads = new TestingWarcArtifactDataStore(this.index, baseDirs);
                            return this.twads;
                        }
                    }
                    throw new RuntimeException("Shouldn't happen");
                }
                case "volatile": {
                    log.info("Configuring volatile artifact data store");
                    return new VolatileWarcArtifactDataStore(this.index);
                }
            }
            String errMsg = String.format("Unknown data store specification '%s'", datastoreSpec);
            log.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        log.warn("No artifact store specification set; setting ArtifactDataStore bean to null");
        return null;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConfigCallback() {
        if (this.twads != null) {
            LockssApp.getLockssApp().getConfigManager().registerConfigurationCallback((Configuration.Callback)new TestingArtifactDataStoreConfigCallback(this.twads));
        }
    }

    private static class TestingArtifactDataStoreConfigCallback
    implements Configuration.Callback {
        TestingWarcArtifactDataStore twads;

        TestingArtifactDataStoreConfigCallback(TestingWarcArtifactDataStore ds) {
            this.twads = ds;
        }

        public void configurationChanged(org.lockss.config.Configuration newConfig, org.lockss.config.Configuration oldConfig, Configuration.Differences changedKeys) {
            PatternIntMap freeSpacePatternMap = PatternIntMap.EMPTY;
            List lst = newConfig.getList(ArtifactDataStoreConfig.PARAM_FREE_SPACE_MAP, null);
            if (lst != null && !lst.isEmpty()) {
                try {
                    freeSpacePatternMap = new PatternIntMap(lst);
                }
                catch (IllegalArgumentException e) {
                    log.error("Illegal testing disk space map, ignoring", (Throwable)e);
                }
            }
            this.twads.setTestingDiskSpaceMap(freeSpacePatternMap);
        }
    }
}

