/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.configuration;

import java.io.File;
import javax.annotation.Resource;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.index.LocalArtifactIndex;
import org.lockss.laaws.rs.io.index.VolatileArtifactIndex;
import org.lockss.laaws.rs.io.index.solr.SolrArtifactIndex;
import org.lockss.log.L4JLogger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ArtifactIndexConfig {
    private static final L4JLogger log = L4JLogger.getLogger();
    private static final String INDEX_SPEC_KEY = "repo.index.spec";
    private static final String SOLR_BASEURL_KEY = "repo.index.solr.solrUrl";
    private static final String SOLR_COLLECTION_KEY = "repo.index.solr.solrCollection";
    @Resource
    private Environment env;

    @Bean
    public ArtifactIndex setArtifactIndex() {
        String repoSpec = this.env.getProperty("repo.spec");
        String indexSpec = this.env.getProperty(INDEX_SPEC_KEY);
        if (!repoSpec.equals("custom")) {
            log.warn("Ignoring index specification because a predefined repository specification is being used");
            return null;
        }
        log.info(String.format("indexSpec = %s", indexSpec));
        if (indexSpec != null) {
            switch (indexSpec.trim().toLowerCase()) {
                case "solr": {
                    String solrCollection = this.env.getProperty(SOLR_COLLECTION_KEY);
                    String solrBaseUrl = this.env.getProperty(SOLR_BASEURL_KEY);
                    if (solrCollection != null || !solrCollection.isEmpty()) {
                        return new SolrArtifactIndex(solrBaseUrl, solrCollection);
                    }
                    return new SolrArtifactIndex(solrBaseUrl);
                }
                case "volatile": {
                    return new VolatileArtifactIndex();
                }
                case "local": {
                    String baseDirsProp = this.env.getProperty("repo.datastore.local.basedirs");
                    if (baseDirsProp == null && (baseDirsProp = this.env.getProperty("repo.datastore.local.basedir")) == null) {
                        log.error("No local base directories specified");
                        throw new IllegalArgumentException("No local base dirs");
                    }
                    String[] baseDirs = baseDirsProp.split(";");
                    return new LocalArtifactIndex(new File(baseDirs[0]), this.env.getProperty("repo.persistIndexName"));
                }
            }
            String errMsg = String.format("Unknown index specification '%s'", indexSpec);
            log.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        log.warn("No artifact index specification set; setting ArtifactIndex bean to null");
        return null;
    }
}

