/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.configuration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.lockss.app.LockssDaemon;
import org.lockss.jms.JMSManager;
import org.lockss.laaws.rs.core.BaseLockssRepository;
import org.lockss.laaws.rs.core.LocalLockssRepository;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.laaws.rs.core.LockssRepositoryFactory;
import org.lockss.laaws.rs.core.RestLockssRepository;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.storage.ArtifactDataStore;
import org.lockss.laaws.rs.util.JmsFactorySource;
import org.lockss.log.L4JLogger;
import org.lockss.util.Deadline;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class LockssRepositoryConfig {
    private static final L4JLogger log = L4JLogger.getLogger();
    public static final String REPO_SPEC_KEY = "repo.spec";
    public static final String REPO_PERSISTINDEXNAME_KEY = "repo.persistIndexName";
    @Autowired
    ArtifactDataStore store;
    @Autowired
    ArtifactIndex index;
    @Resource
    private Environment env;

    @Bean
    public LockssRepository createInitializedRepository() throws IOException {
        LockssRepository repo = this.createRepository();
        repo.initRepository();
        new Thread(() -> this.initJmsFactory(repo)).start();
        return repo;
    }

    public LockssRepository createRepository() throws IOException {
        String repositorySpecification = this.env.getProperty(REPO_SPEC_KEY);
        String repositoryPersistIndexName = this.env.getProperty(REPO_PERSISTINDEXNAME_KEY);
        log.debug("Starting internal LOCKSS repository (repositorySpecification = {})", (Object)repositorySpecification);
        log.debug("repositoryPersistIndexName = {}", (Object)repositoryPersistIndexName);
        if (repositorySpecification != null) {
            switch (repositorySpecification.trim().toLowerCase()) {
                case "volatile": {
                    return LockssRepositoryFactory.createVolatileRepository();
                }
                case "custom": {
                    return new BaseLockssRepository(this.index, this.store);
                }
            }
            if (repositorySpecification.indexOf(58) >= 0) {
                String[] specParts = repositorySpecification.split(":", 2);
                String repositoryType = specParts[0].trim().toLowerCase();
                log.debug("repositoryType = {}", (Object)repositoryType);
                switch (repositoryType) {
                    case "local": {
                        String[] dirs = specParts[1].split(";");
                        File[] baseDirs = (File[])Arrays.stream(dirs).map(File::new).toArray(File[]::new);
                        log.trace("baseDirs = {}", Arrays.asList(baseDirs));
                        return new LocalLockssRepository(baseDirs, repositoryPersistIndexName);
                    }
                    case "rest": {
                        String repositoryRestUrl = specParts[1];
                        log.debug("repositoryRestUrl = {}", (Object)repositoryRestUrl);
                        List restClientCredentials = LockssDaemon.getLockssDaemon().getRestClientCredentials();
                        log.trace("restClientCredentials = {}", (Object)restClientCredentials);
                        String userName = null;
                        String password = null;
                        if (restClientCredentials != null && restClientCredentials.size() > 0) {
                            userName = (String)restClientCredentials.get(0);
                            log.trace("userName = " + userName);
                            if (restClientCredentials.size() > 1) {
                                password = (String)restClientCredentials.get(1);
                            }
                            if (userName == null || password == null) {
                                String errMsg = "No user has been configured for authentication";
                                log.error(errMsg);
                                throw new IllegalArgumentException(errMsg);
                            }
                        }
                        return new RestLockssRepository(new URL(repositoryRestUrl), userName, password);
                    }
                }
                String errMsg = String.format("Unknown repository type '%s'; cannot continue", repositoryType);
                log.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            String errMsg = String.format("Unknown repository specification '%s'", repositorySpecification);
            log.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        log.warn("No LOCKSS repository specification provided. Using volatile implementation!");
        return LockssRepositoryFactory.createVolatileRepository();
    }

    void initJmsFactory(LockssRepository repo) {
        if (repo instanceof JmsFactorySource) {
            JmsFactorySource jmsSource = (JmsFactorySource)repo;
            LockssDaemon daemon = null;
            while (daemon == null) {
                try {
                    daemon = LockssDaemon.getLockssDaemon();
                }
                catch (IllegalStateException e) {
                    log.warn("getLockssDaemon() timed out");
                }
            }
            try {
                while (!daemon.waitUntilAppRunning((org.lockss.util.time.Deadline)Deadline.in((long)300000L))) {
                }
                JMSManager mgr = (JMSManager)daemon.getManagerByType(JMSManager.class);
                jmsSource.setJmsFactory(mgr.getJmsFactory());
                log.info("Stored JmsFactory in {}", (Object)jmsSource);
            }
            catch (IllegalArgumentException e) {
                log.warn("Couldn't get JmsManager", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

