/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import java.io.IOException;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.log.L4JLogger;
import org.lockss.spring.error.LockssRestServiceException;
import org.springframework.http.HttpStatus;

public class ServiceImplUtil {
    private static L4JLogger log = L4JLogger.getLogger();
    private static String archiveFileExtension = ".warc";
    private static String archiveFileSeparator = ":";

    static String getFullRequestUrl(HttpServletRequest request) {
        if (request.getQueryString() == null || request.getQueryString().trim().isEmpty()) {
            return "'" + request.getMethod() + " " + request.getRequestURL() + "'";
        }
        return "'" + request.getMethod() + " " + request.getRequestURL() + "?" + request.getQueryString() + "'";
    }

    static void checkRepositoryReady(LockssRepository repo, String parsedRequest) {
        if (!repo.isReady()) {
            String errorMessage = "LOCKSS repository is not ready";
            throw new LockssRestServiceException(HttpStatus.SERVICE_UNAVAILABLE, errorMessage, parsedRequest);
        }
    }

    static void validateCollectionId(LockssRepository repo, String collectionid, String parsedRequest) throws IOException {
        log.debug2("repo = {}, collectionid = {}, parsedRequest = {}", (Object)repo, (Object)collectionid, (Object)parsedRequest);
        log.trace("repo.getCollectionIds().iterator().hasNext() = {}", (Object)repo.getCollectionIds().iterator().hasNext());
        for (String collectionInRepository : repo.getCollectionIds()) {
            log.trace("collectionInRepository = {}", (Object)collectionInRepository);
        }
        if (!StreamSupport.stream(repo.getCollectionIds().spliterator(), false).anyMatch(name -> collectionid.equals(name))) {
            String errorMessage = "The collection does not exist";
            log.warn(errorMessage);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(HttpStatus.NOT_FOUND, errorMessage, parsedRequest);
        }
        log.debug2("collectionid '{}' is valid.", (Object)collectionid);
    }

    static void validatePagination(Integer count, Integer startPage, String parsedRequest) {
        log.debug2("count = {}", (Object)count);
        log.debug2("startPage = {}", (Object)startPage);
        log.debug2("parsedRequest = {}", (Object)parsedRequest);
        if (count == null && startPage == null) {
            log.debug2("Pagination request parameters are valid");
            return;
        }
        if (count != null && startPage != null && count > 0 && startPage > 0) {
            log.debug2("Pagination request parameters are valid");
            return;
        }
        String errorMessage = "Invalid pagination request: count = " + count + ", startPage = " + startPage;
        log.error(errorMessage);
        throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
    }

    static String getArtifactArchiveName(String collectionid, String artifactId) {
        return collectionid + archiveFileSeparator + artifactId + archiveFileExtension;
    }

    static String getArchiveFilenameCollectionId(String fileName, String parsedRequest) {
        int separatorLocation = ServiceImplUtil.getArchiveFilenameSeparator(fileName, parsedRequest);
        return fileName.substring(0, separatorLocation);
    }

    static String getArchiveFilenameArtifactId(String fileName, String parsedRequest) {
        int separatorLocation = ServiceImplUtil.getArchiveFilenameSeparator(fileName, parsedRequest);
        return fileName.substring(separatorLocation + archiveFileSeparator.length(), fileName.length() - archiveFileExtension.length());
    }

    private static int getArchiveFilenameSeparator(String fileName, String parsedRequest) {
        int separatorLocation = fileName.lastIndexOf(archiveFileSeparator);
        log.trace("separatorLocation = {}", (Object)separatorLocation);
        if (separatorLocation < 1) {
            String errorMessage = "Missing separator '" + archiveFileSeparator + "' in filename: " + fileName;
            log.error(errorMessage);
            throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
        }
        return separatorLocation;
    }

    static String toJsonError(int code, String message) {
        JSONObject errorElement = new JSONObject();
        errorElement.put("code", code);
        if (message == null) {
            message = "";
        }
        errorElement.put("message", (Object)message);
        JSONObject responseBody = new JSONObject();
        responseBody.put("error", (Object)errorElement);
        return responseBody.toString();
    }
}

