/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.lockss.laaws.rs.api.WarcsApiDelegate;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.laaws.rs.impl.ServiceImplUtil;
import org.lockss.laaws.rs.io.storage.warc.WarcArtifactDataStore;
import org.lockss.laaws.rs.model.ArtifactData;
import org.lockss.log.L4JLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class WarcsApiServiceImpl
implements WarcsApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    @Autowired
    LockssRepository repo;
    private final HttpServletRequest request;

    @Autowired
    public WarcsApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public ResponseEntity<Resource> getWarcArchive(String fileName, String accept, String acceptEncoding, String range) {
        log.debug2("fileName = {}", (Object)fileName);
        log.debug2("accept = {}", (Object)accept);
        log.debug2("acceptEncoding = {}", (Object)acceptEncoding);
        log.debug2("range = {}", (Object)range);
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            log.trace("header name = {}, value = {}", (Object)name, (Object)this.request.getHeader(name));
        }
        log.trace("parameterMap = {}", (Object)this.request.getParameterMap());
        String parsedRequest = String.format("fileName: %s, requestUrl: %s", fileName, ServiceImplUtil.getFullRequestUrl(this.request));
        log.trace("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        try {
            String collectionId = ServiceImplUtil.getArchiveFilenameCollectionId(fileName, parsedRequest);
            log.trace("collectionId = {}", (Object)collectionId);
            String artifactId = ServiceImplUtil.getArchiveFilenameArtifactId(fileName, parsedRequest);
            log.trace("artifactId = {}", (Object)artifactId);
            ArtifactData artifactData = this.repo.getArtifactData(collectionId, artifactId);
            log.trace("artifactData = {}", (Object)artifactData);
            if (artifactData == null) {
                throw new IllegalArgumentException("No artifact '" + artifactId + "' in repository");
            }
            InputStream inputStream = null;
            long warcRecordLength = 0L;
            File warcRecordFile = File.createTempFile("getWarcArchive", ".warc");
            warcRecordFile.deleteOnExit();
            try (DeferredFileOutputStream dfos = new DeferredFileOutputStream(0x100000, warcRecordFile);){
                WarcArtifactDataStore.writeArtifactData((ArtifactData)artifactData, (OutputStream)dfos);
                dfos.close();
                if (dfos.isInMemory()) {
                    log.trace("WARC record is in memory");
                    byte[] warcRecordBytes = dfos.getData();
                    warcRecordLength = warcRecordBytes.length;
                    inputStream = new ByteArrayInputStream(warcRecordBytes);
                } else {
                    log.trace("WARC record is in in file '{}'", (Object)warcRecordFile);
                    warcRecordLength = warcRecordFile.length();
                    inputStream = new FileInputStream(warcRecordFile);
                }
            }
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/warc");
            headers.setContentLength(warcRecordLength);
            log.trace("headers = {}", (Object)headers);
            return new ResponseEntity((Object)new InputStreamResource(inputStream), (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "Cannot get the archive for fileName = '" + fileName + "'";
            log.error(message, (Throwable)iae);
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, message, iae);
        }
        catch (Exception e) {
            String message = "Cannot get the archive for fileName = '" + fileName + "'";
            log.error(message, (Throwable)e);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
    }

    private ResponseEntity<Resource> getErrorResponseEntity(HttpStatus status, String message, Exception e) {
        String errorMessage = message;
        if (e != null) {
            errorMessage = errorMessage == null ? e.getMessage() : errorMessage + " - " + e.getMessage();
        }
        String result = ServiceImplUtil.toJsonError(status.value(), errorMessage);
        ByteArrayInputStream is = new ByteArrayInputStream(result.getBytes(Charset.forName("UTF-8")));
        return new ResponseEntity((Object)new InputStreamResource((InputStream)is), status);
    }
}

