package org.lockss.laaws.rs.api;

import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactPageInfo;
import org.lockss.laaws.rs.model.AuidPageInfo;
import org.springframework.core.io.Resource;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;

/**
 * A delegate to be called by the {@link CollectionsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */

public interface CollectionsApiDelegate {

    Logger log = LoggerFactory.getLogger(CollectionsApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    /**
     * @see CollectionsApi#createArtifact
     */
    default ResponseEntity<Artifact> createArtifact( String  collectionid,
         String  auid,
         String  uri,
        MultipartFile artifact,
         Long  collectionDate) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"auid\" : \"auid\",  \"committed\" : true,  \"id\" : \"id\",  \"collection\" : \"collection\",  \"uri\" : \"uri\",  \"version\" : 0,  \"storageUrl\" : \"storageUrl\",  \"collectionDate\" : 1,  \"originDate\" : 6}", Artifact.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CollectionsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see CollectionsApi#deleteArtifact
     */
    default ResponseEntity<Void> deleteArtifact( String  collectionid,
         String  artifactid) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CollectionsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see CollectionsApi#getArtifact
     */
    default ResponseEntity<Resource> getArtifact( String  collectionid,
         String  artifactid,
         String  includeContent) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("", Resource.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type ", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CollectionsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see CollectionsApi#getArtifacts
     */
    default ResponseEntity<ArtifactPageInfo> getArtifacts( String  collectionid,
         String  auid,
         String  url,
         String  urlPrefix,
         String  version,
         Boolean  includeUncommitted,
         Integer  limit,
         String  continuationToken) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"pageInfo\" : {    \"curLink\" : \"curLink\",    \"resultsPerPage\" : 5,    \"totalCount\" : 5,    \"continuationToken\" : \"continuationToken\",    \"nextLink\" : \"nextLink\"  },  \"artifacts\" : [ {    \"auid\" : \"auid\",    \"committed\" : true,    \"id\" : \"id\",    \"collection\" : \"collection\",    \"uri\" : \"uri\",    \"version\" : 0,    \"storageUrl\" : \"storageUrl\",    \"collectionDate\" : 1,    \"originDate\" : 6  }, {    \"auid\" : \"auid\",    \"committed\" : true,    \"id\" : \"id\",    \"collection\" : \"collection\",    \"uri\" : \"uri\",    \"version\" : 0,    \"storageUrl\" : \"storageUrl\",    \"collectionDate\" : 1,    \"originDate\" : 6  } ]}", ArtifactPageInfo.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CollectionsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see CollectionsApi#getArtifactsAllVersionsAllAus
     */
    default ResponseEntity<ArtifactPageInfo> getArtifactsAllVersionsAllAus( String  collectionid,
         String  url,
         String  urlPrefix,
         Integer  limit,
         String  continuationToken) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"pageInfo\" : {    \"curLink\" : \"curLink\",    \"resultsPerPage\" : 5,    \"totalCount\" : 5,    \"continuationToken\" : \"continuationToken\",    \"nextLink\" : \"nextLink\"  },  \"artifacts\" : [ {    \"auid\" : \"auid\",    \"committed\" : true,    \"id\" : \"id\",    \"collection\" : \"collection\",    \"uri\" : \"uri\",    \"version\" : 0,    \"storageUrl\" : \"storageUrl\",    \"collectionDate\" : 1,    \"originDate\" : 6  }, {    \"auid\" : \"auid\",    \"committed\" : true,    \"id\" : \"id\",    \"collection\" : \"collection\",    \"uri\" : \"uri\",    \"version\" : 0,    \"storageUrl\" : \"storageUrl\",    \"collectionDate\" : 1,    \"originDate\" : 6  } ]}", ArtifactPageInfo.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CollectionsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see CollectionsApi#getArtifactsSize
     */
    default ResponseEntity<Long> getArtifactsSize( String  collectionid,
         String  auid,
         String  url,
         String  urlPrefix,
         String  version) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("0", Long.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CollectionsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see CollectionsApi#getAus
     */
    default ResponseEntity<AuidPageInfo> getAus( String  collectionid,
         Integer  limit,
         String  continuationToken) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"pageInfo\" : {    \"curLink\" : \"curLink\",    \"resultsPerPage\" : 5,    \"totalCount\" : 5,    \"continuationToken\" : \"continuationToken\",    \"nextLink\" : \"nextLink\"  },  \"auids\" : [ \"auids\", \"auids\" ]}", AuidPageInfo.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CollectionsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see CollectionsApi#getCollections
     */
    default ResponseEntity<List<String>> getCollections() {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CollectionsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see CollectionsApi#updateArtifact
     */
    default ResponseEntity<Artifact> updateArtifact( String  collectionid,
         String  artifactid,
         Boolean  committed) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"auid\" : \"auid\",  \"committed\" : true,  \"id\" : \"id\",  \"collection\" : \"collection\",  \"uri\" : \"uri\",  \"version\" : 0,  \"storageUrl\" : \"storageUrl\",  \"collectionDate\" : 1,  \"originDate\" : 6}", Artifact.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CollectionsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
