/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.configuration;

import java.io.IOException;
import java.util.List;
import org.lockss.app.LockssApp;
import org.lockss.laaws.rs.configuration.RepositoryServiceProperties;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.index.LocalArtifactIndex;
import org.lockss.laaws.rs.io.index.VolatileArtifactIndex;
import org.lockss.laaws.rs.io.index.solr.SolrArtifactIndex;
import org.lockss.log.L4JLogger;
import org.lockss.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ArtifactIndexConfig {
    private static final L4JLogger log = L4JLogger.getLogger();
    private RepositoryServiceProperties repoProps;
    @Autowired
    private ApplicationArguments appArgs;

    @Autowired
    public ArtifactIndexConfig(RepositoryServiceProperties repoProps) {
        this.repoProps = repoProps;
    }

    @Bean
    public ArtifactIndex setArtifactIndex() {
        return this.createArtifactIndex(this.parseIndexSpecs());
    }

    private String parseIndexSpecs() {
        switch (this.repoProps.getRepositoryType()) {
            case "volatile": {
                return "volatile";
            }
            case "local": {
                return "local";
            }
            case "custom": {
                return this.repoProps.getIndexSpec();
            }
        }
        throw new IllegalArgumentException("Repository spec not supported: " + this.repoProps.getRepositorySpec());
    }

    private ArtifactIndex createArtifactIndex(String indexType) {
        log.trace("indexType = {}", (Object)indexType);
        switch (indexType) {
            case "volatile": {
                return new VolatileArtifactIndex();
            }
            case "local": {
                return new LocalArtifactIndex(this.repoProps.getLocalBaseDirs()[0], this.repoProps.getLocalPersistIndexName());
            }
            case "solr": {
                List<String> credentials = this.getSolrCredentials();
                if (!StringUtil.isNullString((String)this.repoProps.getSolrCollectionName())) {
                    return new SolrArtifactIndex(this.repoProps.getSolrEndpoint(), this.repoProps.getSolrCollectionName(), credentials);
                }
                return new SolrArtifactIndex(this.repoProps.getSolrEndpoint(), credentials);
            }
        }
        String errMsg = String.format("Unknown artifact index: '%s'", indexType);
        log.error(errMsg);
        throw new IllegalArgumentException(errMsg);
    }

    private List<String> getSolrCredentials() {
        log.debug("getNonOptionArgs: {}", (Object)this.appArgs.getNonOptionArgs());
        LockssApp.StartupOptions startOpts = LockssApp.getStartupOptions((List)this.appArgs.getNonOptionArgs());
        String filename = startOpts.getSecretFileFor("solr");
        if (filename != null) {
            try {
                LockssApp.ClientCredentials cred = LockssApp.readClientCredentials((String)filename);
                return cred.getCredentialsAsList();
            }
            catch (IOException e) {
                log.warn("Couldn't read SOLR credentials from file {}", (Object)filename, (Object)e);
            }
        }
        return null;
    }
}

