/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.configuration;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.lockss.app.LockssDaemon;
import org.lockss.jms.JMSManager;
import org.lockss.laaws.rs.configuration.RepositoryServiceProperties;
import org.lockss.laaws.rs.core.BaseLockssRepository;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.laaws.rs.core.RestLockssRepository;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.storage.ArtifactDataStore;
import org.lockss.laaws.rs.util.JmsFactorySource;
import org.lockss.log.L4JLogger;
import org.lockss.util.Deadline;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LockssRepositoryConfig {
    private static final L4JLogger log = L4JLogger.getLogger();
    private final RepositoryServiceProperties repoProps;
    private ArtifactDataStore store;
    private ArtifactIndex index;

    @Autowired
    public LockssRepositoryConfig(RepositoryServiceProperties repoProps, ArtifactIndex index, ArtifactDataStore store) {
        this.repoProps = repoProps;
        this.index = index;
        this.store = store;
    }

    @Bean
    public LockssRepository createInitializedRepository() throws IOException {
        LockssRepository repo = this.createLockssRepository();
        repo.initRepository();
        new Thread(() -> this.initJmsFactory(repo)).start();
        return repo;
    }

    public LockssRepository createLockssRepository() throws IOException {
        log.debug("Starting internal LOCKSS repository [repoSpec: {}]", (Object)this.repoProps.getRepositorySpec());
        switch (this.repoProps.getRepositoryType()) {
            case "volatile": 
            case "local": 
            case "custom": {
                return new BaseLockssRepository(this.index, this.store);
            }
            case "rest": {
                if (this.repoProps.getRepoSpecParts().length <= 1) {
                    log.error("No REST endpoint specified");
                    throw new IllegalArgumentException("No REST endpoint specified");
                }
                String repositoryRestUrl = this.repoProps.getRepoSpecParts()[1];
                log.debug("repositoryRestUrl = {}", (Object)repositoryRestUrl);
                List restClientCredentials = LockssDaemon.getLockssDaemon().getRestClientCredentials();
                log.trace("restClientCredentials = {}", (Object)restClientCredentials);
                String userName = null;
                String password = null;
                if (restClientCredentials != null && restClientCredentials.size() > 0) {
                    userName = (String)restClientCredentials.get(0);
                    log.trace("userName = " + userName);
                    if (restClientCredentials.size() > 1) {
                        password = (String)restClientCredentials.get(1);
                    }
                    if (userName == null || password == null) {
                        String errMsg = "No user has been configured for authentication";
                        log.error(errMsg);
                        throw new IllegalArgumentException(errMsg);
                    }
                }
                return new RestLockssRepository(new URL(repositoryRestUrl), userName, password);
            }
        }
        String errMsg = String.format("Unknown repository specification '%s'", this.repoProps.getRepositorySpec());
        log.error(errMsg);
        throw new IllegalArgumentException(errMsg);
    }

    void initJmsFactory(LockssRepository repo) {
        if (repo instanceof JmsFactorySource) {
            JmsFactorySource jmsSource = (JmsFactorySource)repo;
            LockssDaemon daemon = null;
            while (daemon == null) {
                try {
                    daemon = LockssDaemon.getLockssDaemon();
                }
                catch (IllegalStateException e) {
                    log.warn("getLockssDaemon() timed out");
                }
            }
            try {
                while (!daemon.waitUntilAppRunning((org.lockss.util.time.Deadline)Deadline.in((long)300000L))) {
                }
                JMSManager mgr = (JMSManager)daemon.getManagerByType(JMSManager.class);
                jmsSource.setJmsFactory(mgr.getJmsFactory());
                log.info("Stored JmsFactory in {}", (Object)jmsSource);
            }
            catch (IllegalArgumentException e) {
                log.warn("Couldn't get JmsManager", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

