/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import java.util.Vector;
import org.lockss.log.L4JLogger;
import org.lockss.util.StringUtil;
import org.lockss.util.UrlUtil;

public class ArtifactContinuationToken {
    private static final L4JLogger log = L4JLogger.getLogger();
    private static final String separator = ":";
    private String collectionId = null;
    private String auid = null;
    private String uri = null;
    private Integer version = null;
    private Integer iteratorHashCode = null;

    public ArtifactContinuationToken(String webRequestContinuationToken) throws IllegalArgumentException {
        log.debug2("webRequestContinuationToken = {}", (Object)webRequestContinuationToken);
        String message = "Invalid web request continuation token '" + webRequestContinuationToken + "'";
        if (webRequestContinuationToken != null && !webRequestContinuationToken.trim().isEmpty()) {
            Vector tokenItems = null;
            try {
                tokenItems = StringUtil.breakAt((String)webRequestContinuationToken.trim(), (String)separator);
                log.trace("tokenItems = {}", (Object)tokenItems);
                this.collectionId = UrlUtil.decodeUrl((String)((String)tokenItems.get(0)).trim());
                log.trace("collectionId = {}", (Object)this.collectionId);
                this.auid = UrlUtil.decodeUrl((String)((String)tokenItems.get(1)).trim());
                log.trace("auid = {}", (Object)this.auid);
                this.uri = UrlUtil.decodeUrl((String)((String)tokenItems.get(2)).trim());
                log.trace("uri = {}", (Object)this.uri);
                this.version = Integer.valueOf(((String)tokenItems.get(3)).trim());
                log.trace("version = {}", (Object)this.version);
                this.iteratorHashCode = Integer.valueOf(((String)tokenItems.get(4)).trim());
                log.trace("iteratorHashCode = {}", (Object)this.iteratorHashCode);
            }
            catch (Exception e) {
                log.warn(message, (Throwable)e);
                throw new IllegalArgumentException(message, e);
            }
            if (tokenItems.size() != 5) {
                log.warn(message);
                throw new IllegalArgumentException(message);
            }
            this.validateMembers();
        }
    }

    public ArtifactContinuationToken(String collectionId, String auid, String uri, Integer version, Integer iteratorHashCode) {
        this.collectionId = collectionId;
        this.auid = auid;
        this.uri = uri;
        this.version = version;
        this.iteratorHashCode = iteratorHashCode;
        this.validateMembers();
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public String getAuid() {
        return this.auid;
    }

    public String getUri() {
        return this.uri;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getIteratorHashCode() {
        return this.iteratorHashCode;
    }

    public String toWebResponseContinuationToken() {
        if (this.collectionId != null && this.auid != null && this.uri != null && this.version != null && this.iteratorHashCode != null) {
            String encodedToken = UrlUtil.encodeUrl((String)this.collectionId) + separator + UrlUtil.encodeUrl((String)this.auid) + separator + UrlUtil.encodeUrl((String)this.uri) + separator + this.version + separator + this.iteratorHashCode;
            log.trace("encodedToken = {}", (Object)encodedToken);
            return encodedToken;
        }
        String message = "Cannot get web request continuation token from " + this;
        log.warn(message);
        throw new IllegalArgumentException(message);
    }

    public String toString() {
        return "[ArtifactContinuationToken collectionId=" + this.collectionId + ", auid=" + this.auid + ", uri=" + this.uri + ", version=" + this.version + ", iteratorHashCode=" + this.iteratorHashCode + "]";
    }

    private void validateMembers() {
        if (this.collectionId == null && this.auid == null && this.uri == null && this.version == null && this.iteratorHashCode != null || this.collectionId != null && this.auid != null && this.uri != null && this.version != null && this.iteratorHashCode == null) {
            String message = "Invalid member combination: collectionId = '" + this.collectionId + "', auid = '" + this.auid + "', uri = '" + this.uri + "', version = '" + this.version + "', iteratorHashCode = '" + this.iteratorHashCode + "'";
            log.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this.collectionId != null && this.collectionId.isEmpty()) {
            String message = "Invalid member: collectionId = '" + this.collectionId + "'";
            log.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this.auid != null && this.auid.isEmpty()) {
            String message = "Invalid member: auid = '" + this.auid + "'";
            log.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this.uri != null && this.uri.isEmpty()) {
            String message = "Invalid member: uri = '" + this.uri + "'";
            log.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this.version != null && this.version <= 0) {
            String message = "Invalid member: version = '" + this.version + "'";
            log.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this.iteratorHashCode != null && this.iteratorHashCode <= 0) {
            String message = "Invalid member: iteratorHashCode = '" + this.iteratorHashCode + "'";
            log.warn(message);
            throw new IllegalArgumentException(message);
        }
    }
}

