/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.configuration;

import java.io.File;
import java.util.Arrays;
import org.lockss.log.L4JLogger;
import org.lockss.util.StringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RepositoryServiceProperties {
    private static final L4JLogger log = L4JLogger.getLogger();
    @Value(value="${repo.spec}")
    String repoSpec;
    @Value(value="${repo.state.dir:/data/state}")
    String repoStateDir;
    @Value(value="${repo.datastore.spec:#{null}}")
    String datastoreSpec;
    @Value(value="${repo.datastore.local.basedirs:#{null}}")
    String localBaseDirs;
    @Value(value="${repo.datastore.local.basedir:#{null}}")
    String localbaseDir;
    @Value(value="${repo.datastore.hdfs.server:#{null}}")
    String hdfsEndpoint;
    @Value(value="${repo.datastore.hdfs.basedir:#{null}}")
    String hdfsBaseDir;
    @Value(value="${repo.index.spec:#{null}}")
    String indexSpec;
    @Value(value="${repo.persistIndexName:#{null}}")
    String repoPersistIndexName;
    @Value(value="${repo.index.local.persistIndexName:#{null}}")
    String localPersistIndexName;
    @Value(value="${repo.index.solr.solrUrl:#{null}}")
    String solrEndpoint;
    @Value(value="${repo.index.solr.solrCollection:#{null}}")
    String solrCollectionName;
    @Value(value="${repo.index.solr.hardCommitInterval:15000}")
    long solrHardCommitInterval;

    public String getRepositorySpec() {
        return this.repoSpec;
    }

    public String getRepositoryType() {
        return this.getRepoSpecParts()[0].trim().toLowerCase();
    }

    public String[] getRepoSpecParts() {
        if (StringUtil.isNullString((String)this.repoSpec)) {
            log.error("Missing repository configuration");
            throw new IllegalStateException("Repository not configured");
        }
        return this.repoSpec.split(":", 2);
    }

    public String getIndexSpec() {
        if (StringUtil.isNullString((String)this.indexSpec)) {
            log.error("Missing artifact index configuration");
            throw new IllegalStateException("Artifact index not configured");
        }
        return this.indexSpec.trim().toLowerCase();
    }

    public String getLocalPersistIndexName() {
        if (this.localPersistIndexName == null) {
            this.localPersistIndexName = this.repoPersistIndexName;
            if (this.localPersistIndexName == null) {
                log.error("No local persist index name specified");
                throw new IllegalArgumentException("No local persist index name");
            }
        }
        return this.localPersistIndexName;
    }

    public File[] getLocalBaseDirs() {
        if (this.localBaseDirs == null) {
            this.localBaseDirs = this.localbaseDir;
            if (this.localBaseDirs == null) {
                log.error("No local base directories specified");
                throw new IllegalArgumentException("No local base dirs");
            }
        }
        return (File[])Arrays.stream(this.localBaseDirs.split(";")).map(File::new).toArray(File[]::new);
    }

    public String getSolrEndpoint() {
        if (StringUtil.isNullString((String)this.solrEndpoint)) {
            log.error("Missing Solr base URL endpoint");
            throw new IllegalArgumentException("Missing Solr base URL endpoint");
        }
        return this.solrEndpoint;
    }

    public String getSolrCollectionName() {
        return this.solrCollectionName;
    }

    public long getSolrHardCommitInterval() {
        return this.solrHardCommitInterval;
    }

    public String getDatastoreSpec() {
        return this.datastoreSpec.trim().toLowerCase();
    }

    public String getHdfsEndpoint() {
        return this.hdfsEndpoint;
    }

    public String getHdfsBaseDir() {
        return this.hdfsBaseDir;
    }

    public File getRepositoryStateDir() {
        return new File(this.repoStateDir);
    }
}

