/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.IterableUtils;
import org.apache.http.StatusLine;
import org.lockss.config.Configuration;
import org.lockss.laaws.rs.api.CollectionsApiDelegate;
import org.lockss.laaws.rs.core.ArtifactCache;
import org.lockss.laaws.rs.core.LockssNoSuchArtifactIdException;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.laaws.rs.core.RestLockssRepository;
import org.lockss.laaws.rs.impl.ArtifactContinuationToken;
import org.lockss.laaws.rs.impl.AuidContinuationToken;
import org.lockss.laaws.rs.impl.ServiceImplUtil;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactData;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.model.ArtifactPageInfo;
import org.lockss.laaws.rs.model.ArtifactVersions;
import org.lockss.laaws.rs.model.AuidPageInfo;
import org.lockss.laaws.rs.model.PageInfo;
import org.lockss.laaws.rs.util.ArtifactComparators;
import org.lockss.laaws.rs.util.ArtifactDataFactory;
import org.lockss.laaws.rs.util.ArtifactDataUtil;
import org.lockss.laaws.rs.util.NamedByteArrayResource;
import org.lockss.laaws.rs.util.NamedInputStreamResource;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.base.LockssConfigurableService;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.StringUtil;
import org.lockss.util.TimerQueue;
import org.lockss.util.UrlUtil;
import org.lockss.util.jms.JmsUtil;
import org.lockss.util.rest.exception.LockssRestHttpException;
import org.lockss.util.time.Deadline;
import org.lockss.util.time.TimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CollectionsApiServiceImpl
extends BaseSpringApiServiceImpl
implements CollectionsApiDelegate,
LockssConfigurableService {
    private static L4JLogger log = L4JLogger.getLogger();
    private static final String APPLICATION_HTTP_RESPONSE_VALUE = "application/http;msgtype=response";
    private static final MediaType APPLICATION_HTTP_RESPONSE = MediaType.parseMediaType((String)"application/http;msgtype=response");
    public static final String PREFIX = "org.lockss.repository.";
    public static final String PARAM_DEFAULT_ARTIFACT_PAGESIZE = "org.lockss.repository.artifact.pagesize.default";
    public static final int DEFAULT_DEFAULT_ARTIFACT_PAGESIZE = 1000;
    public static final String PARAM_MAX_ARTIFACT_PAGESIZE = "org.lockss.repository.artifact.pagesize.max";
    public static final int DEFAULT_MAX_ARTIFACT_PAGESIZE = 2000;
    public static final String PARAM_DEFAULT_AUID_PAGESIZE = "org.lockss.repository.auid.pagesize.default";
    public static final int DEFAULT_DEFAULT_AUID_PAGESIZE = 1000;
    public static final String PARAM_MAX_AUID_PAGESIZE = "org.lockss.repository.auid.pagesize.max";
    public static final int DEFAULT_MAX_AUID_PAGESIZE = 2000;
    public static final String PARAM_SMALL_CONTENT_THRESHOLD = "org.lockss.repository.smallContentThreshold";
    public static final long DEFAULT_SMALL_CONTENT_THRESHOLD = 4096L;
    @Autowired
    LockssRepository repo;
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;
    private Map<Integer, Iterator<Artifact>> artifactIterators = new ConcurrentHashMap<Integer, Iterator<Artifact>>();
    private TimerQueue.Callback artifactIteratorTimeoutCallback = new TimerQueue.Callback(){

        public void timerExpired(Object cookie) {
            CollectionsApiServiceImpl.this.artifactIterators.remove((Integer)cookie);
        }
    };
    private Map<Integer, Iterator<String>> auidIterators = new ConcurrentHashMap<Integer, Iterator<String>>();
    private TimerQueue.Callback auidIteratorTimeoutCallback = new TimerQueue.Callback(){

        public void timerExpired(Object cookie) {
            CollectionsApiServiceImpl.this.auidIterators.remove((Integer)cookie);
        }
    };
    private int maxArtifactPageSize = 2000;
    private int defaultArtifactPageSize = 1000;
    private int maxAuidPageSize = 2000;
    private int defaultAuidPageSize = 1000;
    private long smallContentThreshold = 4096L;

    @Autowired
    public CollectionsApiServiceImpl(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    @PostConstruct
    private void init() {
        this.setUpJms(this.JMS_BOTH, RestLockssRepository.REST_ARTIFACT_CACHE_ID, "ArtifactCacheTopic", new CacheInvalidateListener());
    }

    public void setConfig(Configuration newConfig, Configuration prevConfig, Configuration.Differences changedKeys) {
        if (changedKeys.contains(PREFIX)) {
            this.defaultArtifactPageSize = newConfig.getInt(PARAM_DEFAULT_ARTIFACT_PAGESIZE, 1000);
            this.maxArtifactPageSize = newConfig.getInt(PARAM_MAX_ARTIFACT_PAGESIZE, 2000);
            this.defaultAuidPageSize = newConfig.getInt(PARAM_DEFAULT_AUID_PAGESIZE, 1000);
            this.maxAuidPageSize = newConfig.getInt(PARAM_MAX_AUID_PAGESIZE, 2000);
            this.smallContentThreshold = newConfig.getLong(PARAM_SMALL_CONTENT_THRESHOLD, 4096L);
        }
    }

    protected void jmsSetUpDone() {
        this.sendCacheFlush();
    }

    @Override
    public ResponseEntity<List<String>> getCollections() {
        String parsedRequest = String.format("requestUrl: %s", ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        try {
            List collectionIds = IterableUtils.toList((Iterable)this.repo.getCollectionIds());
            log.debug2("collectionIds = {}", (Object)collectionIds);
            return new ResponseEntity((Object)collectionIds, HttpStatus.OK);
        }
        catch (IOException e) {
            String errorMessage = "Could not enumerate collection IDs";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    @Override
    public ResponseEntity<Void> deleteArtifact(String collectionid, String artifactid) {
        String parsedRequest = String.format("collectionid: %s, artifactid: %s, requestUrl: %s", collectionid, artifactid, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        try {
            String key = this.artifactKey(collectionid, artifactid);
            this.repo.deleteArtifact(collectionid, artifactid);
            this.sendCacheInvalidate(ArtifactCache.InvalidateOp.Delete, key);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (LockssNoSuchArtifactIdException e) {
            throw new LockssRestServiceException("Artifact not found", (Throwable)e).setUtcTimestamp(LocalDateTime.now(ZoneOffset.UTC)).setHttpStatus(HttpStatus.NOT_FOUND).setServletPath(this.request.getServletPath()).setServerErrorType(LockssRestHttpException.ServerErrorType.DATA_ERROR).setParsedRequest(parsedRequest);
        }
        catch (IOException e) {
            String errorMessage = String.format("IOException occurred while attempting to delete artifact from repository (artifactId: %s)", artifactid);
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.APPLICATION_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    public ResponseEntity getArtifact(String collectionid, String artifactid, String includeContent) {
        String parsedRequest = String.format("collectionid: %s, artifactid: %s, includeContent: %s, requestUrl: %s", collectionid, artifactid, includeContent, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        try {
            log.debug2("Retrieving artifact [artifactId: {}, collectionId: {}]", (Object)artifactid, (Object)collectionid);
            ArtifactData artifactData = this.repo.getArtifactData(collectionid, artifactid);
            MultiValueMap<String, Object> parts = CollectionsApiServiceImpl.generateMultipartResponseFromArtifactData(artifactData, LockssRepository.IncludeContent.valueOf((String)includeContent), this.smallContentThreshold);
            return new ResponseEntity(parts, HttpStatus.OK);
        }
        catch (LockssNoSuchArtifactIdException e) {
            throw new LockssRestServiceException("Artifact not found", (Throwable)e).setUtcTimestamp(LocalDateTime.now(ZoneOffset.UTC)).setHttpStatus(HttpStatus.NOT_FOUND).setServletPath(this.request.getServletPath()).setServerErrorType(LockssRestHttpException.ServerErrorType.DATA_ERROR).setParsedRequest(parsedRequest);
        }
        catch (IOException e) {
            String errorMessage = String.format("Caught IOException while attempting to retrieve artifact from repository [artifactId: %s]", artifactid);
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    public static MultiValueMap<String, Object> generateMultipartResponseFromArtifactData(ArtifactData artifactData, LockssRepository.IncludeContent includeContent, long smallContentThreshold) throws IOException {
        NamedByteArrayResource resource;
        String artifactid = artifactData.getIdentifier().getId();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        HttpHeaders partHeaders = new HttpHeaders();
        partHeaders.setContentType(MediaType.APPLICATION_JSON);
        parts.add((Object)"artifact-repo-props", (Object)new HttpEntity((Object)CollectionsApiServiceImpl.getArtifactRepositoryProperties(artifactData), (MultiValueMap)partHeaders));
        partHeaders = new HttpHeaders();
        partHeaders.setContentType(MediaType.APPLICATION_JSON);
        parts.add((Object)"artifact-header", (Object)new HttpEntity((Object)artifactData.getMetadata(), (MultiValueMap)partHeaders));
        if (artifactData.getHttpStatus() != null) {
            partHeaders = new HttpHeaders();
            partHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            resource = new NamedByteArrayResource(artifactid, ArtifactDataUtil.getHttpStatusByteArray((StatusLine)artifactData.getHttpStatus()));
            parts.add((Object)"artifact-http-status", (Object)new HttpEntity((Object)resource, (MultiValueMap)partHeaders));
        }
        if (includeContent == LockssRepository.IncludeContent.ALWAYS || includeContent == LockssRepository.IncludeContent.IF_SMALL && artifactData.getContentLength() <= smallContentThreshold) {
            partHeaders = new HttpHeaders();
            partHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            partHeaders.setContentLength(artifactData.getContentLength());
            resource = new NamedInputStreamResource(artifactid, artifactData.getInputStream());
            parts.add((Object)"artifact-content", (Object)new HttpEntity((Object)resource, (MultiValueMap)partHeaders));
        }
        return parts;
    }

    private static HttpHeaders getArtifactRepositoryProperties(ArtifactData ad) {
        HttpHeaders headers = new HttpHeaders();
        ArtifactIdentifier id = ad.getIdentifier();
        headers.set("X-LockssRepo-Artifact-Id", id.getId());
        headers.set("X-LockssRepo-Artifact-Collection", id.getCollection());
        headers.set("X-LockssRepo-Artifact-AuId", id.getAuid());
        headers.set("X-LockssRepo-Artifact-Uri", id.getUri());
        headers.set("X-LockssRepo-Artifact-Version", String.valueOf(id.getVersion()));
        if (ad.getArtifactRepositoryState() != null) {
            headers.set("X-LockssRepo-Artifact-Committed", String.valueOf(ad.getArtifactRepositoryState().getCommitted()));
            headers.set("X-LockssRepo-Artifact-Deleted", String.valueOf(ad.getArtifactRepositoryState().getDeleted()));
        }
        headers.set("X-LockssRepo-Artifact-Length", String.valueOf(ad.getContentLength()));
        headers.set("X-LockssRepo-Artifact-Digest", ad.getContentDigest());
        return headers;
    }

    public ResponseEntity updateArtifact(String collectionid, String artifactid, Boolean committed) {
        String parsedRequest = String.format("collectionid: %s, artifactid: %s, committed: %s, requestUrl: %s", collectionid, artifactid, committed, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        try {
            if (!committed.booleanValue()) {
                throw new LockssRestServiceException("Cannot uncommit").setServerErrorType(LockssRestHttpException.ServerErrorType.NONE).setHttpStatus(HttpStatus.BAD_REQUEST).setServletPath(this.request.getServletPath()).setParsedRequest(parsedRequest);
            }
            log.debug2("Committing artifact to permanent storage [artifactId: {}]", (Object)artifactid);
            Artifact updatedArtifact = this.repo.commitArtifact(collectionid, artifactid);
            this.sendCacheInvalidate(ArtifactCache.InvalidateOp.Commit, this.artifactKey(collectionid, artifactid));
            return new ResponseEntity((Object)updatedArtifact, HttpStatus.OK);
        }
        catch (LockssNoSuchArtifactIdException e) {
            throw new LockssRestServiceException("Artifact not found", (Throwable)e).setUtcTimestamp(LocalDateTime.now(ZoneOffset.UTC)).setHttpStatus(HttpStatus.NOT_FOUND).setServletPath(this.request.getServletPath()).setServerErrorType(LockssRestHttpException.ServerErrorType.DATA_ERROR).setParsedRequest(parsedRequest);
        }
        catch (IOException e) {
            String errorMessage = String.format("IOException occurred while attempting to update artifact metadata (artifactId: %s)", artifactid);
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.APPLICATION_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    @Override
    public ResponseEntity<Artifact> createArtifact(String collectionid, String auid, String uri, MultipartFile content, Long collectionDate) {
        long start = System.currentTimeMillis();
        String parsedRequest = String.format("collectionid: %s, auid: %s, uri: %s, collectionDate: %s, requestUrl: %s", collectionid, auid, uri, collectionDate, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        log.debug(String.format("Adding artifact %s, %s, %s", collectionid, auid, uri));
        log.trace(String.format("MultipartFile: Type: ArtifactData, Content-type: %s", content.getContentType()));
        this.validateUri(uri, parsedRequest);
        MediaType contentType = MediaType.parseMediaType((String)content.getContentType());
        if (!CollectionsApiServiceImpl.isHttpResponseType(contentType).booleanValue()) {
            String errorMessage = String.format("Failed to add artifact; expected %s but got %s", APPLICATION_HTTP_RESPONSE, contentType);
            log.warn(errorMessage);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(errorMessage).setServerErrorType(LockssRestHttpException.ServerErrorType.NONE).setHttpStatus(HttpStatus.BAD_REQUEST).setParsedRequest(parsedRequest);
        }
        try {
            ArtifactData artifactData = ArtifactDataFactory.fromHttpResponseStream((InputStream)content.getInputStream());
            ArtifactIdentifier id = new ArtifactIdentifier(collectionid, auid, uri, Integer.valueOf(0));
            artifactData.setIdentifier(id);
            artifactData.setContentLength(content.getSize());
            if (collectionDate != null) {
                artifactData.setCollectionDate(collectionDate.longValue());
            }
            try {
                Artifact artifact = this.repo.addArtifact(artifactData);
                log.debug("Wrote artifact to {}", (Object)artifact.getStorageUrl());
                long end = System.currentTimeMillis();
                log.debug2("artifactId: {}, duration: {}, length: {}", (Object)artifact.getId(), (Object)TimeUtil.timeIntervalToString((long)(end - start)), (Object)StringUtil.sizeToString((long)content.getSize()));
                return new ResponseEntity((Object)artifact, HttpStatus.OK);
            }
            catch (IOException e) {
                String errorMessage = "Caught IOException while attempting to add an artifact to the repository";
                log.warn(errorMessage, (Throwable)e);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
            }
        }
        catch (IOException e) {
            throw new HttpMessageNotReadableException("Could not read artifact data from content part", (Throwable)e);
        }
    }

    @Override
    public ResponseEntity<ArtifactPageInfo> getArtifacts(String collectionid, String auid, String url, String urlPrefix, String version, Boolean includeUncommitted, Integer limit, String continuationToken) {
        String parsedRequest = String.format("collectionid: %s, auid: %s, url: %s, urlPrefix: %s, version: %s, includeUncommitted: %s, limit: %s, continuationToken: %s, requestUrl: %s", collectionid, auid, url, urlPrefix, version, includeUncommitted, limit, continuationToken, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        Integer requestLimit = limit;
        limit = CollectionsApiServiceImpl.validateLimit(requestLimit, this.defaultArtifactPageSize, this.maxArtifactPageSize, parsedRequest);
        ArtifactContinuationToken requestAct = null;
        try {
            requestAct = new ArtifactContinuationToken(continuationToken);
            log.trace("requestAct = {}", (Object)requestAct);
        }
        catch (IllegalArgumentException iae) {
            String message = "Invalid continuation token '" + continuationToken + "'";
            log.warn(message);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, message, parsedRequest);
        }
        try {
            Artifact artifact;
            boolean isLatestVersion = version == null || version.toLowerCase().equals("latest");
            log.trace("isLatestVersion = {}", (Object)isLatestVersion);
            boolean isAllVersions = version != null && version.toLowerCase().equals("all");
            log.trace("isAllVersions = {}", (Object)isAllVersions);
            if (urlPrefix != null && url != null) {
                String errorMessage = "The 'urlPrefix' and 'url' arguments are mutually exclusive";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            boolean isSpecificVersion = !isAllVersions && !isLatestVersion;
            log.trace("isSpecificVersion = {}", (Object)isSpecificVersion);
            boolean isAllUrls = url == null && urlPrefix == null;
            log.trace("isAllUrls = {}", (Object)isAllUrls);
            if (isSpecificVersion && (isAllUrls || urlPrefix != null)) {
                String errorMessage = "A specific 'version' argument requires a 'url' argument";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            boolean includeUncommittedValue = includeUncommitted != null && includeUncommitted != false;
            log.trace("includeUncommittedValue = {}", (Object)includeUncommittedValue);
            if (!isSpecificVersion && includeUncommittedValue) {
                String errorMessage = "Including an uncommitted artifact requires a specific 'version' argument";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            int numericVersion = 0;
            if (isSpecificVersion) {
                try {
                    numericVersion = Integer.parseInt(version);
                    log.trace("numericVersion = {}", (Object)numericVersion);
                    if (numericVersion <= 0) {
                        String errorMessage = "The 'version' argument is not a positive integer";
                        log.warn(errorMessage);
                        log.warn("Parsed request: {}", (Object)parsedRequest);
                        throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
                    }
                }
                catch (NumberFormatException nfe) {
                    String errorMessage = "The 'version' argument is invalid";
                    log.warn(errorMessage);
                    log.warn("Parsed request: {}", (Object)parsedRequest);
                    throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
                }
            }
            ServiceImplUtil.validateCollectionId(this.repo, collectionid, parsedRequest);
            this.validateAuId(collectionid, auid, parsedRequest);
            Iterable artifactIterable = null;
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            Iterator<Object> iterator = null;
            boolean missingIterator = false;
            Integer iteratorHashCode = requestAct.getIteratorHashCode();
            if (iteratorHashCode != null) {
                iterator = this.artifactIterators.remove(iteratorHashCode);
                boolean bl = missingIterator = iterator == null;
            }
            if (isAllUrls && isAllVersions) {
                log.trace("All versions of all URLs");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifactsAllVersions(collectionid, auid);
                }
            } else if (urlPrefix != null && isAllVersions) {
                log.trace("All versions of all URLs matching a prefix");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifactsWithPrefixAllVersions(collectionid, auid, urlPrefix);
                }
            } else if (url != null && isAllVersions) {
                log.trace("All versions of a URL");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifactsAllVersions(collectionid, auid, url);
                }
            } else if (isAllUrls && isLatestVersion) {
                log.trace("Latest versions of all URLs");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifacts(collectionid, auid);
                }
            } else if (urlPrefix != null && isLatestVersion) {
                log.trace("Latest versions of all URLs matching a prefix");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifactsWithPrefix(collectionid, auid, urlPrefix);
                }
            } else if (url != null && isLatestVersion) {
                log.trace("Latest version of a URL");
                artifact = this.repo.getArtifact(collectionid, auid, url);
                log.trace("artifact = {}", (Object)artifact);
                if (artifact != null) {
                    artifacts.add(artifact);
                }
            } else if (url != null && numericVersion > 0) {
                log.trace("Given version of a URL");
                log.trace("collectionid = {}", (Object)collectionid);
                log.trace("auid = {}", (Object)auid);
                log.trace("url = {}", (Object)url);
                log.trace("numericVersion = {}", (Object)numericVersion);
                log.trace("includeUncommittedValue = {}", (Object)includeUncommittedValue);
                artifact = this.repo.getArtifactVersion(collectionid, auid, url, Integer.valueOf(numericVersion), includeUncommittedValue);
                log.trace("artifact = {}", (Object)artifact);
                if (artifact != null) {
                    artifacts.add(artifact);
                }
            } else {
                String errorMessage = "The request could not be understood";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            ArtifactContinuationToken responseAct = null;
            if (iterator != null || artifactIterable != null) {
                Artifact lastArtifact;
                if (iterator == null) {
                    iterator = artifactIterable.iterator();
                    TimerQueue.schedule((Deadline)Deadline.in((long)172800000L), (TimerQueue.Callback)this.artifactIteratorTimeoutCallback, (Object)iterator.hashCode());
                    if (missingIterator) {
                        lastArtifact = new Artifact();
                        lastArtifact.setCollection(requestAct.getCollectionId());
                        lastArtifact.setAuid(requestAct.getAuid());
                        lastArtifact.setUri(requestAct.getUri());
                        lastArtifact.setVersion(requestAct.getVersion());
                        while (iterator.hasNext()) {
                            Artifact artifact2 = (Artifact)iterator.next();
                            if (ArtifactComparators.BY_URI_BY_DECREASING_VERSION.compare(artifact2, lastArtifact) <= 0) continue;
                            artifacts.add(artifact2);
                            break;
                        }
                    }
                }
                this.populateArtifacts(iterator, limit, artifacts);
                if (iterator.hasNext()) {
                    iteratorHashCode = iterator.hashCode();
                    this.artifactIterators.put(iteratorHashCode, iterator);
                    lastArtifact = (Artifact)artifacts.get(artifacts.size() - 1);
                    responseAct = new ArtifactContinuationToken(lastArtifact.getCollection(), lastArtifact.getAuid(), lastArtifact.getUri(), lastArtifact.getVersion(), iteratorHashCode);
                    log.trace("responseAct = {}", (Object)responseAct);
                }
            }
            log.trace("artifacts.size() = {}", (Object)artifacts.size());
            PageInfo pageInfo = new PageInfo();
            pageInfo.setResultsPerPage(Integer.valueOf(artifacts.size()));
            StringBuffer curLinkBuffer = this.request.getRequestURL();
            if (this.request.getQueryString() != null && !this.request.getQueryString().trim().isEmpty()) {
                curLinkBuffer.append("?").append(this.request.getQueryString());
            }
            String curLink = curLinkBuffer.toString();
            log.trace("curLink = {}", (Object)curLink);
            pageInfo.setCurLink(curLink);
            if (responseAct != null) {
                continuationToken = responseAct.toWebResponseContinuationToken();
                pageInfo.setContinuationToken(continuationToken);
                StringBuffer nextLinkBuffer = this.request.getRequestURL();
                boolean hasQueryParameters = false;
                if (curLink.indexOf("limit=") > 0) {
                    nextLinkBuffer.append("?limit=").append(requestLimit);
                    hasQueryParameters = true;
                }
                if (url != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("url=").append(UrlUtil.encodeUrl((String)url));
                }
                if (urlPrefix != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("urlPrefix=").append(UrlUtil.encodeUrl((String)urlPrefix));
                }
                if (version != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("version=").append(version);
                }
                if (includeUncommitted != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("includeUncommitted=").append(includeUncommitted);
                }
                if ((continuationToken = pageInfo.getContinuationToken()) != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("continuationToken=").append(UrlUtil.encodeUrl((String)continuationToken));
                }
                String nextLink = nextLinkBuffer.toString();
                log.trace("nextLink = {}", (Object)nextLink);
                pageInfo.setNextLink(nextLink);
            }
            ArtifactPageInfo artifactPageInfo = new ArtifactPageInfo();
            artifactPageInfo.setArtifacts(artifacts);
            artifactPageInfo.setPageInfo(pageInfo);
            log.trace("artifactPageInfo = {}", (Object)artifactPageInfo);
            log.debug2("Returning OK.");
            return new ResponseEntity((Object)artifactPageInfo, HttpStatus.OK);
        }
        catch (IOException e) {
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, "IOException", (Throwable)e, parsedRequest);
        }
    }

    @Override
    public ResponseEntity<ArtifactPageInfo> getArtifactsFromAllAus(String collectionid, String url, String urlPrefix, String versions, Integer limit, String continuationToken) {
        String parsedRequest = String.format("collectionid: %s, url: %s, urlPrefix: %s, requestUrl: %s", collectionid, url, urlPrefix, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        Integer requestLimit = limit;
        limit = CollectionsApiServiceImpl.validateLimit(requestLimit, this.defaultArtifactPageSize, this.maxArtifactPageSize, parsedRequest);
        ArtifactContinuationToken requestAct = null;
        try {
            requestAct = new ArtifactContinuationToken(continuationToken);
            log.trace("requestAct = {}", (Object)requestAct);
        }
        catch (IllegalArgumentException iae) {
            String message = "Invalid continuation token '" + continuationToken + "'";
            log.warn(message);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, message, parsedRequest);
        }
        try {
            if (urlPrefix != null && url != null) {
                String errorMessage = "The 'urlPrefix' and 'url' arguments are mutually exclusive";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            ServiceImplUtil.validateCollectionId(this.repo, collectionid, parsedRequest);
            Iterable artifactIterable = null;
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            Iterator<Object> iterator = null;
            boolean missingIterator = false;
            Integer iteratorHashCode = requestAct.getIteratorHashCode();
            if (iteratorHashCode != null) {
                iterator = this.artifactIterators.remove(iteratorHashCode);
                missingIterator = iterator == null;
            }
            ArtifactVersions artifactVersions = ArtifactVersions.valueOf((String)versions);
            if (url != null) {
                artifactIterable = this.repo.getArtifactsWithUrlFromAllAus(collectionid, url, artifactVersions);
            } else if (urlPrefix != null) {
                artifactIterable = this.repo.getArtifactsWithUrlPrefixFromAllAus(collectionid, urlPrefix, artifactVersions);
            }
            ArtifactContinuationToken responseAct = null;
            if (iterator != null || artifactIterable != null) {
                Artifact lastArtifact;
                if (iterator == null) {
                    iterator = artifactIterable.iterator();
                    TimerQueue.schedule((Deadline)Deadline.in((long)172800000L), (TimerQueue.Callback)this.artifactIteratorTimeoutCallback, (Object)iterator.hashCode());
                    if (missingIterator) {
                        lastArtifact = new Artifact();
                        lastArtifact.setCollection(requestAct.getCollectionId());
                        lastArtifact.setAuid(requestAct.getAuid());
                        lastArtifact.setUri(requestAct.getUri());
                        lastArtifact.setVersion(requestAct.getVersion());
                        while (iterator.hasNext()) {
                            Artifact artifact = (Artifact)iterator.next();
                            if (ArtifactComparators.BY_URI_BY_DECREASING_VERSION.compare(artifact, lastArtifact) <= 0) continue;
                            artifacts.add(artifact);
                            break;
                        }
                    }
                }
                this.populateArtifacts(iterator, limit, artifacts);
                if (iterator.hasNext()) {
                    iteratorHashCode = iterator.hashCode();
                    this.artifactIterators.put(iteratorHashCode, iterator);
                    lastArtifact = (Artifact)artifacts.get(artifacts.size() - 1);
                    responseAct = new ArtifactContinuationToken(lastArtifact.getCollection(), lastArtifact.getAuid(), lastArtifact.getUri(), lastArtifact.getVersion(), iteratorHashCode);
                    log.trace("responseAct = {}", (Object)responseAct);
                }
            }
            log.trace("artifacts.size() = {}", (Object)artifacts.size());
            PageInfo pageInfo = new PageInfo();
            pageInfo.setResultsPerPage(Integer.valueOf(artifacts.size()));
            StringBuffer curLinkBuffer = this.request.getRequestURL();
            if (this.request.getQueryString() != null && !this.request.getQueryString().trim().isEmpty()) {
                curLinkBuffer.append("?").append(this.request.getQueryString());
            }
            String curLink = curLinkBuffer.toString();
            log.trace("curLink = {}", (Object)curLink);
            pageInfo.setCurLink(curLink);
            if (responseAct != null) {
                continuationToken = responseAct.toWebResponseContinuationToken();
                pageInfo.setContinuationToken(continuationToken);
                StringBuffer nextLinkBuffer = this.request.getRequestURL();
                boolean hasQueryParameters = false;
                if (curLink.indexOf("limit=") > 0) {
                    nextLinkBuffer.append("?limit=").append(requestLimit);
                    hasQueryParameters = true;
                }
                if (url != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("url=").append(UrlUtil.encodeUrl((String)url));
                }
                if (urlPrefix != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("urlPrefix=").append(UrlUtil.encodeUrl((String)urlPrefix));
                }
                if ((continuationToken = pageInfo.getContinuationToken()) != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("continuationToken=").append(UrlUtil.encodeUrl((String)continuationToken));
                }
                String nextLink = nextLinkBuffer.toString();
                log.trace("nextLink = {}", (Object)nextLink);
                pageInfo.setNextLink(nextLink);
            }
            ArtifactPageInfo artifactPageInfo = new ArtifactPageInfo();
            artifactPageInfo.setArtifacts(artifacts);
            artifactPageInfo.setPageInfo(pageInfo);
            log.trace("artifactPageInfo = {}", (Object)artifactPageInfo);
            log.debug2("Returning OK.");
            return new ResponseEntity((Object)artifactPageInfo, HttpStatus.OK);
        }
        catch (IOException e) {
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, "IOException", (Throwable)e, parsedRequest);
        }
    }

    @Override
    public ResponseEntity<Long> getArtifactsSize(String collectionid, String auid, String url, String urlPrefix, String version) {
        boolean isAllUrls;
        boolean isAllVersions;
        String parsedRequest = String.format("collectionid: %s, auid: %s, url: %s, urlPrefix: %s, version: %s, requestUrl: %s", collectionid, auid, url, urlPrefix, version, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        boolean isLatestVersion = version == null || version.toLowerCase().equals("latest");
        boolean bl = isAllVersions = version != null && version.toLowerCase().equals("all");
        if (urlPrefix != null && url != null) {
            String errorMessage = "The 'urlPrefix' and 'url' arguments are mutually exclusive";
            log.warn(errorMessage);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
        }
        boolean isSpecificVersion = !isAllVersions && !isLatestVersion;
        boolean bl2 = isAllUrls = url == null && urlPrefix == null;
        if (isSpecificVersion && (isAllUrls || urlPrefix != null)) {
            String errorMessage = "A specific 'version' argument requires a 'url' argument";
            log.warn(errorMessage);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
        }
        int numericVersion = 0;
        if (isSpecificVersion) {
            try {
                numericVersion = Integer.parseInt(version);
                if (numericVersion <= 0) {
                    String errorMessage = "The 'version' argument is not a positive integer";
                    log.warn(errorMessage);
                    log.warn("Parsed request: {}", (Object)parsedRequest);
                    throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
                }
            }
            catch (NumberFormatException nfe) {
                String errorMessage = "The 'version' argument is invalid";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
        }
        try {
            ServiceImplUtil.validateCollectionId(this.repo, collectionid, parsedRequest);
            this.validateAuId(collectionid, auid, parsedRequest);
            Long result = this.repo.auSize(collectionid, auid);
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IOException e) {
            String errorMessage = "Unexpected exception caught while attempting to get artifacts size";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.APPLICATION_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    @Override
    public ResponseEntity<AuidPageInfo> getAus(String collectionid, Integer limit, String continuationToken) {
        String parsedRequest = String.format("collectionid: %s, requestUrl: %s", collectionid, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        Integer requestLimit = limit;
        limit = CollectionsApiServiceImpl.validateLimit(requestLimit, this.defaultAuidPageSize, this.maxAuidPageSize, parsedRequest);
        AuidContinuationToken requestAct = null;
        try {
            requestAct = new AuidContinuationToken(continuationToken);
            log.trace("requestAct = {}", (Object)requestAct);
        }
        catch (IllegalArgumentException iae) {
            String message = "Invalid continuation token '" + continuationToken + "'";
            log.warn(message);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, message, parsedRequest);
        }
        try {
            ServiceImplUtil.validateCollectionId(this.repo, collectionid, parsedRequest);
            ArrayList<String> auids = new ArrayList<String>();
            AuidContinuationToken responseAct = null;
            Iterator<Object> iterator = null;
            Integer iteratorHashCode = requestAct.getIteratorHashCode();
            if (iteratorHashCode == null) {
                iterator = this.repo.getAuIds(collectionid).iterator();
                TimerQueue.schedule((Deadline)Deadline.in((long)172800000L), (TimerQueue.Callback)this.auidIteratorTimeoutCallback, (Object)iterator.hashCode());
            } else {
                iterator = this.auidIterators.remove(iteratorHashCode);
                if (iterator == null) {
                    String lastAuid = requestAct.getAuid();
                    iterator = this.repo.getAuIds(collectionid).iterator();
                    TimerQueue.schedule((Deadline)Deadline.in((long)172800000L), (TimerQueue.Callback)this.auidIteratorTimeoutCallback, (Object)iterator.hashCode());
                    while (iterator.hasNext()) {
                        String auid = (String)iterator.next();
                        if (auid.compareTo(lastAuid) <= 0) continue;
                        auids.add(auid);
                        break;
                    }
                }
            }
            this.populateAus(iterator, limit, auids);
            if (iterator.hasNext()) {
                iteratorHashCode = iterator.hashCode();
                this.auidIterators.put(iteratorHashCode, iterator);
                responseAct = new AuidContinuationToken((String)auids.get(auids.size() - 1), iteratorHashCode);
                log.trace("responseAct = {}", (Object)responseAct);
            }
            log.trace("auids.size() = {}", (Object)auids.size());
            PageInfo pageInfo = new PageInfo();
            pageInfo.setResultsPerPage(Integer.valueOf(auids.size()));
            StringBuffer curLinkBuffer = this.request.getRequestURL();
            if (this.request.getQueryString() != null && !this.request.getQueryString().trim().isEmpty()) {
                curLinkBuffer.append("?").append(this.request.getQueryString());
            }
            String curLink = curLinkBuffer.toString();
            log.trace("curLink = {}", (Object)curLink);
            pageInfo.setCurLink(curLink);
            if (responseAct != null) {
                continuationToken = responseAct.toWebResponseContinuationToken();
                pageInfo.setContinuationToken(continuationToken);
                StringBuffer nextLinkBuffer = this.request.getRequestURL();
                boolean hasQueryParameters = false;
                if (curLink.indexOf("limit=") > 0) {
                    nextLinkBuffer.append("?limit=").append(requestLimit);
                    hasQueryParameters = true;
                }
                if (continuationToken != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("continuationToken=").append(UrlUtil.encodeUrl((String)continuationToken));
                }
                String nextLink = nextLinkBuffer.toString();
                log.trace("nextLink = {}", (Object)nextLink);
                pageInfo.setNextLink(nextLink);
            }
            AuidPageInfo auidPageInfo = new AuidPageInfo();
            auidPageInfo.setAuids(auids);
            auidPageInfo.setPageInfo(pageInfo);
            log.trace("auidPageInfo = {}", (Object)auidPageInfo);
            log.debug2("Returning OK.");
            return new ResponseEntity((Object)auidPageInfo, HttpStatus.OK);
        }
        catch (IOException e) {
            String errorMessage = "Unexpected exception caught while attempting to get AU ids";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    private static Boolean isHttpResponseType(MediaType type) {
        return APPLICATION_HTTP_RESPONSE.isCompatibleWith(type) && type.getParameters().equals(APPLICATION_HTTP_RESPONSE.getParameters());
    }

    private void validateAuId(String collectionid, String auid, String parsedRequest) throws IOException {
    }

    private void validateUri(String uri, String parsedRequest) {
        log.debug2("uri = '{}'", (Object)uri);
        log.debug2("parsedRequest = '{}'", (Object)parsedRequest);
        if (uri.isEmpty()) {
            String errorMessage = "The URI has not been provided";
            log.warn(errorMessage);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
        }
        log.debug2("uri '{}' is valid.", (Object)uri);
    }

    @Override
    public Optional<ObjectMapper> getObjectMapper() {
        return Optional.ofNullable(this.objectMapper);
    }

    @Override
    public Optional<HttpServletRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    String artifactKey(String collectionid, String artifactid) throws IOException {
        Artifact art = this.repo.getArtifactFromId(artifactid);
        if (art != null) {
            return art.makeKey();
        }
        log.error("Expected artifact not found, can't send invalidate: {}", (Object)artifactid);
        return null;
    }

    protected void sendCacheInvalidate(ArtifactCache.InvalidateOp op, String key) {
        if (this.jmsProducer != null && key != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("CacheAction", "Invalidate");
            map.put("InvalidateOp", op.toString());
            map.put("ArtifactKey", key);
            try {
                this.jmsProducer.sendMap(map);
            }
            catch (JMSException e) {
                log.error("Couldn't send cache invalidate notification", (Throwable)e);
            }
        }
    }

    protected void sendCacheFlush() {
        if (this.jmsProducer != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("CacheAction", "Flush");
            try {
                this.jmsProducer.sendMap(map);
            }
            catch (JMSException e) {
                log.error("Couldn't send cache flush notification", (Throwable)e);
            }
        }
    }

    private void populateArtifacts(Iterator<Artifact> iterator, Integer limit, List<Artifact> artifacts) {
        log.debug2("limit = {}, artifacts = {}", (Object)limit, artifacts);
        for (int artifactCount = artifacts.size(); artifactCount < limit && iterator.hasNext(); ++artifactCount) {
            artifacts.add(iterator.next());
        }
    }

    private void populateAus(Iterator<String> iterator, Integer limit, List<String> auids) {
        log.debug2("limit = {}, auids = {}", (Object)limit, auids);
        for (int auidCount = auids.size(); auidCount < limit && iterator.hasNext(); ++auidCount) {
            auids.add(iterator.next());
        }
    }

    static int validateLimit(Integer requestLimit, int defaultValue, int maxValue, String parsedRequest) {
        log.debug2("requestLimit = {}, defaultValue = {}, maxValue = {}", (Object)requestLimit, (Object)defaultValue, (Object)maxValue);
        if (requestLimit != null && requestLimit <= 0) {
            String message = "Limit of requested items must be a positive integer; it was '" + requestLimit + "'";
            log.warn(message);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, message, parsedRequest);
        }
        int result = requestLimit == null ? Math.min(defaultValue, maxValue) : Math.min(requestLimit, maxValue);
        log.debug2("result = {}", (Object)result);
        return result;
    }

    protected void sendPingResponse(String key) {
        if (this.jmsProducer != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("CacheAction", "EchoResp");
            map.put("ArtifactKey", key);
            try {
                this.jmsProducer.sendMap(map);
            }
            catch (JMSException e) {
                log.error("Couldn't send cache invalidate notification", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ boolean lambda$validateAuId$0(String auid, String name) {
        return auid.equals(name);
    }

    private class CacheInvalidateListener
    implements MessageListener {
        private CacheInvalidateListener() {
        }

        public void onMessage(Message message) {
            try {
                Map msgMap = (Map)JmsUtil.convertMessage((Message)message);
                String action = (String)msgMap.get("CacheAction");
                String key = (String)msgMap.get("ArtifactKey");
                log.debug2("Received Artifact cache message: {}: {}", (Object)action, (Object)key);
                if (action != null) {
                    switch (action) {
                        case "Echo": {
                            CollectionsApiServiceImpl.this.sendPingResponse(key);
                            break;
                        }
                        case "Invalidate": 
                        case "EchoResp": 
                        case "Flush": {
                            break;
                        }
                        default: {
                            log.warn("Unknown message action: " + action);
                        }
                    }
                }
            }
            catch (RuntimeException | JMSException e) {
                log.error("Malformed Artifact cache message: " + message, e);
            }
        }
    }
}

