/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.archive.wayback.surt.SURTTokenizer;
import org.lockss.laaws.rs.api.CdxApiDelegate;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.laaws.rs.impl.ServiceImplUtil;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactData;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.model.ArtifactVersions;
import org.lockss.laaws.rs.model.CdxRecord;
import org.lockss.laaws.rs.model.CdxRecords;
import org.lockss.log.L4JLogger;
import org.lockss.spring.error.LockssRestServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CdxApiServiceImpl
implements CdxApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    private static String charsetName = StandardCharsets.UTF_8.name();
    @Autowired
    LockssRepository repo;
    private final HttpServletRequest request;

    @Autowired
    public CdxApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public ResponseEntity<String> getCdxOwb(String collectionid, String q, Integer count, Integer startPage, String accept, String acceptEncoding) {
        log.debug2("collectionid = {}", (Object)collectionid);
        log.debug2("q = {}", (Object)q);
        log.debug2("count = {}", (Object)count);
        log.debug2("startPage = {}", (Object)startPage);
        log.debug2("accept = {}", (Object)accept);
        log.debug2("acceptEncoding = {}", (Object)acceptEncoding);
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            log.trace("header name = {}, value = {}", (Object)name, (Object)this.request.getHeader(name));
        }
        log.trace("parameterMap = {}", (Object)this.request.getParameterMap());
        String parsedRequest = this.getParsedRequest(this.request, collectionid);
        log.trace("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        try {
            ServiceImplUtil.validateCollectionId(this.repo, collectionid, parsedRequest);
        }
        catch (IOException e) {
            String message = "Cannot validate the collectionid = '" + collectionid + "'";
            log.error(message, (Throwable)e);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
        ServiceImplUtil.validatePagination(count, startPage, parsedRequest);
        try {
            Map<String, String> openWayBackQuery = CdxApiServiceImpl.parseOpenWayBackQueryString(q);
            log.trace("openWayBackQuery = {}", openWayBackQuery);
            String url = openWayBackQuery.get("url");
            log.trace("url = {}", (Object)url);
            openWayBackQuery.put("canonicalUrl", url);
            CdxRecords records = new CdxRecords(openWayBackQuery, charsetName);
            boolean isPrefix = openWayBackQuery.containsKey("type") && openWayBackQuery.get("type").toLowerCase().equals("prefixquery");
            log.trace("isPrefix = {}", (Object)isPrefix);
            String date = null;
            if (openWayBackQuery.containsKey("date") && !openWayBackQuery.get("date").trim().isEmpty()) {
                date = openWayBackQuery.get("date").trim();
                log.trace("date = {}", (Object)date);
            }
            this.getCdxRecords(collectionid, url, this.repo, isPrefix, count, startPage, date, records);
            String result = records.toXmlText();
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException bre) {
            String message = "Cannot get the CDX records for collectionid = '" + collectionid + "', q = '" + q + "'";
            log.error(message, (Throwable)bre);
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, message, bre);
        }
        catch (Exception e) {
            String message = "Cannot get the CDX records for collectionid = '" + collectionid + "', q = '" + q + "'";
            log.error(message, (Throwable)e);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
    }

    @Override
    public ResponseEntity<String> getCdxPywb(String collectionid, String url, Integer limit, String matchType, String sort, String closest, String output, String fl, String accept, String acceptEncoding) {
        log.debug2("collectionid = {}", (Object)collectionid);
        log.debug2("url = {}", (Object)url);
        log.debug2("limit = {}", (Object)limit);
        log.debug2("matchType = {}", (Object)matchType);
        log.debug2("sort = {}", (Object)sort);
        log.debug2("closest = {}", (Object)closest);
        log.debug2("output = {}", (Object)output);
        log.debug2("fl = {}", (Object)fl);
        log.debug2("accept = {}", (Object)accept);
        log.debug2("acceptEncoding = {}", (Object)acceptEncoding);
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            log.trace("header name = {}, value = {}", (Object)name, (Object)this.request.getHeader(name));
        }
        log.trace("parameterMap = {}", (Object)this.request.getParameterMap());
        String parsedRequest = this.getParsedRequest(this.request, collectionid);
        log.trace("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        try {
            ServiceImplUtil.validateCollectionId(this.repo, collectionid, parsedRequest);
        }
        catch (Exception e) {
            String message = "Cannot validate the collectionid = '" + collectionid + "'";
            log.error(message, (Throwable)e);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
        try {
            CdxRecords records = new CdxRecords();
            boolean isExact = matchType == null || matchType.toLowerCase().equals("exact");
            log.trace("isExact = {}", (Object)isExact);
            if (!isExact) {
                closest = null;
            }
            boolean isPrefix = matchType != null && matchType.toLowerCase().equals("prefix");
            log.trace("isPrefix = {}", (Object)isPrefix);
            Integer startPage = null;
            if (limit != null) {
                startPage = 1;
                ServiceImplUtil.validatePagination(limit, startPage, parsedRequest);
            }
            this.getCdxRecords(collectionid, url, this.repo, isPrefix, limit, startPage, closest, records);
            String result = null;
            if (output == null || output.trim().isEmpty() || output.trim().toLowerCase().equals("cdx")) {
                result = records.toIaText();
            } else if (output.trim().toLowerCase().equals("json")) {
                result = records.toJson();
            } else {
                String errorMessage = "Invalid output request parameter: " + output;
                log.error(errorMessage);
                throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            log.trace("records.toJson() = {}", (Object)records.toJson());
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "Cannot get the CDX records for collectionid = '" + collectionid + "', url = '" + url + "'";
            log.error(message, (Throwable)iae);
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, message, iae);
        }
        catch (Exception e) {
            String message = "Cannot get the CDX records for collectionid = '" + collectionid + "', url = '" + url + "'";
            log.error(message, (Throwable)e);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
    }

    private String getParsedRequest(HttpServletRequest request, String collectionid) {
        return String.format("collectionid: %s, requestUrl: %s", collectionid, ServiceImplUtil.getFullRequestUrl(request));
    }

    private static Map<String, String> parseOpenWayBackQueryString(String q) throws UnsupportedEncodingException {
        log.debug2("q = {}", (Object)q);
        try {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            for (String queryElement : q.split(" ")) {
                log.trace("queryElement = {}", (Object)queryElement);
                String[] elementFields = queryElement.split(":", 2);
                log.trace("elementFields[0] = {}", (Object)elementFields[0]);
                String value = URLDecoder.decode(elementFields[1], charsetName);
                log.trace("value = {}", (Object)value);
                queryMap.put(elementFields[0], value);
            }
            log.debug2("queryMap = {}", queryMap);
            return queryMap;
        }
        catch (UnsupportedEncodingException uee) {
            log.error("Exception caught parsing query", (Throwable)uee);
            throw uee;
        }
    }

    void getCdxRecords(String collectionid, String url, LockssRepository repo, boolean isPrefix, Integer count, Integer startPage, String closest, CdxRecords records) throws IOException {
        log.debug2("collectionid = {}", (Object)collectionid);
        log.debug2("url = {}", (Object)url);
        log.debug2("isPrefix = {}", (Object)isPrefix);
        log.debug2("count = {}", (Object)count);
        log.debug2("startPage = {}", (Object)startPage);
        log.debug2("closest = {}", (Object)closest);
        Iterable iterable = null;
        iterable = isPrefix ? repo.getArtifactsWithUrlPrefixFromAllAus(collectionid, url, ArtifactVersions.ALL) : repo.getArtifactsWithUrlFromAllAus(collectionid, url, ArtifactVersions.ALL);
        Iterator<Artifact> artIterator = iterable.iterator();
        if (closest != null && !closest.trim().isEmpty()) {
            artIterator = this.getArtifactsSortedByTemporalGap(artIterator, closest).iterator();
        }
        this.getArtifactsCdxRecords(artIterator, repo, count, startPage, records);
    }

    void getArtifactsCdxRecords(Iterator<Artifact> artIterator, LockssRepository repo, Integer count, Integer startPage, CdxRecords records) throws IOException {
        log.debug2("count = {}", (Object)count);
        log.debug2("startPage = {}", (Object)startPage);
        int lastArticleSkipped = -1;
        int lastArticleIncluded = Integer.MAX_VALUE;
        if (count != null) {
            lastArticleSkipped = count * (startPage - 1) - 1;
            log.trace("lastArticleSkipped = {}", (Object)lastArticleSkipped);
            lastArticleIncluded = lastArticleSkipped + count;
            log.trace("lastArticleIncluded = {}", (Object)lastArticleIncluded);
        }
        int iteratorCounter = 0;
        while (artIterator.hasNext()) {
            Artifact artifact = artIterator.next();
            log.trace("artifact = {}", (Object)artifact);
            if (iteratorCounter > lastArticleSkipped) {
                String artifactId = artifact.getId();
                log.trace("artifactId = {}", (Object)artifactId);
                CdxRecord record = this.getCdxRecord(repo.getArtifactData(artifact.getCollection(), artifactId));
                log.trace("record = {}", (Object)record);
                records.addCdxRecord(record);
                log.trace("recordsCount = {}", (Object)records.getCdxRecordCount());
            }
            if (++iteratorCounter <= lastArticleIncluded) continue;
            break;
        }
    }

    List<Artifact> getArtifactsSortedByTemporalGap(Iterator<Artifact> artIterator, String closest) throws IOException {
        log.debug2("closest = {}", (Object)closest);
        long targetTimestamp = CdxRecord.computeCollectiondate(closest);
        log.trace("targetTimestamp = {}", (Object)targetTimestamp);
        ArrayList<ClosestArtifact> cas = new ArrayList<ClosestArtifact>();
        while (artIterator.hasNext()) {
            cas.add(new ClosestArtifact(artIterator.next(), targetTimestamp));
        }
        log.trace("cas.size() = {}", (Object)cas.size());
        cas.sort(Comparator.comparing(ClosestArtifact::getGap));
        ArrayList<Artifact> sortedArtifacts = new ArrayList<Artifact>();
        Iterator caIterator = cas.iterator();
        while (caIterator.hasNext()) {
            sortedArtifacts.add(((ClosestArtifact)caIterator.next()).getArtifact());
        }
        return sortedArtifacts;
    }

    CdxRecord getCdxRecord(ArtifactData artifactData) throws IOException {
        log.debug2("artifactData = {}", (Object)artifactData);
        CdxRecord record = new CdxRecord();
        String artifactUrl = artifactData.getIdentifier().getUri();
        log.trace("artifactUrl = {}", (Object)artifactUrl);
        String urlSortKey = SURTTokenizer.exactKey(artifactUrl);
        log.trace("urlSortKey = {}", (Object)urlSortKey);
        record.setUrlSortKey(urlSortKey);
        long timestamp = CdxRecord.computeNumericTimestamp(artifactData.getCollectionDate());
        log.trace("timestamp = {}", (Object)timestamp);
        record.setTimestamp(timestamp);
        record.setUrl(artifactUrl);
        MediaType ctype = artifactData.getMetadata().getContentType();
        if (ctype != null) {
            record.setMimeType(ctype.toString());
        }
        record.setHttpStatus(artifactData.getHttpStatus().getStatusCode());
        record.setDigest(artifactData.getContentDigest());
        record.setLength(artifactData.getContentLength());
        record.setOffset(0L);
        ArtifactIdentifier artifactIdentifier = artifactData.getIdentifier();
        record.setArchiveName(ServiceImplUtil.getArtifactArchiveName(artifactIdentifier.getCollection(), artifactIdentifier.getId()));
        log.debug2("record = {}", (Object)record);
        return record;
    }

    private ResponseEntity<String> getErrorResponseEntity(HttpStatus status, String message, Exception e) {
        String errorMessage = message;
        if (e != null) {
            errorMessage = errorMessage == null ? e.getMessage() : errorMessage + " - " + e.getMessage();
        }
        return new ResponseEntity((Object)ServiceImplUtil.toJsonError(status.value(), errorMessage), status);
    }

    static class ClosestArtifact {
        private final Artifact artifact;
        private final long gap;

        ClosestArtifact(Artifact artifact, long targetTimestamp) {
            this.artifact = artifact;
            this.gap = Math.abs(artifact.getCollectionDate() - targetTimestamp);
        }

        Artifact getArtifact() {
            return this.artifact;
        }

        long getGap() {
            return this.gap;
        }
    }
}

