/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.21).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.rs.api;

import org.lockss.laaws.rs.model.ArtifactPageInfo;
import org.lockss.laaws.rs.model.AuSize;
import org.lockss.laaws.rs.model.AuidPageInfo;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

@Validated
@Api(value = "aus", description = "the aus API")
@RequestMapping(value = "")
public interface AusApi {

    AusApiDelegate getDelegate();

    @ApiOperation(value = "Get artifacts in an Archival Unit", nickname = "getArtifacts", notes = "Get a list of all artifacts in a namespace and Archival Unit or a pageful of the list defined by the continuation token and size", response = ArtifactPageInfo.class, tags={ "artifacts", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The requested artifacts", response = ArtifactPageInfo.class),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to retrieve data"),
        @ApiResponse(code = 404, message = "AUID not found in namespace"),
        @ApiResponse(code = 502, message = "Could not read from external resource") })
    @RequestMapping(value = "/aus/{auid}/artifacts",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<ArtifactPageInfo> getArtifacts(@ApiParam(value = "Identifier of the Archival Unit containing the artifacts",required=true) @PathVariable("auid") String auid,@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace,@ApiParam(value = "The URL contained by the artifacts") @Valid @RequestParam(value = "url", required = false) String url,@ApiParam(value = "The prefix to be matched by the artifact URLs") @Valid @RequestParam(value = "urlPrefix", required = false) String urlPrefix,@ApiParam(value = "The version of the artifact") @Valid @RequestParam(value = "version", required = false) String version,@ApiParam(value = "Indication of whether uncommitted artifacts should be returned") @Valid @RequestParam(value = "includeUncommitted", required = false) Boolean includeUncommitted,@ApiParam(value = "The requested maximum number of artifacts per response") @Valid @RequestParam(value = "limit", required = false) Integer limit,@ApiParam(value = "The continuation token of the next page of artifacts to be returned") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken) {
        return getDelegate().getArtifacts(auid, namespace, url, urlPrefix, version, includeUncommitted, limit, continuationToken);
    }


    @ApiOperation(value = "Get the size of Archival Unit artifacts in a namespace", nickname = "getArtifactsSize", notes = "", response = AuSize.class, tags={ "aus", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Returns an AuSize containing the sizes of all the artifacts, only the latest artifact version of all URLs, and the sum of the size of all the underlying WARC files, of an AU.", response = AuSize.class),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to retrieve data"),
        @ApiResponse(code = 404, message = "AUID not found in namespace"),
        @ApiResponse(code = 502, message = "Could not read from external resource") })
    @RequestMapping(value = "/aus/{auid}/size",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<AuSize> getArtifactsSize(@ApiParam(value = "Identifier of the Archival Unit containing the artifacts",required=true) @PathVariable("auid") String auid,@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace) {
        return getDelegate().getArtifactsSize(auid, namespace);
    }


    @ApiOperation(value = "Get Archival Unit IDs (AUIDs) in a namespace", nickname = "getAus", notes = "Get a list of all Archival Unit identifiers in a namespace or a pageful of the list defined by the continuation token and size", response = AuidPageInfo.class, tags={ "aus", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The requested Archival Unit identifiers", response = AuidPageInfo.class),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to retrieve data"),
        @ApiResponse(code = 404, message = "No AUIDs in namespace"),
        @ApiResponse(code = 502, message = "Could not read from external resource") })
    @RequestMapping(value = "/aus",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<AuidPageInfo> getAus(@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace,@ApiParam(value = "The requested maximum number of Archival Unit identifiers per response") @Valid @RequestParam(value = "limit", required = false) Integer limit,@ApiParam(value = "The continuation token of the next page of Archival Unit identifiers to be returned") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken) {
        return getDelegate().getAus(namespace, limit, continuationToken);
    }


    @ApiOperation(value = "Marks the AUID for bulk artifact transfer", nickname = "handleBulkAuOp", notes = "", tags={ "aus", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Bulk operation succeeded"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 403, message = "Client is forbidden from performing bulk operation"),
        @ApiResponse(code = 404, message = "AUID not in bulk mode") })
    @RequestMapping(value = "/aus/{auid}/bulk",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    default ResponseEntity<Void> handleBulkAuOp(@ApiParam(value = "Archival Unit ID",required=true) @PathVariable("auid") String auid,@ApiParam(value = "Bulk AU transfer operation", required=true, allowableValues="start, finish") @RequestParam(value="op", required=true)  String op,@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace) {
        return getDelegate().handleBulkAuOp(auid, op, namespace);
    }

}
