/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.21).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.rs.api;

import org.springframework.core.io.Resource;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

@Validated
@Api(value = "wayback", description = "the wayback API")
@RequestMapping(value = "")
public interface WaybackApi {

    WaybackApiDelegate getDelegate();

    @ApiOperation(value = "Get OpenWayback CDX records", nickname = "getCdxOwb", notes = "Get the OpenWayback CDX records of a URL in a namespace", response = String.class, tags={ "wayback", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The OpenWayback CDX records of the URL in the namespace", response = String.class),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Namespace/URL not found"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/wayback/cdx/owb/{namespace}",
        produces = { "application/xml" }, 
        method = RequestMethod.GET)
    default ResponseEntity<String> getCdxOwb(@ApiParam(value = "Namespace of the artifacts",required=true) @PathVariable("namespace") String namespace,@ApiParam(value = "Query string. Supported fields are url, type\\ \\ (urlquery/prefixquery), offset and limit.") @Valid @RequestParam(value = "q", required = false) String q,@ApiParam(value = ".") @Valid @RequestParam(value = "count", required = false) Integer count,@ApiParam(value = ".") @Valid @RequestParam(value = "start_page", required = false) Integer startPage,@ApiParam(value = "The Accept header" ) @RequestHeader(value="Accept", required=false) String accept,@ApiParam(value = "The Accept-Encoding header" ) @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding) {
        return getDelegate().getCdxOwb(namespace, q, count, startPage, accept, acceptEncoding);
    }


    @ApiOperation(value = "Get PyWayback CDX records", nickname = "getCdxPywb", notes = "Get the PyWayback CDX records of a URL in a namespace", response = String.class, tags={ "wayback", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The PyWayback CDX records of the URL in the namespace", response = String.class),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Namespace/URL not found"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/wayback/cdx/pywb/{namespace}",
        produces = { "text/plain" }, 
        method = RequestMethod.GET)
    default ResponseEntity<String> getCdxPywb(@ApiParam(value = "Namespace of the artifacts",required=true) @PathVariable("namespace") String namespace,@ApiParam(value = "The URL for which the CDX records are requested") @Valid @RequestParam(value = "url", required = false) String url,@ApiParam(value = ".") @Valid @RequestParam(value = "limit", required = false) Integer limit,@ApiParam(value = "", allowableValues = "exact, prefix, host, domain, range") @Valid @RequestParam(value = "matchType", required = false) String matchType,@ApiParam(value = "", allowableValues = "default, closest, reverse") @Valid @RequestParam(value = "sort", required = false) String sort,@ApiParam(value = "Timestamp for sort=closest mode") @Valid @RequestParam(value = "closest", required = false) String closest,@ApiParam(value = "Output format", allowableValues = "cdx, json") @Valid @RequestParam(value = "output", required = false) String output,@ApiParam(value = "Comma-separated list of fields to include in output") @Valid @RequestParam(value = "fl", required = false) String fl,@ApiParam(value = "The Accept header" ) @RequestHeader(value="Accept", required=false) String accept,@ApiParam(value = "The Accept-Encoding header" ) @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding) {
        return getDelegate().getCdxPywb(namespace, url, limit, matchType, sort, closest, output, fl, accept, acceptEncoding);
    }


    @ApiOperation(value = "Get a WARC archive", nickname = "getWarcArchive", notes = "Get the contents of a single WARC record as a WARC archive", response = Resource.class, tags={ "wayback", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The contents of the requested WARC archive", response = Resource.class),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 404, message = "WARC archive not found"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/wayback/warcs/{fileName}",
        produces = { "application/warc" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getWarcArchive(@ApiParam(value = "Name of the WARC archive",required=true) @PathVariable("fileName") String fileName,@ApiParam(value = "The Accept header" ) @RequestHeader(value="Accept", required=false) String accept,@ApiParam(value = "The Accept-Encoding header" ) @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding,@ApiParam(value = "The Range header" ) @RequestHeader(value="Range", required=false) String range) {
        return getDelegate().getWarcArchive(fileName, accept, acceptEncoding, range);
    }

}
