/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.lockss.laaws.rs.api.AusApi;
import org.lockss.util.rest.repo.model.ArtifactPageInfo;
import org.lockss.util.rest.repo.model.AuSize;
import org.lockss.util.rest.repo.model.AuidPageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public interface AusApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(AusApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<ArtifactPageInfo> getArtifacts(String auid, String namespace, String url, String urlPrefix, String version, Boolean includeUncommitted, Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", ArtifactPageInfo.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<AuSize> getArtifactsSize(String auid, String namespace) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", AuSize.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<AuidPageInfo> getAus(String namespace, Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", AuidPageInfo.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Void> handleBulkAuOp(String auid, String op, String namespace) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

