/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import java.util.Vector;
import org.lockss.log.L4JLogger;
import org.lockss.util.StringUtil;
import org.lockss.util.UrlUtil;

public class AuidContinuationToken {
    private static final L4JLogger log = L4JLogger.getLogger();
    private static final String separator = ":";
    private String auid = null;
    private Integer iteratorHashCode = null;

    public AuidContinuationToken(String webRequestContinuationToken) throws IllegalArgumentException {
        log.debug2("webRequestContinuationToken = {}", (Object)webRequestContinuationToken);
        String message = "Invalid web request continuation token '" + webRequestContinuationToken + "'";
        if (webRequestContinuationToken != null && !webRequestContinuationToken.trim().isEmpty()) {
            Vector tokenItems = null;
            try {
                tokenItems = StringUtil.breakAt((String)webRequestContinuationToken.trim(), (String)separator);
                log.trace("tokenItems = {}", (Object)tokenItems);
                this.auid = UrlUtil.decodeUrl((String)((String)tokenItems.get(0)).trim());
                log.trace("auid = {}", (Object)this.auid);
                this.iteratorHashCode = Integer.valueOf(((String)tokenItems.get(1)).trim());
                log.trace("iteratorHashCode = {}", (Object)this.iteratorHashCode);
            }
            catch (Exception e) {
                log.warn(message, (Throwable)e);
                throw new IllegalArgumentException(message, e);
            }
            if (tokenItems.size() != 2) {
                log.warn(message);
                throw new IllegalArgumentException(message);
            }
            this.validateMembers();
        }
    }

    public AuidContinuationToken(String auid, Integer iteratorHashCode) {
        this.auid = auid;
        this.iteratorHashCode = iteratorHashCode;
        this.validateMembers();
    }

    public String getAuid() {
        return this.auid;
    }

    public Integer getIteratorHashCode() {
        return this.iteratorHashCode;
    }

    public String toWebResponseContinuationToken() {
        if (this.auid != null && this.iteratorHashCode != null) {
            String encodedToken = UrlUtil.encodeUrl((String)this.auid) + separator + this.iteratorHashCode;
            log.trace("encodedToken = {}", (Object)encodedToken);
            return encodedToken;
        }
        String message = "Cannot get web request continuation token from " + this;
        log.warn(message);
        throw new IllegalArgumentException(message);
    }

    public String toString() {
        return "[AuidContinuationToken auid=" + this.auid + ", iteratorHashCode=" + this.iteratorHashCode + "]";
    }

    private void validateMembers() {
        if (this.auid == null && this.iteratorHashCode != null || this.auid != null && this.iteratorHashCode == null) {
            String message = "Invalid member combination: auid = '" + this.auid + "', iteratorHashCode = '" + this.iteratorHashCode + "'";
            log.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this.auid != null && this.auid.isEmpty()) {
            String message = "Invalid member: auid = '" + this.auid + "'";
            log.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this.iteratorHashCode != null && this.iteratorHashCode < 0) {
            String message = "Invalid member: iteratorHashCode = '" + this.iteratorHashCode + "'";
            log.warn(message);
            throw new IllegalArgumentException(message);
        }
    }
}

