/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.lockss.config.Configuration;
import org.lockss.laaws.rs.api.AusApiDelegate;
import org.lockss.laaws.rs.impl.ArtifactContinuationToken;
import org.lockss.laaws.rs.impl.AuidContinuationToken;
import org.lockss.laaws.rs.impl.ServiceImplUtil;
import org.lockss.log.L4JLogger;
import org.lockss.rs.BaseLockssRepository;
import org.lockss.rs.io.index.ArtifactIndex;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.base.LockssConfigurableService;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.TimerQueue;
import org.lockss.util.UrlUtil;
import org.lockss.util.rest.exception.LockssRestHttpException;
import org.lockss.util.rest.repo.LockssRepository;
import org.lockss.util.rest.repo.model.Artifact;
import org.lockss.util.rest.repo.model.ArtifactPageInfo;
import org.lockss.util.rest.repo.model.AuSize;
import org.lockss.util.rest.repo.model.AuidPageInfo;
import org.lockss.util.rest.repo.model.PageInfo;
import org.lockss.util.rest.repo.util.ArtifactComparators;
import org.lockss.util.time.Deadline;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AusApiServiceImpl
extends BaseSpringApiServiceImpl
implements AusApiDelegate,
LockssConfigurableService {
    private static L4JLogger log = L4JLogger.getLogger();
    @Autowired
    LockssRepository repo;
    private final HttpServletRequest request;
    private Set<String> bulkAuids = new CopyOnWriteArraySet();
    private Map<Integer, Iterator<Artifact>> artifactIterators = new ConcurrentHashMap();
    private Map<Integer, Iterator<String>> auidIterators = new ConcurrentHashMap();
    public static final String PREFIX = "org.lockss.repository.";
    public static final String PARAM_DEFAULT_ARTIFACT_PAGESIZE = "org.lockss.repository.artifact.pagesize.default";
    public static final int DEFAULT_DEFAULT_ARTIFACT_PAGESIZE = 1000;
    private int defaultArtifactPageSize = 1000;
    public static final String PARAM_MAX_ARTIFACT_PAGESIZE = "org.lockss.repository.artifact.pagesize.max";
    public static final int DEFAULT_MAX_ARTIFACT_PAGESIZE = 2000;
    private int maxArtifactPageSize = 2000;
    public static final String PARAM_DEFAULT_AUID_PAGESIZE = "org.lockss.repository.auid.pagesize.default";
    public static final int DEFAULT_DEFAULT_AUID_PAGESIZE = 1000;
    private int defaultAuidPageSize = 1000;
    public static final String PARAM_MAX_AUID_PAGESIZE = "org.lockss.repository.auid.pagesize.max";
    public static final int DEFAULT_MAX_AUID_PAGESIZE = 2000;
    private int maxAuidPageSize = 2000;
    public static final String PARAM_BULK_INDEX_BATCH_SIZE = "org.lockss.repository.bulkIndexBatchSize";
    public static final int DEFAULT_BULK_INDEX_BATCH_SIZE = 1000;
    private int bulkIndexBatchSize = 1000;
    public static final String PARAM_BULK_INDEX_ENABLED = "org.lockss.repository.bulkIndexEnabled";
    public static final boolean DEFAULT_BULK_INDEX_ENABLED = true;
    private boolean bulkIndexEnabled = true;
    public static final String PARAM_ARTIFACT_ITERATOR_TIMEOUT = "org.lockss.repository.artifact.iterator.timeout";
    public static final long DEFAULT_ARTIFACT_ITERATOR_TIMEOUT = 172800000L;
    private long artifactIteratorTimeout = 172800000L;
    public static final String PARAM_AUID_ITERATOR_TIMEOUT = "org.lockss.repository.auid.iterator.timeout";
    public static final long DEFAULT_AUID_ITERATOR_TIMEOUT = 172800000L;
    private long auidIteratorTimeout = 172800000L;
    TimerQueue.Request iteratorMapTimer;
    private TimerQueue.Callback iteratorMapTimeout = new /* Unavailable Anonymous Inner Class!! */;

    @Autowired
    public AusApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    public void setConfig(Configuration newConfig, Configuration prevConfig, Configuration.Differences changedKeys) {
        if (changedKeys.contains(PREFIX)) {
            this.defaultArtifactPageSize = newConfig.getInt(PARAM_DEFAULT_ARTIFACT_PAGESIZE, 1000);
            this.maxArtifactPageSize = newConfig.getInt(PARAM_MAX_ARTIFACT_PAGESIZE, 2000);
            this.defaultAuidPageSize = newConfig.getInt(PARAM_DEFAULT_AUID_PAGESIZE, 1000);
            this.maxAuidPageSize = newConfig.getInt(PARAM_MAX_AUID_PAGESIZE, 2000);
            this.bulkIndexBatchSize = newConfig.getInt(PARAM_BULK_INDEX_BATCH_SIZE, 1000);
            this.bulkIndexEnabled = newConfig.getBoolean(PARAM_BULK_INDEX_ENABLED, true);
            if (!(this.artifactIterators instanceof PassiveExpiringMap)) {
                this.artifactIterators = Collections.synchronizedMap(new PassiveExpiringMap(this.artifactIteratorTimeout));
            }
            if (!(this.auidIterators instanceof PassiveExpiringMap)) {
                this.auidIterators = Collections.synchronizedMap(new PassiveExpiringMap(this.auidIteratorTimeout));
            }
            if (this.iteratorMapTimer != null) {
                TimerQueue.cancel((TimerQueue.Request)this.iteratorMapTimer);
            }
            this.iteratorMapTimer = TimerQueue.schedule((Deadline)Deadline.in((long)3600000L), (long)3600000L, (TimerQueue.Callback)this.iteratorMapTimeout, null);
        }
    }

    private void timeoutIterators(Map map) {
        map.isEmpty();
    }

    public ResponseEntity<ArtifactPageInfo> getArtifacts(String auid, String namespace, String url, String urlPrefix, String version, Boolean includeUncommitted, Integer limit, String continuationToken) {
        String parsedRequest = String.format("namespace: %s, auid: %s, url: %s, urlPrefix: %s, version: %s, includeUncommitted: %s, limit: %s, continuationToken: %s, requestUrl: %s", namespace, auid, url, urlPrefix, version, includeUncommitted, limit, continuationToken, ServiceImplUtil.getFullRequestUrl((HttpServletRequest)this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, (String)parsedRequest);
        Integer requestLimit = limit;
        limit = ServiceImplUtil.validateLimit((Integer)requestLimit, (int)this.defaultArtifactPageSize, (int)this.maxArtifactPageSize, (String)parsedRequest);
        ArtifactContinuationToken requestAct = null;
        try {
            requestAct = new ArtifactContinuationToken(continuationToken);
            log.trace("requestAct = {}", (Object)requestAct);
        }
        catch (IllegalArgumentException iae) {
            String message = "Invalid continuation token '" + continuationToken + "'";
            log.warn(message);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, message, parsedRequest);
        }
        try {
            Artifact artifact;
            boolean isLatestVersion = version == null || version.toLowerCase().equals("latest");
            log.trace("isLatestVersion = {}", (Object)isLatestVersion);
            boolean isAllVersions = version != null && version.toLowerCase().equals("all");
            log.trace("isAllVersions = {}", (Object)isAllVersions);
            if (urlPrefix != null && url != null) {
                String errorMessage = "The 'urlPrefix' and 'url' arguments are mutually exclusive";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            boolean isSpecificVersion = !isAllVersions && !isLatestVersion;
            log.trace("isSpecificVersion = {}", (Object)isSpecificVersion);
            boolean isAllUrls = url == null && urlPrefix == null;
            log.trace("isAllUrls = {}", (Object)isAllUrls);
            if (isSpecificVersion && (isAllUrls || urlPrefix != null)) {
                String errorMessage = "A specific 'version' argument requires a 'url' argument";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            boolean includeUncommittedValue = includeUncommitted != null && includeUncommitted != false;
            log.trace("includeUncommittedValue = {}", (Object)includeUncommittedValue);
            if (!isSpecificVersion && includeUncommittedValue) {
                String errorMessage = "Including an uncommitted artifact requires a specific 'version' argument";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            int numericVersion = 0;
            if (isSpecificVersion) {
                try {
                    numericVersion = Integer.parseInt(version);
                    log.trace("numericVersion = {}", (Object)numericVersion);
                    if (numericVersion <= 0) {
                        String errorMessage = "The 'version' argument is not a positive integer";
                        log.warn(errorMessage);
                        log.warn("Parsed request: {}", (Object)parsedRequest);
                        throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
                    }
                }
                catch (NumberFormatException nfe) {
                    String errorMessage = "The 'version' argument is invalid";
                    log.warn(errorMessage);
                    log.warn("Parsed request: {}", (Object)parsedRequest);
                    throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
                }
            }
            Iterable artifactIterable = null;
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            Iterator iterator = null;
            boolean missingIterator = false;
            Integer iteratorHashCode = requestAct.getIteratorHashCode();
            if (iteratorHashCode != null) {
                iterator = (Iterator)this.artifactIterators.remove(iteratorHashCode);
                boolean bl = missingIterator = iterator == null;
            }
            if (isAllUrls && isAllVersions) {
                log.trace("All versions of all URLs");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifactsAllVersions(namespace, auid);
                }
            } else if (urlPrefix != null && isAllVersions) {
                log.trace("All versions of all URLs matching a prefix");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifactsWithPrefixAllVersions(namespace, auid, urlPrefix);
                }
            } else if (url != null && isAllVersions) {
                log.trace("All versions of a URL");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifactsAllVersions(namespace, auid, url);
                }
            } else if (isAllUrls && isLatestVersion) {
                log.trace("Latest versions of all URLs");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifacts(namespace, auid);
                }
            } else if (urlPrefix != null && isLatestVersion) {
                log.trace("Latest versions of all URLs matching a prefix");
                if (iterator == null) {
                    artifactIterable = this.repo.getArtifactsWithPrefix(namespace, auid, urlPrefix);
                }
            } else if (url != null && isLatestVersion) {
                log.trace("Latest version of a URL");
                artifact = this.repo.getArtifact(namespace, auid, url);
                log.trace("artifact = {}", (Object)artifact);
                if (artifact != null) {
                    artifacts.add(artifact);
                }
            } else if (url != null && numericVersion > 0) {
                log.trace("Given version of a URL");
                log.trace("namespace = {}", (Object)namespace);
                log.trace("auid = {}", (Object)auid);
                log.trace("url = {}", (Object)url);
                log.trace("numericVersion = {}", (Object)numericVersion);
                log.trace("includeUncommittedValue = {}", (Object)includeUncommittedValue);
                artifact = this.repo.getArtifactVersion(namespace, auid, url, Integer.valueOf(numericVersion), includeUncommittedValue);
                log.trace("artifact = {}", (Object)artifact);
                if (artifact != null) {
                    artifacts.add(artifact);
                }
            } else {
                String errorMessage = "The request could not be understood";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            ArtifactContinuationToken responseAct = null;
            if (iterator != null || artifactIterable != null) {
                Artifact lastArtifact;
                if (iterator == null) {
                    iterator = artifactIterable.iterator();
                    if (missingIterator) {
                        lastArtifact = new Artifact();
                        lastArtifact.setNamespace(requestAct.getNamespace());
                        lastArtifact.setAuid(requestAct.getAuid());
                        lastArtifact.setUri(requestAct.getUri());
                        lastArtifact.setVersion(requestAct.getVersion());
                        while (iterator.hasNext()) {
                            Artifact artifact2 = (Artifact)iterator.next();
                            if (ArtifactComparators.BY_URI_BY_DECREASING_VERSION.compare(artifact2, lastArtifact) <= 0) continue;
                            artifacts.add(artifact2);
                            break;
                        }
                    }
                }
                ServiceImplUtil.populateArtifacts(iterator, (Integer)limit, artifacts);
                if (iterator.hasNext()) {
                    iteratorHashCode = iterator.hashCode();
                    this.artifactIterators.put(iteratorHashCode, iterator);
                    lastArtifact = (Artifact)artifacts.get(artifacts.size() - 1);
                    responseAct = new ArtifactContinuationToken(lastArtifact.getNamespace(), lastArtifact.getAuid(), lastArtifact.getUri(), lastArtifact.getVersion(), iteratorHashCode);
                    log.trace("responseAct = {}", (Object)responseAct);
                }
            }
            log.trace("artifacts.size() = {}", (Object)artifacts.size());
            PageInfo pageInfo = new PageInfo();
            pageInfo.setResultsPerPage(Integer.valueOf(artifacts.size()));
            StringBuffer curLinkBuffer = this.request.getRequestURL();
            if (this.request.getQueryString() != null && !this.request.getQueryString().trim().isEmpty()) {
                curLinkBuffer.append("?").append(this.request.getQueryString());
            }
            String curLink = curLinkBuffer.toString();
            log.trace("curLink = {}", (Object)curLink);
            pageInfo.setCurLink(curLink);
            if (responseAct != null) {
                continuationToken = responseAct.toWebResponseContinuationToken();
                pageInfo.setContinuationToken(continuationToken);
                StringBuffer nextLinkBuffer = this.request.getRequestURL();
                boolean hasQueryParameters = false;
                if (curLink.indexOf("limit=") > 0) {
                    nextLinkBuffer.append("?limit=").append(requestLimit);
                    hasQueryParameters = true;
                }
                if (url != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("url=").append(UrlUtil.encodeUrl((String)url));
                }
                if (urlPrefix != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("urlPrefix=").append(UrlUtil.encodeUrl((String)urlPrefix));
                }
                if (version != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("version=").append(version);
                }
                if (includeUncommitted != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("includeUncommitted=").append(includeUncommitted);
                }
                if ((continuationToken = pageInfo.getContinuationToken()) != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("continuationToken=").append(UrlUtil.encodeUrl((String)continuationToken));
                }
                nextLinkBuffer.append("&namespace=").append(UrlUtil.encodeUrl((String)namespace));
                String nextLink = nextLinkBuffer.toString();
                log.trace("nextLink = {}", (Object)nextLink);
                pageInfo.setNextLink(nextLink);
            }
            ArtifactPageInfo artifactPageInfo = new ArtifactPageInfo();
            artifactPageInfo.setArtifacts(artifacts);
            artifactPageInfo.setPageInfo(pageInfo);
            log.trace("artifactPageInfo = {}", (Object)artifactPageInfo);
            log.debug2("Returning OK.");
            return new ResponseEntity((Object)artifactPageInfo, HttpStatus.OK);
        }
        catch (IOException e) {
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, "IOException", (Throwable)e, parsedRequest);
        }
    }

    public ResponseEntity<AuSize> getArtifactsSize(String auid, String namespace) {
        String parsedRequest = String.format("namespace: %s, auid: %s, requestUrl: %s", namespace, auid, ServiceImplUtil.getFullRequestUrl((HttpServletRequest)this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        try {
            ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, (String)parsedRequest);
            AuSize result = this.repo.auSize(namespace, auid);
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IOException e) {
            String errorMessage = "Unexpected exception caught while attempting to get artifacts size";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.APPLICATION_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    public ResponseEntity<AuidPageInfo> getAus(String namespace, Integer limit, String continuationToken) {
        String parsedRequest = String.format("namespace: %s, requestUrl: %s", namespace, ServiceImplUtil.getFullRequestUrl((HttpServletRequest)this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, (String)parsedRequest);
        Integer requestLimit = limit;
        limit = ServiceImplUtil.validateLimit((Integer)requestLimit, (int)this.defaultAuidPageSize, (int)this.maxAuidPageSize, (String)parsedRequest);
        AuidContinuationToken requestAct = null;
        try {
            requestAct = new AuidContinuationToken(continuationToken);
            log.trace("requestAct = {}", (Object)requestAct);
        }
        catch (IllegalArgumentException iae) {
            String message = "Invalid continuation token '" + continuationToken + "'";
            log.warn(message);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, message, parsedRequest);
        }
        try {
            ArrayList<String> auids = new ArrayList<String>();
            AuidContinuationToken responseAct = null;
            Iterator iterator = null;
            Integer iteratorHashCode = requestAct.getIteratorHashCode();
            if (iteratorHashCode == null) {
                iterator = this.repo.getAuIds(namespace).iterator();
            } else {
                iterator = (Iterator)this.auidIterators.remove(iteratorHashCode);
                if (iterator == null) {
                    String lastAuid = requestAct.getAuid();
                    iterator = this.repo.getAuIds(namespace).iterator();
                    while (iterator.hasNext()) {
                        String auid = (String)iterator.next();
                        if (auid.compareTo(lastAuid) <= 0) continue;
                        auids.add(auid);
                        break;
                    }
                }
            }
            this.populateAus(iterator, limit, auids);
            if (iterator.hasNext()) {
                iteratorHashCode = iterator.hashCode();
                this.auidIterators.put(iteratorHashCode, iterator);
                responseAct = new AuidContinuationToken((String)auids.get(auids.size() - 1), iteratorHashCode);
                log.trace("responseAct = {}", (Object)responseAct);
            }
            log.trace("auids.size() = {}", (Object)auids.size());
            PageInfo pageInfo = new PageInfo();
            pageInfo.setResultsPerPage(Integer.valueOf(auids.size()));
            StringBuffer curLinkBuffer = this.request.getRequestURL();
            if (this.request.getQueryString() != null && !this.request.getQueryString().trim().isEmpty()) {
                curLinkBuffer.append("?").append(this.request.getQueryString());
            }
            String curLink = curLinkBuffer.toString();
            log.trace("curLink = {}", (Object)curLink);
            pageInfo.setCurLink(curLink);
            if (responseAct != null) {
                continuationToken = responseAct.toWebResponseContinuationToken();
                pageInfo.setContinuationToken(continuationToken);
                StringBuffer nextLinkBuffer = this.request.getRequestURL();
                boolean hasQueryParameters = false;
                if (curLink.indexOf("limit=") > 0) {
                    nextLinkBuffer.append("?limit=").append(requestLimit);
                    hasQueryParameters = true;
                }
                if (continuationToken != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("continuationToken=").append(UrlUtil.encodeUrl((String)continuationToken));
                }
                nextLinkBuffer.append("&namespace=").append(UrlUtil.encodeUrl((String)namespace));
                String nextLink = nextLinkBuffer.toString();
                log.trace("nextLink = {}", (Object)nextLink);
                pageInfo.setNextLink(nextLink);
            }
            AuidPageInfo auidPageInfo = new AuidPageInfo();
            auidPageInfo.setAuids(auids);
            auidPageInfo.setPageInfo(pageInfo);
            log.trace("auidPageInfo = {}", (Object)auidPageInfo);
            log.debug2("Returning OK.");
            return new ResponseEntity((Object)auidPageInfo, HttpStatus.OK);
        }
        catch (IOException e) {
            String errorMessage = "Unexpected exception caught while attempting to get AU ids";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    public ResponseEntity<Void> handleBulkAuOp(String auid, String op, String namespace) {
        String parsedRequest = String.format("namespace: %s, auid: %s, op: %s, requestUrl: %s", namespace, auid, op, ServiceImplUtil.getFullRequestUrl((HttpServletRequest)this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        if (this.bulkIndexEnabled) {
            ArtifactIndex index = ((BaseLockssRepository)this.repo).getArtifactIndex();
            try {
                switch (op) {
                    case "start": {
                        log.debug("startBulkStore({}, {})", (Object)namespace, (Object)auid);
                        this.bulkAuids.add(auid);
                        index.startBulkStore(namespace, auid);
                        break;
                    }
                    case "finish": {
                        log.debug("finishBulkStore({}, {})", (Object)namespace, (Object)auid);
                        this.bulkAuids.remove(auid);
                        index.finishBulkStore(namespace, auid, this.bulkIndexBatchSize);
                        break;
                    }
                    default: {
                        throw new LockssRestServiceException("Unknown bulk operation").setServerErrorType(LockssRestHttpException.ServerErrorType.NONE).setHttpStatus(HttpStatus.BAD_REQUEST).setServletPath(this.request.getServletPath()).setParsedRequest(parsedRequest);
                    }
                }
            }
            catch (IOException e) {
                String errorMessage = String.format("IOException attempting to start or finish bulk store: %s", auid);
                log.warn(errorMessage, (Throwable)e);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.APPLICATION_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
            }
        } else {
            log.debug2("Bulk indexing disabled, ignoring bulk {} for {}", (Object)op, (Object)auid);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    private void populateAus(Iterator<String> iterator, Integer limit, List<String> auids) {
        log.debug2("limit = {}, auids = {}", (Object)limit, auids);
        for (int auidCount = auids.size(); auidCount < limit && iterator.hasNext(); ++auidCount) {
            auids.add(iterator.next());
        }
    }

    static /* synthetic */ Map access$000(AusApiServiceImpl x0) {
        return x0.artifactIterators;
    }

    static /* synthetic */ void access$100(AusApiServiceImpl x0, Map x1) {
        x0.timeoutIterators(x1);
    }

    static /* synthetic */ Map access$200(AusApiServiceImpl x0) {
        return x0.auidIterators;
    }
}

