/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.archive.wayback.surt.SURTTokenizer;
import org.lockss.laaws.rs.api.WaybackApiDelegate;
import org.lockss.laaws.rs.impl.ServiceImplUtil;
import org.lockss.laaws.rs.impl.WaybackApiServiceImpl;
import org.lockss.laaws.rs.model.CdxRecord;
import org.lockss.laaws.rs.model.CdxRecords;
import org.lockss.log.L4JLogger;
import org.lockss.rs.BaseLockssRepository;
import org.lockss.rs.io.storage.warc.WarcArtifactDataStore;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.rest.repo.LockssRepository;
import org.lockss.util.rest.repo.model.Artifact;
import org.lockss.util.rest.repo.model.ArtifactData;
import org.lockss.util.rest.repo.model.ArtifactIdentifier;
import org.lockss.util.rest.repo.model.ArtifactVersions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WaybackApiServiceImpl
extends BaseSpringApiServiceImpl
implements WaybackApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    private static String charsetName = StandardCharsets.UTF_8.name();
    @Autowired
    BaseLockssRepository repo;
    private final HttpServletRequest request;

    @Autowired
    public WaybackApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    public ResponseEntity<String> getCdxOwb(String namespace, String q, Integer count, Integer startPage, String accept, String acceptEncoding) {
        log.debug2("namespace = {}", (Object)namespace);
        log.debug2("q = {}", (Object)q);
        log.debug2("count = {}", (Object)count);
        log.debug2("startPage = {}", (Object)startPage);
        log.debug2("accept = {}", (Object)accept);
        log.debug2("acceptEncoding = {}", (Object)acceptEncoding);
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            log.trace("header name = {}, value = {}", (Object)name, (Object)this.request.getHeader(name));
        }
        log.trace("parameterMap = {}", (Object)this.request.getParameterMap());
        String parsedRequest = this.getParsedRequest(this.request, namespace);
        log.trace("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, (String)parsedRequest);
        ServiceImplUtil.validatePagination((Integer)count, (Integer)startPage, (String)parsedRequest);
        try {
            Map openWayBackQuery = WaybackApiServiceImpl.parseOpenWayBackQueryString((String)q);
            log.trace("openWayBackQuery = {}", (Object)openWayBackQuery);
            String url = (String)openWayBackQuery.get("url");
            log.trace("url = {}", (Object)url);
            openWayBackQuery.put("canonicalUrl", url);
            CdxRecords records = new CdxRecords(openWayBackQuery, charsetName);
            boolean isPrefix = openWayBackQuery.containsKey("type") && ((String)openWayBackQuery.get("type")).toLowerCase().equals("prefixquery");
            log.trace("isPrefix = {}", (Object)isPrefix);
            String date = null;
            if (openWayBackQuery.containsKey("date") && !((String)openWayBackQuery.get("date")).trim().isEmpty()) {
                date = ((String)openWayBackQuery.get("date")).trim();
                log.trace("date = {}", (Object)date);
            }
            this.getCdxRecords(namespace, url, (LockssRepository)this.repo, isPrefix, count, startPage, date, records);
            String result = records.toXmlText();
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException bre) {
            String message = "Cannot get the CDX records for namespace = '" + namespace + "', q = '" + q + "'";
            log.error(message, (Throwable)bre);
            return this.getStringErrorResponseEntity(HttpStatus.BAD_REQUEST, message, bre);
        }
        catch (Exception e) {
            String message = "Cannot get the CDX records for namespace = '" + namespace + "', q = '" + q + "'";
            log.error(message, (Throwable)e);
            return this.getStringErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
    }

    public ResponseEntity<String> getCdxPywb(String namespace, String url, Integer limit, String matchType, String sort, String closest, String output, String fl, String accept, String acceptEncoding) {
        log.debug2("namespace = {}", (Object)namespace);
        log.debug2("url = {}", (Object)url);
        log.debug2("limit = {}", (Object)limit);
        log.debug2("matchType = {}", (Object)matchType);
        log.debug2("sort = {}", (Object)sort);
        log.debug2("closest = {}", (Object)closest);
        log.debug2("output = {}", (Object)output);
        log.debug2("fl = {}", (Object)fl);
        log.debug2("accept = {}", (Object)accept);
        log.debug2("acceptEncoding = {}", (Object)acceptEncoding);
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            log.trace("header name = {}, value = {}", (Object)name, (Object)this.request.getHeader(name));
        }
        log.trace("parameterMap = {}", (Object)this.request.getParameterMap());
        String parsedRequest = this.getParsedRequest(this.request, namespace);
        log.trace("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, (String)parsedRequest);
        try {
            CdxRecords records = new CdxRecords();
            boolean isExact = matchType == null || matchType.toLowerCase().equals("exact");
            log.trace("isExact = {}", (Object)isExact);
            if (!isExact) {
                closest = null;
            }
            boolean isPrefix = matchType != null && matchType.toLowerCase().equals("prefix");
            log.trace("isPrefix = {}", (Object)isPrefix);
            Integer startPage = null;
            if (limit != null) {
                startPage = 1;
                ServiceImplUtil.validatePagination((Integer)limit, (Integer)startPage, (String)parsedRequest);
            }
            this.getCdxRecords(namespace, url, (LockssRepository)this.repo, isPrefix, limit, startPage, closest, records);
            String result = null;
            if (output == null || output.trim().isEmpty() || output.trim().toLowerCase().equals("cdx")) {
                result = records.toIaText();
            } else if (output.trim().toLowerCase().equals("json")) {
                result = records.toJson();
            } else {
                String errorMessage = "Invalid output request parameter: " + output;
                log.error(errorMessage);
                throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            log.trace("records.toJson() = {}", (Object)records.toJson());
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "Cannot get the CDX records for namespace = '" + namespace + "', url = '" + url + "'";
            log.error(message, (Throwable)iae);
            return this.getStringErrorResponseEntity(HttpStatus.BAD_REQUEST, message, (Exception)iae);
        }
        catch (Exception e) {
            String message = "Cannot get the CDX records for namespace = '" + namespace + "', url = '" + url + "'";
            log.error(message, (Throwable)e);
            return this.getStringErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
    }

    public ResponseEntity<Resource> getWarcArchive(String fileName, String accept, String acceptEncoding, String range) {
        log.debug2("fileName = {}", (Object)fileName);
        log.debug2("accept = {}", (Object)accept);
        log.debug2("acceptEncoding = {}", (Object)acceptEncoding);
        log.debug2("range = {}", (Object)range);
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            log.trace("header name = {}, value = {}", (Object)name, (Object)this.request.getHeader(name));
        }
        log.trace("parameterMap = {}", (Object)this.request.getParameterMap());
        String parsedRequest = String.format("fileName: %s, requestUrl: %s", fileName, ServiceImplUtil.getFullRequestUrl((HttpServletRequest)this.request));
        log.trace("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, (String)parsedRequest);
        try {
            String namespace = ServiceImplUtil.getArchiveFilenameNamespace((String)fileName, (String)parsedRequest);
            log.trace("namespace = {}", (Object)namespace);
            String artifactId = ServiceImplUtil.getArchiveFilenameArtifactId((String)fileName, (String)parsedRequest);
            log.trace("artifactId = {}", (Object)artifactId);
            ArtifactData artifactData = this.repo.getArtifactData(namespace, artifactId);
            log.trace("artifactData = {}", (Object)artifactData);
            if (artifactData == null) {
                throw new IllegalArgumentException("No artifact '" + artifactId + "' in repository");
            }
            InputStream inputStream = null;
            long warcRecordLength = 0L;
            File warcRecordFile = File.createTempFile("getWarcArchive", ".warc");
            warcRecordFile.deleteOnExit();
            try (DeferredFileOutputStream dfos = new DeferredFileOutputStream(0x100000, warcRecordFile);){
                WarcArtifactDataStore.writeArtifactData((ArtifactData)artifactData, (OutputStream)dfos);
                dfos.close();
                if (dfos.isInMemory()) {
                    log.trace("WARC record is in memory");
                    byte[] warcRecordBytes = dfos.getData();
                    warcRecordLength = warcRecordBytes.length;
                    inputStream = new ByteArrayInputStream(warcRecordBytes);
                } else {
                    log.trace("WARC record is in in file '{}'", (Object)warcRecordFile);
                    warcRecordLength = warcRecordFile.length();
                    inputStream = new FileInputStream(warcRecordFile);
                }
            }
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/warc");
            headers.setContentLength(warcRecordLength);
            log.trace("headers = {}", (Object)headers);
            return new ResponseEntity((Object)new InputStreamResource(inputStream), (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "Cannot get the archive for fileName = '" + fileName + "'";
            log.error(message, (Throwable)iae);
            return this.getResourceErrorResponseEntity(HttpStatus.BAD_REQUEST, message, (Exception)iae);
        }
        catch (Exception e) {
            String message = "Cannot get the archive for fileName = '" + fileName + "'";
            log.error(message, (Throwable)e);
            return this.getResourceErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
    }

    void getCdxRecords(String namespace, String url, LockssRepository repo, boolean isPrefix, Integer count, Integer startPage, String closest, CdxRecords records) throws IOException {
        log.debug2("namespace = {}", (Object)namespace);
        log.debug2("url = {}", (Object)url);
        log.debug2("isPrefix = {}", (Object)isPrefix);
        log.debug2("count = {}", (Object)count);
        log.debug2("startPage = {}", (Object)startPage);
        log.debug2("closest = {}", (Object)closest);
        Iterable iterable = null;
        iterable = isPrefix ? repo.getArtifactsWithUrlPrefixFromAllAus(namespace, url, ArtifactVersions.ALL) : repo.getArtifactsWithUrlFromAllAus(namespace, url, ArtifactVersions.ALL);
        Iterator<Object> artIterator = iterable.iterator();
        if (closest != null && !closest.trim().isEmpty()) {
            artIterator = this.getArtifactsSortedByTemporalGap(artIterator, closest).iterator();
        }
        this.getArtifactsCdxRecords(artIterator, repo, count, startPage, records);
    }

    void getArtifactsCdxRecords(Iterator<Artifact> artIterator, LockssRepository repo, Integer count, Integer startPage, CdxRecords records) throws IOException {
        log.debug2("count = {}", (Object)count);
        log.debug2("startPage = {}", (Object)startPage);
        int lastArticleSkipped = -1;
        int lastArticleIncluded = Integer.MAX_VALUE;
        if (count != null) {
            lastArticleSkipped = count * (startPage - 1) - 1;
            log.trace("lastArticleSkipped = {}", (Object)lastArticleSkipped);
            lastArticleIncluded = lastArticleSkipped + count;
            log.trace("lastArticleIncluded = {}", (Object)lastArticleIncluded);
        }
        int iteratorCounter = 0;
        while (artIterator.hasNext()) {
            Artifact artifact = artIterator.next();
            log.trace("artifact = {}", (Object)artifact);
            if (iteratorCounter > lastArticleSkipped) {
                String artifactUuid = artifact.getUuid();
                log.trace("artifactUuid = {}", (Object)artifactUuid);
                CdxRecord record = this.getCdxRecord(repo.getArtifactData(artifact, LockssRepository.IncludeContent.NEVER));
                log.trace("record = {}", (Object)record);
                records.addCdxRecord(record);
                log.trace("recordsCount = {}", (Object)records.getCdxRecordCount());
            }
            if (++iteratorCounter <= lastArticleIncluded) continue;
            break;
        }
    }

    CdxRecord getCdxRecord(ArtifactData artifactData) throws IOException {
        log.debug2("artifactData = {}", (Object)artifactData);
        CdxRecord record = new CdxRecord();
        String artifactUrl = artifactData.getIdentifier().getUri();
        log.trace("artifactUrl = {}", (Object)artifactUrl);
        String urlSortKey = SURTTokenizer.exactKey((String)artifactUrl);
        log.trace("urlSortKey = {}", (Object)urlSortKey);
        record.setUrlSortKey(urlSortKey);
        long timestamp = CdxRecord.computeNumericTimestamp((long)artifactData.getCollectionDate());
        log.trace("timestamp = {}", (Object)timestamp);
        record.setTimestamp(timestamp);
        record.setUrl(artifactUrl);
        MediaType ctype = artifactData.getHttpHeaders().getContentType();
        if (ctype != null) {
            record.setMimeType(ctype.toString());
        }
        record.setHttpStatus(artifactData.getHttpStatus().getStatusCode());
        record.setDigest(artifactData.getContentDigest());
        record.setLength(artifactData.getContentLength());
        record.setOffset(0L);
        ArtifactIdentifier artifactIdentifier = artifactData.getIdentifier();
        record.setArchiveName(ServiceImplUtil.getArtifactArchiveName((String)artifactIdentifier.getNamespace(), (String)artifactIdentifier.getUuid()));
        log.debug2("record = {}", (Object)record);
        return record;
    }

    List<Artifact> getArtifactsSortedByTemporalGap(Iterator<Artifact> artIterator, String closest) throws IOException {
        log.debug2("closest = {}", (Object)closest);
        long targetTimestamp = CdxRecord.computeCollectiondate((String)closest);
        log.trace("targetTimestamp = {}", (Object)targetTimestamp);
        ArrayList<ClosestArtifact> cas = new ArrayList<ClosestArtifact>();
        while (artIterator.hasNext()) {
            cas.add(new ClosestArtifact(artIterator.next(), targetTimestamp));
        }
        log.trace("cas.size() = {}", (Object)cas.size());
        cas.sort(Comparator.comparing(ClosestArtifact::getGap));
        ArrayList<Artifact> sortedArtifacts = new ArrayList<Artifact>();
        Iterator caIterator = cas.iterator();
        while (caIterator.hasNext()) {
            sortedArtifacts.add(((ClosestArtifact)caIterator.next()).getArtifact());
        }
        return sortedArtifacts;
    }

    private String getParsedRequest(HttpServletRequest request, String namespace) {
        return String.format("namespace: %s, requestUrl: %s", namespace, ServiceImplUtil.getFullRequestUrl((HttpServletRequest)request));
    }

    private static Map<String, String> parseOpenWayBackQueryString(String q) throws UnsupportedEncodingException {
        log.debug2("q = {}", (Object)q);
        try {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            for (String queryElement : q.split(" ")) {
                log.trace("queryElement = {}", (Object)queryElement);
                String[] elementFields = queryElement.split(":", 2);
                log.trace("elementFields[0] = {}", (Object)elementFields[0]);
                String value = URLDecoder.decode(elementFields[1], charsetName);
                log.trace("value = {}", (Object)value);
                queryMap.put(elementFields[0], value);
            }
            log.debug2("queryMap = {}", queryMap);
            return queryMap;
        }
        catch (UnsupportedEncodingException uee) {
            log.error("Exception caught parsing query", (Throwable)uee);
            throw uee;
        }
    }

    private ResponseEntity<String> getStringErrorResponseEntity(HttpStatus status, String message, Exception e) {
        String errorMessage = message;
        if (e != null) {
            errorMessage = errorMessage == null ? e.getMessage() : errorMessage + " - " + e.getMessage();
        }
        return new ResponseEntity((Object)ServiceImplUtil.toJsonError((int)status.value(), (String)errorMessage), status);
    }

    private ResponseEntity<Resource> getResourceErrorResponseEntity(HttpStatus status, String message, Exception e) {
        String errorMessage = message;
        if (e != null) {
            errorMessage = errorMessage == null ? e.getMessage() : errorMessage + " - " + e.getMessage();
        }
        String result = ServiceImplUtil.toJsonError((int)status.value(), (String)errorMessage);
        ByteArrayInputStream is = new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8));
        return new ResponseEntity((Object)new InputStreamResource((InputStream)is), status);
    }
}

