/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.output.ProxyOutputStream;

public class HttpBodyDigestOutputStream
extends ProxyOutputStream {
    private int currentState;
    private DigestOutputStream dos;
    public static final String DEFAULT_DIGEST_ALGORITHM = "SHA-256";

    public HttpBodyDigestOutputStream(OutputStream proxy) {
        super(proxy);
    }

    private boolean advanceState(int b) {
        switch (this.currentState) {
            case 0: {
                if (b != 13) break;
                this.currentState = 1;
                break;
            }
            case 1: {
                if (b == 10) {
                    this.currentState = 2;
                    break;
                }
                this.currentState = 0;
                break;
            }
            case 2: {
                if (b == 13) {
                    this.currentState = 3;
                    break;
                }
                this.currentState = 0;
                break;
            }
            case 3: {
                if (b == 10) {
                    return true;
                }
                this.currentState = 0;
            }
        }
        return false;
    }

    private boolean isDigesting() {
        return this.dos != null;
    }

    public void switchToDigest() {
        try {
            this.dos = new DigestOutputStream(this.out, MessageDigest.getInstance(DEFAULT_DIGEST_ALGORITHM));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private void switchToDigest(byte[] b, int off, int i, int len) throws IOException {
        int next = i + 1;
        super.write(b, off, next - off);
        this.switchToDigest();
        this.dos.write(b, next, len - (next - off));
    }

    public void write(int b) throws IOException {
        if (this.isDigesting()) {
            this.dos.write(b);
        } else {
            super.write(b);
            if (this.advanceState(b)) {
                this.switchToDigest();
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isDigesting()) {
            this.dos.write(b, off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                if (!this.advanceState((int)b[i])) continue;
                this.switchToDigest(b, off, i, len);
                return;
            }
            super.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        if (this.dos != null) {
            this.dos.flush();
        }
        super.flush();
    }

    public void close() throws IOException {
        if (this.dos != null) {
            this.dos.close();
        }
        super.close();
    }

    public MessageDigest getDigest() {
        return this.dos == null ? null : this.dos.getMessageDigest();
    }
}

