/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs;

import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.app.ManagerDescs;
import org.lockss.app.ServiceDescr;
import org.lockss.log.L4JLogger;
import org.lockss.repository.RepositoryDbManager;
import org.lockss.spring.base.BaseSpringBootApplication;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication(exclude={SolrAutoConfiguration.class})
@EnableSwagger2
public class RepositoryApplication
extends BaseSpringBootApplication
implements CommandLineRunner {
    private static L4JLogger log = L4JLogger.getLogger();
    private static final LockssApp.ManagerDesc[] myManagerDescs = new LockssApp.ManagerDesc[]{ManagerDescs.ACCOUNT_MANAGER_DESC, new LockssApp.ManagerDesc(LockssApp.managerKey(RepositoryDbManager.class), RepositoryDbManager.class.getName())};

    public static void main(String[] args) {
        log.info("Starting the application");
        RepositoryApplication.configure();
        SpringApplication.run(RepositoryApplication.class, (String[])args);
    }

    public void run(String ... args) {
        if (args != null && args.length > 0) {
            log.info("Starting the LOCKSS Repository Service");
            LockssApp.AppSpec spec = new LockssApp.AppSpec().setService(ServiceDescr.SVC_REPO).setArgs(args).addBootDefault("org.lockss.config.loadTdbs", "false").addAppConfig("org.lockss.startPlugins", "false").addAppDefault("org.lockss.plugin.startAllAus", "false").setSpringApplicatonContext(this.getApplicationContext()).setAppManagers(myManagerDescs);
            LockssApp.startStatic(LockssDaemon.class, (LockssApp.AppSpec)spec);
        }
    }
}

