/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import org.lockss.laaws.rs.api.ArchivesApiDelegate;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Validated
@Api(value="archives", description="the archives API")
@RequestMapping(value={""})
public interface ArchivesApi {
    public ArchivesApiDelegate getDelegate();

    @ApiOperation(value="Imports artifacts from an archive", nickname="addArtifacts", notes="", response=Resource.class, tags={"artifacts"})
    @ApiResponses(value={@ApiResponse(code=200, message="Status of artifacts imported from the archive, maybe partially. Return body is a sequence of JSON ImportStatus objects.", response=Resource.class), @ApiResponse(code=400, message="Invalid input"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=403, message="Client not authorized to create artifacts"), @ApiResponse(code=502, message="Internal error creating artifact")})
    @RequestMapping(value={"/archives"}, produces={"application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    default public ResponseEntity<Resource> addArtifacts(@ApiParam(value="Archival Unit ID (AUID) of new artifact", required=true) @RequestParam(value="auid", required=true) String auid, @ApiParam(value="Archive data containing artifacts") @Valid @RequestPart(value="archive", required=true) MultipartFile archive, @ApiParam(value="Namespace of the artifacts", defaultValue="lockss") @Valid @RequestParam(value="namespace", required=false, defaultValue="lockss") String namespace, @ApiParam(value="If true, artifacts with duplicate content will be stored, otherwise suppressed", defaultValue="false") @Valid @RequestParam(value="storeDuplicate", required=false, defaultValue="false") Boolean storeDuplicate, @ApiParam(value="If supplied, WARC records whose HTTP response status code matches the regular expression will not be imported") @Valid @RequestParam(value="excludeStatusPattern", required=false) String excludeStatusPattern) {
        return this.getDelegate().addArtifacts(auid, archive, namespace, storeDuplicate, excludeStatusPattern);
    }
}

