/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.lockss.laaws.rs.api.RepoinfoApiDelegate;
import org.lockss.util.rest.repo.model.RepositoryInfo;
import org.lockss.util.storage.StorageInfo;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Api(value="repoinfo", description="the repoinfo API")
@RequestMapping(value={""})
public interface RepoinfoApi {
    public RepoinfoApiDelegate getDelegate();

    @ApiOperation(value="Get repository information", nickname="getRepositoryInformation", notes="Get properties of the repository", response=RepositoryInfo.class, tags={"repo"})
    @ApiResponses(value={@ApiResponse(code=200, message="The repository information", response=RepositoryInfo.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/repoinfo"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<RepositoryInfo> getRepositoryInformation() {
        return this.getDelegate().getRepositoryInformation();
    }

    @ApiOperation(value="Get repository storage information", nickname="getStorageInfo", notes="Get properties of the repository storage", response=StorageInfo.class, tags={"repo"})
    @ApiResponses(value={@ApiResponse(code=200, message="The repository storage information", response=StorageInfo.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/repoinfo/storage"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<StorageInfo> getStorageInfo() {
        return this.getDelegate().getStorageInfo();
    }
}

