/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.configuration;

import java.io.File;
import java.io.IOException;
import org.lockss.app.LockssDaemon;
import org.lockss.jms.JMSManager;
import org.lockss.laaws.rs.configuration.RepositoryServiceProperties;
import org.lockss.log.L4JLogger;
import org.lockss.rs.BaseLockssRepository;
import org.lockss.rs.io.index.ArtifactIndex;
import org.lockss.rs.io.storage.ArtifactDataStore;
import org.lockss.util.Deadline;
import org.lockss.util.rest.repo.LockssRepository;
import org.lockss.util.rest.repo.util.JmsFactorySource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LockssRepositoryConfig {
    private static final L4JLogger log = L4JLogger.getLogger();
    private final RepositoryServiceProperties repoProps;
    private ArtifactDataStore store;
    private ArtifactIndex index;

    @Autowired
    public LockssRepositoryConfig(RepositoryServiceProperties repoProps, ArtifactIndex index, ArtifactDataStore store) {
        this.repoProps = repoProps;
        this.index = index;
        this.store = store;
    }

    @Bean
    public BaseLockssRepository createInitializedRepository() throws IOException {
        BaseLockssRepository repo = this.createLockssRepository();
        new Thread(() -> {
            try {
                log.debug("Initializing LOCKSS repository from thread");
                repo.initRepository();
            }
            catch (IOException e) {
                String errMsg = "Failed to initialize internal LOCKSS repository";
                log.error(errMsg, (Throwable)e);
                throw new IllegalStateException(errMsg);
            }
        }).start();
        new Thread(() -> this.initJmsFactory((LockssRepository)repo)).start();
        return repo;
    }

    public BaseLockssRepository createLockssRepository() throws IOException {
        log.debug("Starting internal LOCKSS repository [repoSpec: {}]", (Object)this.repoProps.getRepositorySpec());
        switch (this.repoProps.getRepositoryType()) {
            case "volatile": 
            case "local": 
            case "custom": {
                File stateDir = this.repoProps.getRepositoryStateDir();
                return new BaseLockssRepository(stateDir, this.index, this.store);
            }
        }
        String errMsg = String.format("Unknown repository specification '%s'", this.repoProps.getRepositorySpec());
        log.error(errMsg);
        throw new IllegalArgumentException(errMsg);
    }

    void initJmsFactory(LockssRepository repo) {
        if (repo instanceof JmsFactorySource) {
            JmsFactorySource jmsSource = (JmsFactorySource)repo;
            LockssDaemon daemon = this.getRunningLockssDaemon();
            if (daemon == null) {
                throw new IllegalStateException("LOCKSS daemon failed to start");
            }
            try {
                JMSManager mgr = (JMSManager)daemon.getManagerByType(JMSManager.class);
                jmsSource.setJmsFactory(mgr.getJmsFactory());
                log.info("Stored JmsFactory in {}", (Object)jmsSource);
            }
            catch (IllegalArgumentException e) {
                log.warn("Couldn't get JmsManager", (Throwable)e);
            }
        }
    }

    LockssDaemon getRunningLockssDaemon() {
        LockssDaemon daemon = null;
        while (daemon == null) {
            try {
                daemon = LockssDaemon.getLockssDaemon();
            }
            catch (IllegalStateException e) {
                log.warn("getLockssDaemon() timed out");
            }
        }
        try {
            while (!daemon.waitUntilAppRunning((org.lockss.util.time.Deadline)Deadline.in((long)300000L))) {
                log.warn("Still waiting for LOCKSS daemon to start");
            }
            return daemon;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }
}

