/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.configuration;

import java.io.File;
import java.io.IOException;
import org.lockss.config.ConfigManager;
import org.lockss.config.Configuration;
import org.lockss.laaws.rs.multipart.DigestMultipartResolver;
import org.lockss.log.L4JLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Configuration
public class RepositoryServiceSpringConfig {
    private static final L4JLogger log = L4JLogger.getLogger();
    public static String PARAM_MULTIPART_MAX_IN_MEMORY_SIZE = "org.lockss.spring.multipart.maxInMemorySize";
    public static String DEFAULT_MULTIPART_UPLOAD_DIR = "repo-server";
    public static String PARAM_MULTIPART_UPLOAD_DIR = "org.lockss.spring.multipart.uploadDir";
    public static final int DEFAULT_MULTIPART_MAX_IN_MEMORY_SIZE = 0x400000;
    @Autowired
    CommonsMultipartResolver cmResolver;

    @Bean
    public CommonsMultipartResolver multipartResolver() throws IOException {
        return new DigestMultipartResolver();
    }

    @EventListener
    public void configMgrCreated(ConfigManager.ConfigManagerCreatedEvent event) {
        log.debug2("ConfigManagerCreatedEvent triggered");
        ConfigManager.getConfigManager().registerConfigurationCallback((Configuration.Callback)new ConfigCallback());
    }

    private class ConfigCallback
    implements Configuration.Callback {
        private ConfigCallback() {
        }

        public void configurationChanged(org.lockss.config.Configuration newConfig, org.lockss.config.Configuration oldConfig, Configuration.Differences changedKeys) {
            if (changedKeys.contains("org.lockss.platform.tmpDir") || changedKeys.contains(PARAM_MULTIPART_UPLOAD_DIR)) {
                String uploadDir = newConfig.get(PARAM_MULTIPART_UPLOAD_DIR, DEFAULT_MULTIPART_UPLOAD_DIR);
                File tmpdir = new File(ConfigManager.getConfigManager().getTmpDir(), uploadDir);
                try {
                    log.debug("Setting CommonsMultipartResolver tmpdir to {}", (Object)tmpdir);
                    RepositoryServiceSpringConfig.this.cmResolver.setUploadTempDir((Resource)new FileSystemResource(tmpdir));
                }
                catch (IOException e) {
                    log.warn("Couldn't set CommonsMultipartResolver tmpdir to {}", (Object)tmpdir);
                }
            }
            if (changedKeys.contains(PARAM_MULTIPART_MAX_IN_MEMORY_SIZE)) {
                int maxInMem = newConfig.getInt(PARAM_MULTIPART_MAX_IN_MEMORY_SIZE, 0x400000);
                log.debug("Setting CommonsMultipartResolver maxInMemorySize to {}", (Object)maxInMem);
                RepositoryServiceSpringConfig.this.cmResolver.setMaxInMemorySize(maxInMem);
            }
        }
    }
}

