/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.lockss.config.Configuration;
import org.lockss.laaws.rs.api.ArtifactsApiDelegate;
import org.lockss.laaws.rs.impl.ArtifactContinuationToken;
import org.lockss.laaws.rs.impl.ServiceImplUtil;
import org.lockss.laaws.rs.multipart.DigestFileItem;
import org.lockss.log.L4JLogger;
import org.lockss.rs.BaseLockssRepository;
import org.lockss.rs.io.storage.warc.WarcArtifactData;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.base.LockssConfigurableService;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.StringUtil;
import org.lockss.util.TimerQueue;
import org.lockss.util.UrlUtil;
import org.lockss.util.jms.JmsUtil;
import org.lockss.util.rest.exception.LockssRestHttpException;
import org.lockss.util.rest.repo.LockssNoSuchArtifactIdException;
import org.lockss.util.rest.repo.LockssRepository;
import org.lockss.util.rest.repo.model.Artifact;
import org.lockss.util.rest.repo.model.ArtifactData;
import org.lockss.util.rest.repo.model.ArtifactIdentifier;
import org.lockss.util.rest.repo.model.ArtifactPageInfo;
import org.lockss.util.rest.repo.model.ArtifactProperties;
import org.lockss.util.rest.repo.model.ArtifactVersions;
import org.lockss.util.rest.repo.model.PageInfo;
import org.lockss.util.rest.repo.util.ArtifactCache;
import org.lockss.util.rest.repo.util.ArtifactComparators;
import org.lockss.util.rest.repo.util.ArtifactDataUtil;
import org.lockss.util.time.Deadline;
import org.lockss.util.time.TimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class ArtifactsApiServiceImpl
extends BaseSpringApiServiceImpl
implements ArtifactsApiDelegate,
LockssConfigurableService {
    private static L4JLogger log = L4JLogger.getLogger();
    public static final String APPLICATION_HTTP_RESPONSE_VALUE = "application/http;msgtype=response";
    public static final MediaType APPLICATION_HTTP_RESPONSE = MediaType.parseMediaType((String)"application/http;msgtype=response");
    @Autowired
    BaseLockssRepository repo;
    @Autowired
    ObjectMapper objMapper;
    private final HttpServletRequest request;
    private Set<String> bulkAuids = new CopyOnWriteArraySet<String>();
    private Map<Integer, Iterator<Artifact>> artifactIterators = new ConcurrentHashMap<Integer, Iterator<Artifact>>();
    public static final String PREFIX = "org.lockss.repository.";
    public static final String PARAM_SMALL_CONTENT_THRESHOLD = "org.lockss.repository.smallContentThreshold";
    public static final long DEFAULT_SMALL_CONTENT_THRESHOLD = 4096L;
    private long smallContentThreshold = 4096L;
    public static final String PARAM_DEFAULT_ARTIFACT_PAGESIZE = "org.lockss.repository.artifact.pagesize.default";
    public static final int DEFAULT_DEFAULT_ARTIFACT_PAGESIZE = 1000;
    private int defaultArtifactPageSize = 1000;
    public static final String PARAM_MAX_ARTIFACT_PAGESIZE = "org.lockss.repository.artifact.pagesize.max";
    public static final int DEFAULT_MAX_ARTIFACT_PAGESIZE = 2000;
    private int maxArtifactPageSize = 2000;
    public static final String PARAM_ARTIFACT_ITERATOR_TIMEOUT = "org.lockss.repository.artifact.iterator.timeout";
    public static final long DEFAULT_ARTIFACT_ITERATOR_TIMEOUT = 172800000L;
    private long artifactIteratorTimeout = 172800000L;
    TimerQueue.Request iteratorMapTimer;
    private TimerQueue.Callback iteratorMapTimeout = new TimerQueue.Callback(){

        public void timerExpired(Object cookie) {
            ArtifactsApiServiceImpl.this.timeoutIterators(ArtifactsApiServiceImpl.this.artifactIterators);
        }
    };

    @Autowired
    public ArtifactsApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    public void setConfig(Configuration newConfig, Configuration prevConfig, Configuration.Differences changedKeys) {
        if (changedKeys.contains(PREFIX)) {
            this.defaultArtifactPageSize = newConfig.getInt(PARAM_DEFAULT_ARTIFACT_PAGESIZE, 1000);
            this.maxArtifactPageSize = newConfig.getInt(PARAM_MAX_ARTIFACT_PAGESIZE, 2000);
            this.artifactIteratorTimeout = newConfig.getTimeInterval(PARAM_ARTIFACT_ITERATOR_TIMEOUT, 172800000L);
            this.smallContentThreshold = newConfig.getLong(PARAM_SMALL_CONTENT_THRESHOLD, 4096L);
            if (!(this.artifactIterators instanceof PassiveExpiringMap)) {
                this.artifactIterators = Collections.synchronizedMap(new PassiveExpiringMap(this.artifactIteratorTimeout));
            }
            if (this.iteratorMapTimer != null) {
                TimerQueue.cancel((TimerQueue.Request)this.iteratorMapTimer);
            }
            TimerQueue.schedule((Deadline)Deadline.in((long)3600000L), (long)3600000L, (TimerQueue.Callback)this.iteratorMapTimeout, null);
        }
    }

    private void timeoutIterators(Map map) {
        map.isEmpty();
    }

    @Override
    public ResponseEntity<Artifact> createArtifact(String properties, MultipartFile payload, String httpResponseHeader) {
        long start = System.currentTimeMillis();
        String parsedRequest = String.format("properties: %s, payload: %s, httpResponseHeader: %s: requestUrl: %s", properties, payload, httpResponseHeader, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, parsedRequest);
        try {
            boolean asHttpResponse = !StringUtil.isNullString((String)httpResponseHeader);
            ArtifactProperties props = (ArtifactProperties)this.objMapper.readValue(properties, ArtifactProperties.class);
            ArtifactIdentifier artifactId = ArtifactDataUtil.buildArtifactIdentifier((ArtifactProperties)props);
            if (artifactId.getVersion() != null) {
                throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, "Version property not allowed");
            }
            this.validateUri(artifactId.getUri(), parsedRequest);
            ArtifactData ad = WarcArtifactData.fromResource((InputStream)payload.getInputStream());
            ad.setIdentifier(artifactId);
            ad.setContentLength(payload.getSize());
            DigestFileItem item = (DigestFileItem)((CommonsMultipartFile)payload).getFileItem();
            String contentDigest = String.format("%s:%s", item.getDigest().getAlgorithm(), new String(Hex.encodeHex((byte[])item.getDigest().digest())));
            ad.setContentDigest(contentDigest);
            if (props.getCollectionDate() != null) {
                ad.setCollectionDate(props.getCollectionDate().longValue());
            }
            if (asHttpResponse) {
                try {
                    HttpResponse httpResponse = ArtifactDataUtil.getHttpResponseFromStream((InputStream)IOUtils.toInputStream((String)httpResponseHeader, (Charset)StandardCharsets.UTF_8));
                    ad.setHttpStatus(httpResponse.getStatusLine());
                    ad.setHttpHeaders(ArtifactDataUtil.transformHeaderArrayToHttpHeaders((Header[])httpResponse.getAllHeaders()));
                }
                catch (HttpException e) {
                    throw new HttpMessageNotReadableException("Error parsing HTTP response header part", (Throwable)e);
                }
            } else {
                ad.getHttpHeaders().set("Content-Type", ((CommonsMultipartFile)payload).getFileItem().getContentType());
            }
            try {
                Artifact artifact = this.repo.addArtifact(ad);
                long end = System.currentTimeMillis();
                log.debug2("Added new artifact [uuid: {}, duration: {} ms, length: {}]", (Object)artifact.getUuid(), (Object)TimeUtil.timeIntervalToString((long)(end - start)), (Object)StringUtil.sizeToString((long)payload.getSize()));
                return new ResponseEntity((Object)artifact, HttpStatus.OK);
            }
            catch (IOException e) {
                String errorMessage = "Caught IOException while attempting to add an artifact to the repository";
                log.warn(errorMessage, (Throwable)e);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
            }
        }
        catch (IOException e) {
            throw new HttpMessageNotReadableException("Could not read artifact data from content part", (Throwable)e);
        }
    }

    @Override
    public ResponseEntity<Void> deleteArtifact(String artifactid, String namespace) {
        String parsedRequest = String.format("namespace: %s, artifactid: %s, requestUrl: %s", namespace, artifactid, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, parsedRequest);
        try {
            String key = this.artifactKey(namespace, artifactid);
            this.repo.deleteArtifact(namespace, artifactid);
            this.sendCacheInvalidateArtifact(ArtifactCache.InvalidateOp.Delete, key);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (LockssNoSuchArtifactIdException e) {
            throw new LockssRestServiceException("Artifact not found", (Throwable)e).setUtcTimestamp(LocalDateTime.now(ZoneOffset.UTC)).setHttpStatus(HttpStatus.NOT_FOUND).setServletPath(this.request.getServletPath()).setServerErrorType(LockssRestHttpException.ServerErrorType.DATA_ERROR).setParsedRequest(parsedRequest);
        }
        catch (IOException e) {
            String errorMessage = String.format("IOException occurred while attempting to delete artifact from repository (artifactId: %s)", artifactid);
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.APPLICATION_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    public ResponseEntity getArtifactDataByMultipart(String artifactid, String namespace, String includeContent) {
        String parsedRequest = String.format("namespace: %s, artifactid: %s, includeContent: %s, requestUrl: %s", namespace, artifactid, includeContent, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, parsedRequest);
        try {
            log.debug2("Retrieving artifact [namespace: {}, artifactId: {}]", (Object)namespace, (Object)artifactid);
            ArtifactData artifactData = this.repo.getArtifactData(namespace, artifactid);
            MultiValueMap parts = ArtifactDataUtil.generateMultipartMapFromArtifactData((ArtifactData)artifactData, (LockssRepository.IncludeContent)LockssRepository.IncludeContent.valueOf((String)includeContent), (long)this.smallContentThreshold);
            return new ResponseEntity((Object)parts, HttpStatus.OK);
        }
        catch (LockssNoSuchArtifactIdException e) {
            throw new LockssRestServiceException("Artifact not found", (Throwable)e).setUtcTimestamp(LocalDateTime.now(ZoneOffset.UTC)).setHttpStatus(HttpStatus.NOT_FOUND).setServletPath(this.request.getServletPath()).setServerErrorType(LockssRestHttpException.ServerErrorType.DATA_ERROR).setParsedRequest(parsedRequest);
        }
        catch (IOException e) {
            String errorMessage = String.format("Caught IOException while attempting to retrieve artifact from repository [artifactId: %s]", artifactid);
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    @Override
    public ResponseEntity<Resource> getArtifactDataByPayload(String artifactId, String namespace, String includeContentParam) {
        LockssRepository.IncludeContent includeContent = LockssRepository.IncludeContent.valueOf((String)includeContentParam);
        String parsedRequest = String.format("namespace: %s, artifactId: %s, includeContent: %s, requestUrl: %s", namespace, artifactId, includeContent, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, parsedRequest);
        try {
            ArtifactData ad = this.repo.getArtifactData(namespace, artifactId);
            HttpHeaders httpHeaders = ad.getHttpHeaders();
            HttpHeaders respHeaders = new HttpHeaders();
            if (httpHeaders.containsKey((Object)"Content-Type")) {
                respHeaders.setContentType(httpHeaders.getContentType());
            }
            if (httpHeaders.containsKey((Object)"Last-Modified")) {
                respHeaders.setLastModified(httpHeaders.getLastModified());
            }
            respHeaders.setContentLength(ad.getContentLength());
            respHeaders.set("X-LockssRepo-Artifact-Digest", ad.getContentDigest());
            respHeaders.set("X-LockssRepo-Artifact-StoredDate", DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(ad.getStoreDate()).atZone(ZoneOffset.UTC)));
            if (includeContent == LockssRepository.IncludeContent.ALWAYS || includeContent == LockssRepository.IncludeContent.IF_SMALL && ad.getContentLength() <= this.smallContentThreshold) {
                respHeaders.set("X-LockssRepo-IncludesContent", "true");
                InputStreamResource resource = new InputStreamResource(ad.getInputStream());
                return new ResponseEntity((Object)resource, (MultiValueMap)respHeaders, HttpStatus.OK);
            }
            respHeaders.set("X-Lockss-Content-Length", String.valueOf(respHeaders.getContentLength()));
            respHeaders.setContentLength(0L);
            respHeaders.set("X-LockssRepo-IncludesContent", "false");
            return new ResponseEntity((MultiValueMap)respHeaders, HttpStatus.OK);
        }
        catch (LockssNoSuchArtifactIdException e) {
            throw new LockssRestServiceException("Artifact not found", (Throwable)e).setUtcTimestamp(LocalDateTime.now(ZoneOffset.UTC)).setHttpStatus(HttpStatus.NOT_FOUND).setServletPath(this.request.getServletPath()).setServerErrorType(LockssRestHttpException.ServerErrorType.DATA_ERROR).setParsedRequest(parsedRequest);
        }
        catch (IOException e) {
            String errorMessage = String.format("Caught IOException while attempting to retrieve artifact from repository [artifactId: %s]", artifactId);
            log.error(errorMessage, (Throwable)e);
            log.error("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    @Override
    public ResponseEntity<Resource> getArtifactDataByResponse(String artifactId, String namespace, String includeContentParam) {
        LockssRepository.IncludeContent includeContent = LockssRepository.IncludeContent.valueOf((String)includeContentParam);
        String parsedRequest = String.format("namespace: %s, artifactId: %s, includeContent: %s, requestUrl: %s", namespace, artifactId, includeContent, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, parsedRequest);
        try {
            ArtifactData ad = this.repo.getArtifactData(namespace, artifactId);
            boolean onlyHeaders = includeContent == LockssRepository.IncludeContent.NEVER || includeContent == LockssRepository.IncludeContent.IF_SMALL && ad.getContentLength() > this.smallContentThreshold;
            InputStream httpResponseStream = onlyHeaders ? new ByteArrayInputStream(ArtifactDataUtil.getHttpResponseHeader((ArtifactData)ad)) : ad.getResponseInputStream();
            InputStreamResource resource = new InputStreamResource(httpResponseStream);
            HttpHeaders restResponseHeaders = new HttpHeaders();
            restResponseHeaders.setContentType(APPLICATION_HTTP_RESPONSE);
            restResponseHeaders.set("X-LockssRepo-ArtifactDataType", ad.isHttpResponse() ? "response" : "resource");
            restResponseHeaders.set("X-LockssRepo-IncludesContent", String.valueOf(!onlyHeaders));
            restResponseHeaders.set("X-LockssRepo-Artifact-StoredDate", DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(ad.getStoreDate()).atZone(ZoneOffset.UTC)));
            return new ResponseEntity((Object)resource, (MultiValueMap)restResponseHeaders, HttpStatus.OK);
        }
        catch (LockssNoSuchArtifactIdException e) {
            throw new LockssRestServiceException("Artifact not found", (Throwable)e).setUtcTimestamp(LocalDateTime.now(ZoneOffset.UTC)).setHttpStatus(HttpStatus.NOT_FOUND).setServletPath(this.request.getServletPath()).setServerErrorType(LockssRestHttpException.ServerErrorType.DATA_ERROR).setParsedRequest(parsedRequest);
        }
        catch (IOException e) {
            String errorMessage = String.format("Caught IOException while attempting to retrieve artifact from repository [artifactId: %s]", artifactId);
            log.error(errorMessage, (Throwable)e);
            log.error("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    @Override
    public ResponseEntity<ArtifactPageInfo> getArtifactsFromAllAus(String namespace, String url, String urlPrefix, String versions, Integer limit, String continuationToken) {
        String parsedRequest = String.format("namespace: %s, url: %s, urlPrefix: %s, requestUrl: %s", namespace, url, urlPrefix, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, parsedRequest);
        Integer requestLimit = limit;
        limit = ServiceImplUtil.validateLimit(requestLimit, this.defaultArtifactPageSize, this.maxArtifactPageSize, parsedRequest);
        ArtifactContinuationToken requestAct = null;
        try {
            requestAct = new ArtifactContinuationToken(continuationToken);
            log.trace("requestAct = {}", (Object)requestAct);
        }
        catch (IllegalArgumentException iae) {
            String message = "Invalid continuation token '" + continuationToken + "'";
            log.warn(message);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, message, parsedRequest);
        }
        try {
            if (urlPrefix != null && url != null) {
                String errorMessage = "The 'urlPrefix' and 'url' arguments are mutually exclusive";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            Iterable artifactIterable = null;
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            Iterator<Object> iterator = null;
            boolean missingIterator = false;
            Integer iteratorHashCode = requestAct.getIteratorHashCode();
            if (iteratorHashCode != null) {
                iterator = this.artifactIterators.remove(iteratorHashCode);
                missingIterator = iterator == null;
            }
            ArtifactVersions artifactVersions = ArtifactVersions.valueOf((String)versions.toUpperCase());
            if (url != null) {
                artifactIterable = this.repo.getArtifactsWithUrlFromAllAus(namespace, url, artifactVersions);
            } else if (urlPrefix != null) {
                artifactIterable = this.repo.getArtifactsWithUrlPrefixFromAllAus(namespace, urlPrefix, artifactVersions);
            }
            ArtifactContinuationToken responseAct = null;
            if (iterator != null || artifactIterable != null) {
                Artifact lastArtifact;
                if (iterator == null) {
                    iterator = artifactIterable.iterator();
                    if (missingIterator) {
                        lastArtifact = new Artifact();
                        lastArtifact.setNamespace(requestAct.getNamespace());
                        lastArtifact.setAuid(requestAct.getAuid());
                        lastArtifact.setUri(requestAct.getUri());
                        lastArtifact.setVersion(requestAct.getVersion());
                        while (iterator.hasNext()) {
                            Artifact artifact = (Artifact)iterator.next();
                            if (ArtifactComparators.BY_URI_BY_DECREASING_VERSION.compare(artifact, lastArtifact) <= 0) continue;
                            artifacts.add(artifact);
                            break;
                        }
                    }
                }
                ServiceImplUtil.populateArtifacts(iterator, limit, artifacts);
                if (iterator.hasNext()) {
                    iteratorHashCode = iterator.hashCode();
                    this.artifactIterators.put(iteratorHashCode, iterator);
                    lastArtifact = (Artifact)artifacts.get(artifacts.size() - 1);
                    responseAct = new ArtifactContinuationToken(lastArtifact.getNamespace(), lastArtifact.getAuid(), lastArtifact.getUri(), lastArtifact.getVersion(), iteratorHashCode);
                    log.trace("responseAct = {}", (Object)responseAct);
                }
            }
            log.trace("artifacts.size() = {}", (Object)artifacts.size());
            PageInfo pageInfo = new PageInfo();
            pageInfo.setResultsPerPage(Integer.valueOf(artifacts.size()));
            StringBuffer curLinkBuffer = this.request.getRequestURL();
            if (this.request.getQueryString() != null && !this.request.getQueryString().trim().isEmpty()) {
                curLinkBuffer.append("?").append(this.request.getQueryString());
            }
            String curLink = curLinkBuffer.toString();
            log.trace("curLink = {}", (Object)curLink);
            pageInfo.setCurLink(curLink);
            if (responseAct != null) {
                continuationToken = responseAct.toWebResponseContinuationToken();
                pageInfo.setContinuationToken(continuationToken);
                StringBuffer nextLinkBuffer = this.request.getRequestURL();
                boolean hasQueryParameters = false;
                if (curLink.indexOf("limit=") > 0) {
                    nextLinkBuffer.append("?limit=").append(requestLimit);
                    hasQueryParameters = true;
                }
                if (url != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("url=").append(UrlUtil.encodeUrl((String)url));
                }
                if (urlPrefix != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("urlPrefix=").append(UrlUtil.encodeUrl((String)urlPrefix));
                }
                if ((continuationToken = pageInfo.getContinuationToken()) != null) {
                    if (!hasQueryParameters) {
                        nextLinkBuffer.append("?");
                        hasQueryParameters = true;
                    } else {
                        nextLinkBuffer.append("&");
                    }
                    nextLinkBuffer.append("continuationToken=").append(UrlUtil.encodeUrl((String)continuationToken));
                }
                String nextLink = nextLinkBuffer.toString();
                log.trace("nextLink = {}", (Object)nextLink);
                pageInfo.setNextLink(nextLink);
            }
            ArtifactPageInfo artifactPageInfo = new ArtifactPageInfo();
            artifactPageInfo.setArtifacts(artifacts);
            artifactPageInfo.setPageInfo(pageInfo);
            log.trace("artifactPageInfo = {}", (Object)artifactPageInfo);
            log.debug2("Returning OK.");
            return new ResponseEntity((Object)artifactPageInfo, HttpStatus.OK);
        }
        catch (IOException e) {
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, "IOException", (Throwable)e, parsedRequest);
        }
    }

    public ResponseEntity updateArtifact(String artifactid, Boolean committed, String namespace) {
        String parsedRequest = String.format("namespace: %s, artifactid: %s, committed: %s, requestUrl: %s", namespace, artifactid, committed, ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, parsedRequest);
        try {
            if (!committed.booleanValue()) {
                throw new LockssRestServiceException("Cannot uncommit").setServerErrorType(LockssRestHttpException.ServerErrorType.NONE).setHttpStatus(HttpStatus.BAD_REQUEST).setServletPath(this.request.getServletPath()).setParsedRequest(parsedRequest);
            }
            log.debug2("Committing artifact to permanent storage [artifactId: {}]", (Object)artifactid);
            Artifact updatedArtifact = this.repo.commitArtifact(namespace, artifactid);
            if (!this.bulkAuids.contains(updatedArtifact.getAuid())) {
                this.sendCacheInvalidateArtifact(ArtifactCache.InvalidateOp.Commit, this.artifactKey(namespace, artifactid));
            }
            return new ResponseEntity((Object)updatedArtifact, HttpStatus.OK);
        }
        catch (LockssNoSuchArtifactIdException e) {
            throw new LockssRestServiceException("Artifact not found", (Throwable)e).setUtcTimestamp(LocalDateTime.now(ZoneOffset.UTC)).setHttpStatus(HttpStatus.NOT_FOUND).setServletPath(this.request.getServletPath()).setServerErrorType(LockssRestHttpException.ServerErrorType.DATA_ERROR).setParsedRequest(parsedRequest);
        }
        catch (IOException e) {
            String errorMessage = String.format("IOException occurred while attempting to update artifact metadata (artifactId: %s)", artifactid);
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.APPLICATION_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    String artifactKey(String namespace, String artifactUuid) throws IOException {
        Artifact art = this.repo.getArtifactFromUuid(artifactUuid);
        if (art != null) {
            return art.makeKey();
        }
        log.error("Expected artifact not found, can't send invalidate [uuid: {}]", (Object)artifactUuid);
        return null;
    }

    protected void sendCacheInvalidateArtifact(ArtifactCache.InvalidateOp op, String key) {
        if (this.jmsProducer != null && key != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("CacheAction", "InvalidateArt");
            map.put("InvalidateOp", op.toString());
            map.put("ArtifactKey", key);
            try {
                this.jmsProducer.sendMap(map);
            }
            catch (JMSException e) {
                log.error("Couldn't send cache invalidate notification", (Throwable)e);
            }
        }
    }

    private static Boolean isHttpResponseType(MediaType type) {
        return APPLICATION_HTTP_RESPONSE.isCompatibleWith(type) && type.getParameters().equals(APPLICATION_HTTP_RESPONSE.getParameters());
    }

    private void validateUri(String uri, String parsedRequest) {
        log.debug2("uri = '{}'", (Object)uri);
        log.debug2("parsedRequest = '{}'", (Object)parsedRequest);
        if (StringUtil.isNullString((String)uri)) {
            String errorMessage = "The URI has not been provided";
            log.warn(errorMessage);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
        }
        log.debug2("uri '{}' is valid.", (Object)uri);
    }

    @PostConstruct
    private void init() {
        this.setUpJms(this.JMS_BOTH, "ArtifactCache", "ArtifactCacheTopic", new CacheInvalidateListener());
    }

    protected void jmsSetUpDone() {
        this.sendCacheFlush();
    }

    protected void sendCacheFlush() {
        if (this.jmsProducer != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("CacheAction", "Flush");
            try {
                this.jmsProducer.sendMap(map);
            }
            catch (JMSException e) {
                log.error("Couldn't send cache flush notification", (Throwable)e);
            }
        }
    }

    protected void sendPingResponse(String key) {
        if (this.jmsProducer != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("CacheAction", "EchoResp");
            map.put("ArtifactKey", key);
            try {
                this.jmsProducer.sendMap(map);
            }
            catch (JMSException e) {
                log.error("Couldn't send cache invalidate notification", (Throwable)e);
            }
        }
    }

    private class CacheInvalidateListener
    implements MessageListener {
        private CacheInvalidateListener() {
        }

        public void onMessage(Message message) {
            try {
                Map msgMap = (Map)JmsUtil.convertMessage((Message)message);
                String action = (String)msgMap.get("CacheAction");
                String key = (String)msgMap.get("ArtifactKey");
                log.debug2("Received Artifact cache message: {}: {}", (Object)action, (Object)key);
                if (action != null) {
                    switch (action) {
                        case "Echo": {
                            ArtifactsApiServiceImpl.this.sendPingResponse(key);
                            break;
                        }
                        case "InvalidateArt": 
                        case "InvalidateAu": 
                        case "EchoResp": 
                        case "Flush": {
                            break;
                        }
                        default: {
                            log.warn("Unknown message action: " + action);
                        }
                    }
                }
            }
            catch (RuntimeException | JMSException e) {
                log.error("Malformed Artifact cache message: " + message, e);
            }
        }
    }
}

