/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.IterableUtils;
import org.lockss.laaws.rs.api.NamespacesApiDelegate;
import org.lockss.laaws.rs.impl.ServiceImplUtil;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.rest.exception.LockssRestHttpException;
import org.lockss.util.rest.repo.LockssRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class NamespacesApiServiceImpl
extends BaseSpringApiServiceImpl
implements NamespacesApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    @Autowired
    LockssRepository repo;
    private final HttpServletRequest request;

    @Autowired
    public NamespacesApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public ResponseEntity<List<String>> getNamespaces() {
        String parsedRequest = String.format("requestUrl: %s", ServiceImplUtil.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady(this.repo, parsedRequest);
        try {
            List namespaces = IterableUtils.toList((Iterable)this.repo.getNamespaces());
            log.debug2("namespaces = {}", (Object)namespaces);
            return new ResponseEntity((Object)namespaces, HttpStatus.OK);
        }
        catch (IOException e) {
            String errorMessage = "Could not enumerate namespaces";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.DATA_ERROR, HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }
}

