/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.21).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.rs.api;

import org.lockss.util.rest.repo.model.Artifact;
import org.lockss.util.rest.repo.model.ArtifactPageInfo;
import org.springframework.core.io.Resource;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

@Validated
@Api(value = "artifacts", description = "the artifacts API")
@RequestMapping(value = "")
public interface ArtifactsApi {

    ArtifactsApiDelegate getDelegate();

    @ApiOperation(value = "Create an artifact", nickname = "createArtifact", notes = "", response = Artifact.class, tags={ "artifacts", })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "Artifact created", response = Artifact.class),
        @ApiResponse(code = 302, message = "Duplicate content; artifact not created"),
        @ApiResponse(code = 400, message = "Invalid input"),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to create artifacts"),
        @ApiResponse(code = 502, message = "Internal error creating artifact") })
    @RequestMapping(value = "/artifacts",
        produces = { "application/json" }, 
        consumes = { "multipart/form-data" },
        method = RequestMethod.POST)
    default ResponseEntity<Artifact> createArtifact(@ApiParam(value = "Artifact properties (JSON)", required=true) @RequestParam(value="artifactProps", required=true)  String artifactProps,@ApiParam(value = "Artifact payload data") @Valid @RequestPart(value="payload", required=true) MultipartFile payload,@ApiParam(value = "HTTP response status and headers (optional)") @RequestParam(value="httpResponseHeader", required=false)  String httpResponseHeader) {
        return getDelegate().createArtifact(artifactProps, payload, httpResponseHeader);
    }


    @ApiOperation(value = "Remove an artifact from the repository", nickname = "deleteArtifact", notes = "", tags={ "artifacts", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Successfully removed artifact"),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to delete artifact"),
        @ApiResponse(code = 404, message = "Artifact not found"),
        @ApiResponse(code = 409, message = "Cannot delete artifact") })
    @RequestMapping(value = "/artifacts/{uuid}",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> deleteArtifact(@ApiParam(value = "Identifier of the artifact",required=true) @PathVariable("uuid") String uuid,@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace) {
        return getDelegate().deleteArtifact(uuid, namespace);
    }


    @ApiOperation(value = "Get artifact and metadata", nickname = "getArtifactDataByMultipart", notes = "", response = Resource.class, tags={ "artifacts", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Multipart/form-data containing the following parts: The artifact properties, HTTP status and headers if present, and the artifact's payload if requested. See POST /artifacts for more information.", response = Resource.class),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to retrieve artifact"),
        @ApiResponse(code = 404, message = "Artifact not found"),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 502, message = "Could not read from external resource") })
    @RequestMapping(value = "/artifacts/{uuid}",
        produces = { "multipart/form-data", "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getArtifactDataByMultipart(@ApiParam(value = "Identifier of the artifact",required=true) @PathVariable("uuid") String uuid,@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace,@ApiParam(value = "Controls whether to include the artifact content part in multipart response", allowableValues = "NEVER, IF_SMALL, ALWAYS", defaultValue = "ALWAYS") @Valid @RequestParam(value = "includeContent", required = false, defaultValue="ALWAYS") String includeContent) {
        return getDelegate().getArtifactDataByMultipart(uuid, namespace, includeContent);
    }


    @ApiOperation(value = "Get artifact payload", nickname = "getArtifactDataByPayload", notes = "", response = Resource.class, tags={ "artifacts", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Artifact's payload", response = Resource.class),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to retrieve artifact"),
        @ApiResponse(code = 404, message = "Artifact not found"),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 502, message = "Could not read artifact") })
    @RequestMapping(value = "/artifacts/{uuid}/payload",
        produces = { "application/octet-stream" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getArtifactDataByPayload(@ApiParam(value = "Identifier of the artifact",required=true) @PathVariable("uuid") String uuid,@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace,@ApiParam(value = "Controls whether to include the artifact content part in multipart response", allowableValues = "NEVER, IF_SMALL, ALWAYS", defaultValue = "ALWAYS") @Valid @RequestParam(value = "includeContent", required = false, defaultValue="ALWAYS") String includeContent) {
        return getDelegate().getArtifactDataByPayload(uuid, namespace, includeContent);
    }


    @ApiOperation(value = "Get artifact data as HTTP response", nickname = "getArtifactDataByResponse", notes = "", response = Resource.class, tags={ "artifacts", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Artifact's payload", response = Resource.class),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to retrieve artifact"),
        @ApiResponse(code = 404, message = "Artifact not found"),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 502, message = "Could not read artifact") })
    @RequestMapping(value = "/artifacts/{uuid}/response",
        produces = { "application/http;msgtype=response" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getArtifactDataByResponse(@ApiParam(value = "Identifier of the artifact",required=true) @PathVariable("uuid") String uuid,@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace,@ApiParam(value = "Controls whether to include the artifact content part in multipart response", allowableValues = "NEVER, IF_SMALL, ALWAYS", defaultValue = "ALWAYS") @Valid @RequestParam(value = "includeContent", required = false, defaultValue="ALWAYS") String includeContent) {
        return getDelegate().getArtifactDataByResponse(uuid, namespace, includeContent);
    }


    @ApiOperation(value = "Returns all artifacts that match a given a URL or URL prefix and/or version.", nickname = "getArtifactsFromAllAus", notes = "", response = ArtifactPageInfo.class, tags={ "artifacts", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The requested artifacts", response = ArtifactPageInfo.class),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to retrieve data"),
        @ApiResponse(code = 404, message = "Collection not found"),
        @ApiResponse(code = 502, message = "Could not read from external resource") })
    @RequestMapping(value = "/artifacts",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<ArtifactPageInfo> getArtifactsFromAllAus(@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace,@ApiParam(value = "The URL contained by the artifacts") @Valid @RequestParam(value = "url", required = false) String url,@ApiParam(value = "The prefix to be matched by the artifact URLs") @Valid @RequestParam(value = "urlPrefix", required = false) String urlPrefix,@ApiParam(value = "Versions of the artifacts to return", allowableValues = "all, latest", defaultValue = "all") @Valid @RequestParam(value = "versions", required = false, defaultValue="all") String versions,@ApiParam(value = "The requested maximum number of artifacts per response") @Valid @RequestParam(value = "limit", required = false) Integer limit,@ApiParam(value = "The continuation token of the next page of artifacts to be returned") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken) {
        return getDelegate().getArtifactsFromAllAus(namespace, url, urlPrefix, versions, limit, continuationToken);
    }


    @ApiOperation(value = "Update the property of an artifact", nickname = "updateArtifact", notes = "", response = Artifact.class, tags={ "artifacts", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Artifact updated", response = Artifact.class),
        @ApiResponse(code = 400, message = "Invalid input"),
        @ApiResponse(code = 401, message = "Unauthorized request"),
        @ApiResponse(code = 403, message = "Client not authorized to update artifact"),
        @ApiResponse(code = 404, message = "Artifact not found") })
    @RequestMapping(value = "/artifacts/{uuid}",
        produces = { "application/json" }, 
        consumes = { "multipart/form-data" },
        method = RequestMethod.PUT)
    default ResponseEntity<Artifact> updateArtifact(@ApiParam(value = "Identifier of the artifact",required=true) @PathVariable("uuid") String uuid,@ApiParam(value = "New commit status of artifact", required=true) @RequestParam(value="committed", required=true)  Boolean committed,@ApiParam(value = "Namespace of the artifacts", defaultValue = "lockss") @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace) {
        return getDelegate().updateArtifact(uuid, committed, namespace);
    }

}
