/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.lockss.laaws.rs.api.ChecksumalgorithmsApiDelegate;
import org.lockss.laaws.rs.impl.ServiceImplUtil;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.StringUtil;
import org.lockss.util.rest.repo.LockssRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ChecksumalgorithmsApiServiceImpl
extends BaseSpringApiServiceImpl
implements ChecksumalgorithmsApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    @Autowired
    LockssRepository repo;
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;
    private List<String> supportedMessageDigestAlgorithms = null;

    @Autowired
    public ChecksumalgorithmsApiServiceImpl(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    public ResponseEntity<List<String>> getSupportedChecksumAlgorithms() {
        String parsedRequest = String.format("requestUrl: %s", ServiceImplUtil.getFullRequestUrl((HttpServletRequest)this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, (String)parsedRequest);
        try {
            List result = this.getSupportedMessageDigestAlgorithms();
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (Exception e) {
            String errorMessage = "Exception caught trying to enumerate supported checksum algorithms";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    public Optional<ObjectMapper> getObjectMapper() {
        return Optional.ofNullable(this.objectMapper);
    }

    private List<String> getSupportedMessageDigestAlgorithms() {
        if (this.supportedMessageDigestAlgorithms == null) {
            this.supportedMessageDigestAlgorithms = new ArrayList();
            for (Provider provider : Security.getProviders()) {
                log.trace("provider = {}", (Object)provider);
                for (Provider.Service service : provider.getServices()) {
                    log.trace("service = {}", (Object)service);
                    if (!"MessageDigest".equals(service.getType())) continue;
                    this.supportedMessageDigestAlgorithms.add(service.getAlgorithm());
                    log.trace("algorithm = {}", (Object)service.getAlgorithm());
                    String displayService = service.toString();
                    int beginIndex = displayService.indexOf("aliases: [") + "aliases: [".length();
                    if (beginIndex < "aliases: [".length()) continue;
                    int endIndex = displayService.indexOf("]", beginIndex);
                    String aliases = displayService.substring(beginIndex, endIndex);
                    for (String alias : StringUtil.breakAt((String)aliases, (String)",")) {
                        this.supportedMessageDigestAlgorithms.add(alias.trim());
                        log.trace("alias = {}", (Object)alias.trim());
                    }
                }
            }
            log.trace("supportedMessageDigestAlgorithms = {}", (Object)this.supportedMessageDigestAlgorithms);
        }
        return this.supportedMessageDigestAlgorithms;
    }
}

