/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.lockss.laaws.rs.api.RepoinfoApiDelegate;
import org.lockss.laaws.rs.impl.ServiceImplUtil;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.rest.repo.LockssRepository;
import org.lockss.util.rest.repo.model.RepositoryInfo;
import org.lockss.util.storage.StorageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class RepoinfoApiServiceImpl
extends BaseSpringApiServiceImpl
implements RepoinfoApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    @Autowired
    LockssRepository repo;
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;

    @Autowired
    public RepoinfoApiServiceImpl(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    public ResponseEntity<RepositoryInfo> getRepositoryInformation() {
        log.debug2("Invoked");
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, null);
        try {
            RepositoryInfo result = this.repo.getRepositoryInfo();
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (Exception e) {
            String errorMessage = "Exception caught trying to provide the repository information.";
            log.warn(errorMessage, (Throwable)e);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e);
        }
    }

    public ResponseEntity<StorageInfo> getStorageInfo() {
        log.debug2("Invoked");
        ServiceImplUtil.checkRepositoryReady((LockssRepository)this.repo, null);
        try {
            StorageInfo result = this.repo.getStorageInfo();
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (Exception e) {
            String errorMessage = "Exception caught trying to provide the repository storage information.";
            log.warn(errorMessage, (Throwable)e);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e);
        }
    }

    public Optional<ObjectMapper> getObjectMapper() {
        return Optional.ofNullable(this.objectMapper);
    }
}

