/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.impl;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;
import org.lockss.log.L4JLogger;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.rest.exception.LockssRestHttpException;
import org.lockss.util.rest.repo.LockssRepository;
import org.lockss.util.rest.repo.model.Artifact;
import org.springframework.http.HttpStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceImplUtil {
    private static L4JLogger log = L4JLogger.getLogger();
    private static String archiveFileExtension = ".warc";
    private static String archiveFileSeparator = ":";

    static String getFullRequestUrl(HttpServletRequest request) {
        if (request == null) {
            log.warn("request = null");
            return "";
        }
        if (request.getQueryString() == null || request.getQueryString().trim().isEmpty()) {
            return "'" + request.getMethod() + " " + request.getRequestURL() + "'";
        }
        return "'" + request.getMethod() + " " + request.getRequestURL() + "?" + request.getQueryString() + "'";
    }

    static void checkRepositoryReady(LockssRepository repo, String parsedRequest) {
        if (!repo.isReady()) {
            String errorMessage = "LOCKSS repository is not ready";
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.APPLICATION_ERROR, HttpStatus.SERVICE_UNAVAILABLE, errorMessage, parsedRequest);
        }
    }

    static void validatePagination(Integer count, Integer startPage, String parsedRequest) {
        log.debug2("count = {}", (Object)count);
        log.debug2("startPage = {}", (Object)startPage);
        log.debug2("parsedRequest = {}", (Object)parsedRequest);
        if (count == null && startPage == null) {
            log.debug2("Pagination request parameters are valid");
            return;
        }
        if (count != null && startPage != null && count > 0 && startPage > 0) {
            log.debug2("Pagination request parameters are valid");
            return;
        }
        String errorMessage = "Invalid pagination request: count = " + count + ", startPage = " + startPage;
        log.error(errorMessage);
        throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
    }

    static String getArtifactArchiveName(String namespace, String artifactUuid) {
        return namespace + archiveFileSeparator + artifactUuid + archiveFileExtension;
    }

    static String getArchiveFilenameNamespace(String fileName, String parsedRequest) {
        int separatorLocation = ServiceImplUtil.getArchiveFilenameSeparator((String)fileName, (String)parsedRequest);
        return fileName.substring(0, separatorLocation);
    }

    static String getArchiveFilenameArtifactId(String fileName, String parsedRequest) {
        int separatorLocation = ServiceImplUtil.getArchiveFilenameSeparator((String)fileName, (String)parsedRequest);
        return fileName.substring(separatorLocation + archiveFileSeparator.length(), fileName.length() - archiveFileExtension.length());
    }

    private static int getArchiveFilenameSeparator(String fileName, String parsedRequest) {
        int separatorLocation = fileName.lastIndexOf(archiveFileSeparator);
        log.trace("separatorLocation = {}", (Object)separatorLocation);
        if (separatorLocation < 1) {
            String errorMessage = "Missing separator '" + archiveFileSeparator + "' in filename: " + fileName;
            log.error(errorMessage);
            throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
        }
        return separatorLocation;
    }

    static String toJsonError(int code, String message) {
        JSONObject errorElement = new JSONObject();
        errorElement.put("code", code);
        if (message == null) {
            message = "";
        }
        errorElement.put("message", (Object)message);
        JSONObject responseBody = new JSONObject();
        responseBody.put("error", (Object)errorElement);
        return responseBody.toString();
    }

    static int validateLimit(Integer requestLimit, int defaultValue, int maxValue, String parsedRequest) {
        log.debug2("requestLimit = {}, defaultValue = {}, maxValue = {}", (Object)requestLimit, (Object)defaultValue, (Object)maxValue);
        if (requestLimit != null && requestLimit <= 0) {
            String message = "Limit of requested items must be a positive integer; it was '" + requestLimit + "'";
            log.warn(message);
            throw new LockssRestServiceException(LockssRestHttpException.ServerErrorType.NONE, HttpStatus.BAD_REQUEST, message, parsedRequest);
        }
        int result = requestLimit == null ? Math.min(defaultValue, maxValue) : Math.min(requestLimit, maxValue);
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public static void populateArtifacts(Iterator<Artifact> iterator, Integer limit, List<Artifact> artifacts) {
        log.debug2("limit = {}, artifacts = {}", (Object)limit, artifacts);
        for (int artifactCount = artifacts.size(); artifactCount < limit && iterator.hasNext(); ++artifactCount) {
            artifacts.add(iterator.next());
        }
    }
}

