/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.model;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.lockss.log.L4JLogger;

/*
 * Exception performing whole class analysis ignored.
 */
public class CdxRecord {
    private static L4JLogger log = L4JLogger.getLogger();
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private String urlSortKey;
    private long timestamp;
    private String url;
    private String mimeType;
    private int httpStatus;
    private String digest;
    private String redirectUrl = "-";
    private String robotFlags = "-";
    private long length;
    private long offset;
    private String archiveName;

    public String getUrlSortKey() {
        return this.urlSortKey;
    }

    public void setUrlSortKey(String urlSortKey) {
        this.urlSortKey = urlSortKey;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String getRobotFlags() {
        return this.robotFlags;
    }

    public void setRobotFlags(String robotFlags) {
        this.robotFlags = robotFlags;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public String toIaText() {
        log.debug2("Invoked.");
        StringBuilder out = new StringBuilder();
        out.append(this.urlSortKey).append(' ');
        out.append(this.timestamp).append(' ');
        out.append(this.url).append(' ');
        out.append(this.mimeType).append(' ');
        out.append(this.httpStatus).append(' ');
        out.append(this.digest).append(' ');
        out.append(this.redirectUrl).append(' ');
        out.append(this.robotFlags).append(' ');
        out.append(this.length).append(' ');
        out.append(this.offset).append(' ');
        out.append(this.archiveName).append("\n");
        String result = out.toString();
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public void toXmlText(XMLStreamWriter writer) throws XMLStreamException {
        log.debug2("Invoked.");
        try {
            writer.writeStartElement("result");
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"compressedoffset", (Object)this.offset);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"compressedendoffset", (Object)this.length);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"mimetype", (Object)this.mimeType);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"file", (Object)this.archiveName);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"redirecturl", (Object)this.redirectUrl);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"urlkey", (Object)this.urlSortKey);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"digest", (Object)this.digest);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"httpresponsecode", (Object)this.httpStatus);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"robotflags", (Object)this.robotFlags);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"url", (Object)this.url);
            CdxRecord.writeXmlElement((XMLStreamWriter)writer, (String)"capturedate", (Object)this.timestamp);
            writer.writeEndElement();
        }
        catch (XMLStreamException xse) {
            log.error("Exception caught writing XML", (Throwable)xse);
            throw xse;
        }
        log.debug2("Done.");
    }

    static void writeXmlElement(XMLStreamWriter writer, String name, Object value) throws XMLStreamException {
        log.debug2("name = {}", (Object)name);
        if (value == null) {
            log.debug2("value = {} (not writing)", value);
            return;
        }
        log.debug2("value = {}", value);
        try {
            writer.writeStartElement(name);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
        catch (XMLStreamException xse) {
            log.error("Exception caught writing XML for element: name = {}, value = {}", (Object)name, value, (Object)xse);
            throw xse;
        }
        log.debug2("Done.");
    }

    public String toJson() {
        log.debug2("Invoked.");
        StringBuilder out = new StringBuilder();
        out.append(this.urlSortKey).append(' ');
        out.append(this.timestamp).append(' ');
        out.append("{");
        out.append("\"url\": \"").append(this.url).append("\", ");
        out.append("\"mime\": \"").append(this.mimeType).append("\", ");
        out.append("\"status\": \"").append(this.httpStatus).append("\", ");
        out.append("\"digest\": \"").append(this.digest).append("\", ");
        out.append("\"length\": \"").append(this.length).append("\", ");
        out.append("\"offset\": \"").append(this.offset).append("\", ");
        out.append("\"filename\": \"").append(this.archiveName).append("\"");
        out.append("}\n");
        String result = out.toString();
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public static long computeCollectiondate(String timestamp) {
        return LocalDateTime.parse(timestamp, dateTimeFormatter).toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static String computeTextTimestamp(long collectionDate) {
        return dateTimeFormatter.format(LocalDateTime.ofEpochSecond(collectionDate / 1000L, 0, ZoneOffset.UTC));
    }

    public static long computeNumericTimestamp(long collectionDate) {
        return Long.parseLong(CdxRecord.computeTextTimestamp((long)collectionDate));
    }

    public String toString() {
        return "[CdxRecord urlSortKey=" + this.urlSortKey + ", timestamp=" + this.timestamp + ", url=" + this.url + ", mimeType=" + this.mimeType + ", httpStatus=" + this.httpStatus + ", digest=" + this.digest + ", redirectUrl=" + this.redirectUrl + ", robotFlags=" + this.robotFlags + ", length=" + this.length + ", offset=" + this.offset + ", archiveName=" + this.archiveName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdxRecord cdxRecord = (CdxRecord)o;
        return Objects.equals(this.urlSortKey, cdxRecord.urlSortKey) && Objects.equals(this.timestamp, cdxRecord.timestamp) && Objects.equals(this.url, cdxRecord.url) && Objects.equals(this.mimeType, cdxRecord.mimeType) && Objects.equals(this.httpStatus, cdxRecord.httpStatus) && Objects.equals(this.digest, cdxRecord.digest) && Objects.equals(this.redirectUrl, cdxRecord.redirectUrl) && Objects.equals(this.robotFlags, cdxRecord.robotFlags) && Objects.equals(this.length, cdxRecord.length) && Objects.equals(this.offset, cdxRecord.offset) && Objects.equals(this.archiveName, cdxRecord.archiveName);
    }

    public int hashCode() {
        return Objects.hash(this.urlSortKey, this.timestamp, this.url, this.mimeType, this.httpStatus, this.digest, this.redirectUrl, this.robotFlags, this.length, this.offset, this.archiveName);
    }
}

