/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.multipart;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.lang3.StringUtils;
import org.lockss.laaws.rs.multipart.HttpBodyDigestOutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class DigestFileItem
extends DiskFileItem {
    HttpBodyDigestOutputStream output;
    private transient File tempFile;
    private final File repository;
    private static final String UID = UUID.randomUUID().toString().replace('-', '_');
    private static final AtomicInteger COUNTER = new AtomicInteger(0);

    public DigestFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
        super(fieldName, contentType, isFormField, fileName, sizeThreshold, repository);
        this.repository = repository;
    }

    public OutputStream getOutputStream() throws IOException {
        this.output = new HttpBodyDigestOutputStream(super.getOutputStream());
        if (this.getFieldName().equals("payload")) {
            this.output.switchToDigest();
        }
        return this.output;
    }

    public String getContentType() {
        String contentType = this.getHeaders().getHeader("X-Lockss-Content-Type");
        return StringUtils.isEmpty((CharSequence)contentType) ? super.getContentType() : contentType;
    }

    public MessageDigest getDigest() {
        return this.output.getDigest();
    }

    protected File getTempFile() {
        if (this.tempFile == null) {
            File tempDir = this.repository;
            if (tempDir == null) {
                tempDir = new File(System.getProperty("java.io.tmpdir"));
            }
            String tempFileName = String.format("upload_%s_%s.tmp", UID, DigestFileItem.getUniqueId());
            this.tempFile = new File(tempDir, tempFileName);
        }
        return this.tempFile;
    }

    private static String getUniqueId() {
        int limit = 100000000;
        int current = COUNTER.getAndIncrement();
        String id = Integer.toString(current);
        if (current < 100000000) {
            id = ("00000000" + id).substring(id.length());
        }
        return id;
    }
}

