/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.configuration;

import java.util.List;
import org.lockss.config.ConfigManager;
import org.lockss.config.Configuration;
import org.lockss.laaws.rs.configuration.RepositoryServiceProperties;
import org.lockss.log.L4JLogger;
import org.lockss.rs.io.index.ArtifactIndex;
import org.lockss.rs.io.storage.ArtifactDataStore;
import org.lockss.rs.io.storage.warc.LocalWarcArtifactDataStore;
import org.lockss.rs.io.storage.warc.TestingWarcArtifactDataStore;
import org.lockss.rs.io.storage.warc.VolatileWarcArtifactDataStore;
import org.lockss.rs.io.storage.warc.WarcArtifactDataStore;
import org.lockss.util.PatternIntMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class ArtifactDataStoreConfig {
    private static final L4JLogger log = L4JLogger.getLogger();
    public static final String PARAM_FREE_SPACE_MAP = "org.lockss.repo.testing.freeSpaceMap";
    public static final String PARAM_REPO_USE_WARC_COMPRESSION = "org.lockss.repo.warc.useCompression";
    public static final boolean DEFAULT_REPO_USE_WARC_COMPRESSION = true;
    private RepositoryServiceProperties repoProps;
    ArtifactIndex index;
    volatile WarcArtifactDataStore ds;

    @Autowired
    public ArtifactDataStoreConfig(RepositoryServiceProperties repoProps, ArtifactIndex index) {
        this.repoProps = repoProps;
        this.index = index;
    }

    @Bean
    public ArtifactDataStore setArtifactDataStore() throws Exception {
        this.ds = this.createWarcArtifactDataStore(this.parseDataStoreSpecs());
        return this.ds;
    }

    private String parseDataStoreSpecs() {
        switch (this.repoProps.getRepositoryType()) {
            case "volatile": {
                return "volatile";
            }
            case "local": {
                return "local";
            }
            case "custom": {
                return this.repoProps.getDatastoreSpec();
            }
        }
        throw new IllegalArgumentException("Repository spec not supported: " + this.repoProps.getRepositorySpec());
    }

    private WarcArtifactDataStore createWarcArtifactDataStore(String dsType) throws Exception {
        switch (dsType) {
            case "volatile": {
                log.info("Configuring volatile artifact data store");
                return new VolatileWarcArtifactDataStore();
            }
            case "local": 
            case "testing": {
                switch (dsType) {
                    case "local": {
                        log.info("Configuring local artifact data store [baseDirs: {}]", (Object[])this.repoProps.getLocalBaseDirs());
                        return new LocalWarcArtifactDataStore(this.repoProps.getLocalBaseDirs());
                    }
                    case "testing": {
                        log.info("Configuring testing artifact data store [baseDirs: {}]", (Object[])this.repoProps.getLocalBaseDirs());
                        return new TestingWarcArtifactDataStore(this.repoProps.getLocalBaseDirs());
                    }
                }
                throw new RuntimeException("Shouldn't happen");
            }
        }
        log.error("Unknown artifact data store: '{}'", (Object)dsType);
        throw new IllegalArgumentException("Unknown artifact data store");
    }

    @EventListener
    public void configMgrCreated(ConfigManager.ConfigManagerCreatedEvent event) {
        log.debug2("ConfigManagerCreatedEvent triggered");
        ConfigManager.getConfigManager().registerConfigurationCallback((Configuration.Callback)new ArtifactDataStoreConfigCallback(this.ds));
    }

    private static class ArtifactDataStoreConfigCallback
    implements Configuration.Callback {
        TestingWarcArtifactDataStore twads;
        WarcArtifactDataStore wads;

        ArtifactDataStoreConfigCallback(WarcArtifactDataStore ds) {
            if (ds instanceof TestingWarcArtifactDataStore) {
                this.twads = (TestingWarcArtifactDataStore)ds;
            }
            this.wads = ds;
        }

        public void configurationChanged(org.lockss.config.Configuration newConfig, org.lockss.config.Configuration oldConfig, Configuration.Differences changedKeys) {
            if (this.twads != null) {
                PatternIntMap freeSpacePatternMap = PatternIntMap.EMPTY;
                List lst = newConfig.getList(ArtifactDataStoreConfig.PARAM_FREE_SPACE_MAP, null);
                if (lst != null && !lst.isEmpty()) {
                    try {
                        freeSpacePatternMap = new PatternIntMap(lst);
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Illegal testing disk space map, ignoring", (Throwable)e);
                    }
                }
                this.twads.setTestingDiskSpaceMap(freeSpacePatternMap);
            }
            if (this.wads != null) {
                boolean useWarcCompression = newConfig.getBoolean(ArtifactDataStoreConfig.PARAM_REPO_USE_WARC_COMPRESSION, true);
                this.wads.setUseWarcCompression(useWarcCompression);
            } else {
                log.warn("configurationChanged() called before ConfigManager started.  Okey while running unit tests, should not happen during real startup");
            }
        }
    }
}

