/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.model;

import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.lockss.laaws.rs.model.CdxRecord;
import org.lockss.log.L4JLogger;

public class CdxRecords {
    private static L4JLogger log = L4JLogger.getLogger();
    private List<CdxRecord> cdxRecords = new ArrayList<CdxRecord>();
    private Map<String, String> openWayBackQuery = null;
    private String charsetName = null;

    public CdxRecords() {
    }

    public CdxRecords(Map<String, String> openWayBackQuery, String charsetName) {
        this.openWayBackQuery = openWayBackQuery;
        this.charsetName = charsetName;
    }

    public void addCdxRecord(CdxRecord cdxRecord) {
        this.cdxRecords.add(cdxRecord);
    }

    public int getCdxRecordCount() {
        return this.cdxRecords.size();
    }

    public String toIaText() {
        log.debug2("Invoked.");
        StringBuilder out = new StringBuilder();
        for (CdxRecord cdxRecord : this.cdxRecords) {
            out.append(cdxRecord.toIaText()).append("\n");
        }
        String result = out.toString();
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public String toXmlText() throws XMLStreamException {
        StringWriter sw = new StringWriter();
        try {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
            writer.writeStartDocument(this.charsetName, "1.0");
            writer.writeStartElement("wayback");
            writer.writeStartElement("request");
            CdxRecord.writeXmlElement(writer, "startdate", "19960101000000");
            CdxRecord.writeXmlElement(writer, "enddate", DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now(ZoneOffset.UTC)));
            CdxRecord.writeXmlElement(writer, "type", this.openWayBackQuery.getOrDefault("type", "urlquery").toLowerCase());
            CdxRecord.writeXmlElement(writer, "firstreturned", Long.parseLong(this.openWayBackQuery.getOrDefault("offset", "0")));
            CdxRecord.writeXmlElement(writer, "url", this.openWayBackQuery.get("canonicalUrl"));
            CdxRecord.writeXmlElement(writer, "resultsrequested", Long.parseLong(this.openWayBackQuery.getOrDefault("limit", "10000")));
            CdxRecord.writeXmlElement(writer, "resultstype", "resultstypecapture");
            writer.writeEndElement();
            writer.writeStartElement("results");
            for (CdxRecord cdxRecord : this.cdxRecords) {
                cdxRecord.toXmlText(writer);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            sw.flush();
            writer.close();
            String result = sw.toString();
            log.debug2("result = {}", (Object)result);
            String string = result;
            return string;
        }
        catch (XMLStreamException xse) {
            log.error("Exception caught writing XML", (Throwable)xse);
            throw xse;
        }
        finally {
            try {
                sw.close();
            }
            catch (Exception exception) {}
        }
    }

    public String toJson() {
        log.debug2("Invoked.");
        StringBuilder out = new StringBuilder();
        for (CdxRecord cdxRecord : this.cdxRecords) {
            out.append(cdxRecord.toJson()).append("\n");
        }
        String result = out.toString();
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public List<CdxRecord> getCdxRecords() {
        return this.cdxRecords;
    }
}

