/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.rs.api;

import org.springframework.core.io.Resource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface ArchivesApi {

    ArchivesApiDelegate getDelegate();

    @Operation(summary = "Imports artifacts from an archive", description = "", tags={ "artifacts" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Status of artifacts imported from the archive, maybe partially. Return body is a sequence of JSON ImportStatus objects.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Resource.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/archives",
        produces = { "application/json" }, 
        consumes = { "multipart/form-data" }, 
        method = RequestMethod.POST)
    default ResponseEntity<Resource> addArtifacts(@Parameter(in = ParameterIn.DEFAULT, description = "", required=true,schema=@Schema()) @RequestPart(value="auid", required=true)  String auid
, @Parameter(description = "") @Valid @RequestPart(value="archive", required=true) MultipartFile archive
, @Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
, @Parameter(in = ParameterIn.QUERY, description = "If true, artifacts with duplicate content will be stored, otherwise suppressed" ,schema=@Schema( defaultValue="false")) @Valid @RequestParam(value = "storeDuplicate", required = false, defaultValue="false") Boolean storeDuplicate
, @Parameter(in = ParameterIn.QUERY, description = "If supplied, WARC records whose HTTP response status code matches the regular expression will not be imported" ,schema=@Schema()) @Valid @RequestParam(value = "excludeStatusPattern", required = false) String excludeStatusPattern
) {
        return getDelegate().addArtifacts(auid, archive, namespace, storeDuplicate, excludeStatusPattern);
    }

}

