/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.rs.api;

import org.lockss.util.rest.repo.model.Artifact;
import org.lockss.util.rest.repo.model.ArtifactPageInfo;
import org.springframework.core.io.Resource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface ArtifactsApi {

    ArtifactsApiDelegate getDelegate();

    @Operation(summary = "Create an artifact", description = "", tags={ "artifacts" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "201", description = "Artifact created", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Artifact.class))),
        
        @ApiResponse(responseCode = "302", description = "Duplicate content; artifact not created"),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/artifacts",
        produces = { "application/json" }, 
        consumes = { "multipart/form-data" }, 
        method = RequestMethod.POST)
    default ResponseEntity<Artifact> createArtifact(@Parameter(in = ParameterIn.DEFAULT, description = "",schema=@Schema()) @RequestPart(value="artifactProps", required=false)  String artifactProps
, @Parameter(description = "") @Valid @RequestPart(value="payload", required=false) MultipartFile payload
, @Parameter(in = ParameterIn.DEFAULT, description = "",schema=@Schema()) @RequestPart(value="httpResponseHeader", required=false)  String httpResponseHeader
) {
        return getDelegate().createArtifact(artifactProps, payload, httpResponseHeader);
    }


    @Operation(summary = "Remove an artifact from the repository", description = "", tags={ "artifacts" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Successfully removed artifact"),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/artifacts/{uuid}",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> deleteArtifact(@Parameter(in = ParameterIn.PATH, description = "Identifier of the artifact", required=true, schema=@Schema()) @PathVariable("uuid") String uuid
, @Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
) {
        return getDelegate().deleteArtifact(uuid, namespace);
    }


    @Operation(summary = "Get artifact and metadata", description = "", tags={ "artifacts" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Multipart/form-data containing the following parts: The artifact properties, HTTP status and headers if present, and the artifact's payload if requested. See POST /artifacts for more information.", content = @Content(mediaType = "multipart/form-data", schema = @Schema(implementation = Resource.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/artifacts/{uuid}",
        produces = { "multipart/form-data", "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getArtifactDataByMultipart(@Parameter(in = ParameterIn.PATH, description = "Identifier of the artifact", required=true, schema=@Schema()) @PathVariable("uuid") String uuid
, @Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
, @Parameter(in = ParameterIn.QUERY, description = "Controls whether to include the artifact content part in multipart response" ,schema=@Schema(allowableValues={ "NEVER", "IF_SMALL", "ALWAYS" }
, defaultValue="ALWAYS")) @Valid @RequestParam(value = "includeContent", required = false, defaultValue="ALWAYS") String includeContent
) {
        return getDelegate().getArtifactDataByMultipart(uuid, namespace, includeContent);
    }


    @Operation(summary = "Get artifact payload", description = "", tags={ "artifacts" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Artifact's payload", content = @Content(mediaType = "application/octet-stream", schema = @Schema(implementation = Resource.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/artifacts/{uuid}/payload",
        produces = { "application/octet-stream", "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getArtifactDataByPayload(@Parameter(in = ParameterIn.PATH, description = "Identifier of the artifact", required=true, schema=@Schema()) @PathVariable("uuid") String uuid
, @Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
, @Parameter(in = ParameterIn.QUERY, description = "Controls whether to include the artifact content part in multipart response" ,schema=@Schema(allowableValues={ "NEVER", "IF_SMALL", "ALWAYS" }
, defaultValue="ALWAYS")) @Valid @RequestParam(value = "includeContent", required = false, defaultValue="ALWAYS") String includeContent
) {
        return getDelegate().getArtifactDataByPayload(uuid, namespace, includeContent);
    }


    @Operation(summary = "Get artifact data as HTTP response", description = "", tags={ "artifacts" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Artifact's payload", content = @Content(mediaType = "application/http;msgtype&#x3D;response", schema = @Schema(implementation = Resource.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/artifacts/{uuid}/response",
        produces = { "application/http;msgtype=response", "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getArtifactDataByResponse(@Parameter(in = ParameterIn.PATH, description = "Identifier of the artifact", required=true, schema=@Schema()) @PathVariable("uuid") String uuid
, @Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
, @Parameter(in = ParameterIn.QUERY, description = "Controls whether to include the artifact content part in multipart response" ,schema=@Schema(allowableValues={ "NEVER", "IF_SMALL", "ALWAYS" }
, defaultValue="ALWAYS")) @Valid @RequestParam(value = "includeContent", required = false, defaultValue="ALWAYS") String includeContent
) {
        return getDelegate().getArtifactDataByResponse(uuid, namespace, includeContent);
    }


    @Operation(summary = "Returns all artifacts that match a given a URL or URL prefix and/or version.", description = "", tags={ "artifacts" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The requested artifacts", content = @Content(mediaType = "application/json", schema = @Schema(implementation = ArtifactPageInfo.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/artifacts",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<ArtifactPageInfo> getArtifactsFromAllAus(@Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
, @Parameter(in = ParameterIn.QUERY, description = "The URL contained by the artifacts" ,schema=@Schema()) @Valid @RequestParam(value = "url", required = false) String url
, @Parameter(in = ParameterIn.QUERY, description = "The prefix to be matched by the artifact URLs" ,schema=@Schema()) @Valid @RequestParam(value = "urlPrefix", required = false) String urlPrefix
, @Parameter(in = ParameterIn.QUERY, description = "Versions of the artifacts to return" ,schema=@Schema(allowableValues={ "all", "latest" }
, defaultValue="all")) @Valid @RequestParam(value = "versions", required = false, defaultValue="all") String versions
, @Parameter(in = ParameterIn.QUERY, description = "The requested maximum number of artifacts per response" ,schema=@Schema()) @Valid @RequestParam(value = "limit", required = false) Integer limit
, @Parameter(in = ParameterIn.QUERY, description = "The continuation token of the next page of artifacts to be returned" ,schema=@Schema()) @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken
) {
        return getDelegate().getArtifactsFromAllAus(namespace, url, urlPrefix, versions, limit, continuationToken);
    }


    @Operation(summary = "Update the property of an artifact", description = "", tags={ "artifacts" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Artifact updated", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Artifact.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/artifacts/{uuid}",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
    default ResponseEntity<Artifact> updateArtifact(@NotNull @Parameter(in = ParameterIn.QUERY, description = "Committed status of the artifact" ,required=true,schema=@Schema()) @Valid @RequestParam(value = "committed", required = true) Boolean committed
, @Parameter(in = ParameterIn.PATH, description = "Identifier of the artifact", required=true, schema=@Schema()) @PathVariable("uuid") String uuid
, @Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
) {
        return getDelegate().updateArtifact(committed, uuid, namespace);
    }

}

