package org.lockss.laaws.rs.api;

import org.lockss.util.rest.repo.model.Artifact;
import org.lockss.util.rest.repo.model.ArtifactPageInfo;
import org.springframework.core.io.Resource;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import java.io.IOException;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link ArtifactsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */

public interface ArtifactsApiDelegate {

    Logger log = LoggerFactory.getLogger(ArtifactsApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    /**
     * @see ArtifactsApi#createArtifact
     */
    default ResponseEntity<Artifact> createArtifact( String  artifactProps,
        MultipartFile payload,
         String  httpResponseHeader) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"committed\" : true,\n  \"auid\" : \"auid\",\n  \"namespace\" : \"lockss\",\n  \"contentLength\" : 6,\n  \"storageUrl\" : \"storageUrl\",\n  \"uuid\" : \"uuid\",\n  \"uri\" : \"uri\",\n  \"version\" : 0,\n  \"collectionDate\" : 1,\n  \"contentDigest\" : \"contentDigest\"\n}", Artifact.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ArtifactsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see ArtifactsApi#deleteArtifact
     */
    default ResponseEntity<Void> deleteArtifact( String  uuid,
         String  namespace) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ArtifactsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see ArtifactsApi#getArtifactDataByMultipart
     */
    default ResponseEntity<Resource> getArtifactDataByMultipart( String  uuid,
         String  namespace,
         String  includeContent) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("\"\"", Resource.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ArtifactsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see ArtifactsApi#getArtifactDataByPayload
     */
    default ResponseEntity<Resource> getArtifactDataByPayload( String  uuid,
         String  namespace,
         String  includeContent) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("\"\"", Resource.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ArtifactsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see ArtifactsApi#getArtifactDataByResponse
     */
    default ResponseEntity<Resource> getArtifactDataByResponse( String  uuid,
         String  namespace,
         String  includeContent) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("\"\"", Resource.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ArtifactsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see ArtifactsApi#getArtifactsFromAllAus
     */
    default ResponseEntity<ArtifactPageInfo> getArtifactsFromAllAus( String  namespace,
         String  url,
         String  urlPrefix,
         String  versions,
         Integer  limit,
         String  continuationToken) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 5,\n    \"totalCount\" : 5,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  },\n  \"artifacts\" : [ {\n    \"committed\" : true,\n    \"auid\" : \"auid\",\n    \"namespace\" : \"lockss\",\n    \"contentLength\" : 6,\n    \"storageUrl\" : \"storageUrl\",\n    \"uuid\" : \"uuid\",\n    \"uri\" : \"uri\",\n    \"version\" : 0,\n    \"collectionDate\" : 1,\n    \"contentDigest\" : \"contentDigest\"\n  }, {\n    \"committed\" : true,\n    \"auid\" : \"auid\",\n    \"namespace\" : \"lockss\",\n    \"contentLength\" : 6,\n    \"storageUrl\" : \"storageUrl\",\n    \"uuid\" : \"uuid\",\n    \"uri\" : \"uri\",\n    \"version\" : 0,\n    \"collectionDate\" : 1,\n    \"contentDigest\" : \"contentDigest\"\n  } ]\n}", ArtifactPageInfo.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ArtifactsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see ArtifactsApi#updateArtifact
     */
    default ResponseEntity<Artifact> updateArtifact( Boolean  committed,
         String  uuid,
         String  namespace) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"committed\" : true,\n  \"auid\" : \"auid\",\n  \"namespace\" : \"lockss\",\n  \"contentLength\" : 6,\n  \"storageUrl\" : \"storageUrl\",\n  \"uuid\" : \"uuid\",\n  \"uri\" : \"uri\",\n  \"version\" : 0,\n  \"collectionDate\" : 1,\n  \"contentDigest\" : \"contentDigest\"\n}", Artifact.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ArtifactsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
