/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.rs.api;

import org.lockss.util.rest.repo.model.ArtifactPageInfo;
import org.lockss.util.rest.repo.model.AuSize;
import org.lockss.util.rest.repo.model.AuidPageInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface AusApi {

    AusApiDelegate getDelegate();

    @Operation(summary = "Get artifacts in an Archival Unit", description = "Get a list of all artifacts in a namespace and Archival Unit or a pageful of the list defined by the continuation token and size", tags={ "artifacts" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The requested artifacts", content = @Content(mediaType = "application/json", schema = @Schema(implementation = ArtifactPageInfo.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/aus/{auid}/artifacts",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<ArtifactPageInfo> getArtifacts(@Parameter(in = ParameterIn.PATH, description = "Identifier of the Archival Unit containing the artifacts", required=true, schema=@Schema()) @PathVariable("auid") String auid
, @Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
, @Parameter(in = ParameterIn.QUERY, description = "The URL contained by the artifacts" ,schema=@Schema()) @Valid @RequestParam(value = "url", required = false) String url
, @Parameter(in = ParameterIn.QUERY, description = "The prefix to be matched by the artifact URLs" ,schema=@Schema()) @Valid @RequestParam(value = "urlPrefix", required = false) String urlPrefix
, @Parameter(in = ParameterIn.QUERY, description = "The version of the artifact" ,schema=@Schema()) @Valid @RequestParam(value = "version", required = false) String version
, @Parameter(in = ParameterIn.QUERY, description = "Indication of whether uncommitted artifacts should be returned" ,schema=@Schema()) @Valid @RequestParam(value = "includeUncommitted", required = false) Boolean includeUncommitted
, @Parameter(in = ParameterIn.QUERY, description = "The requested maximum number of artifacts per response" ,schema=@Schema()) @Valid @RequestParam(value = "limit", required = false) Integer limit
, @Parameter(in = ParameterIn.QUERY, description = "The continuation token of the next page of artifacts to be returned" ,schema=@Schema()) @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken
) {
        return getDelegate().getArtifacts(auid, namespace, url, urlPrefix, version, includeUncommitted, limit, continuationToken);
    }


    @Operation(summary = "Get the size of Archival Unit artifacts in a namespace", description = "", tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Returns an AuSize containing the sizes of all the artifacts, only the latest artifact version of all URLs, and the sum of the size of all the underlying WARC files, of an AU.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = AuSize.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/aus/{auid}/size",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<AuSize> getArtifactsSize(@Parameter(in = ParameterIn.PATH, description = "Identifier of the Archival Unit containing the artifacts", required=true, schema=@Schema()) @PathVariable("auid") String auid
, @Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
) {
        return getDelegate().getArtifactsSize(auid, namespace);
    }


    @Operation(summary = "Get Archival Unit IDs (AUIDs) in a namespace", description = "Get a list of all Archival Unit identifiers in a namespace or a pageful of the list defined by the continuation token and size", tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The requested Archival Unit identifiers", content = @Content(mediaType = "application/json", schema = @Schema(implementation = AuidPageInfo.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/aus",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<AuidPageInfo> getAus(@Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
, @Parameter(in = ParameterIn.QUERY, description = "The requested maximum number of Archival Unit identifiers per response" ,schema=@Schema()) @Valid @RequestParam(value = "limit", required = false) Integer limit
, @Parameter(in = ParameterIn.QUERY, description = "The continuation token of the next page of Archival Unit identifiers to be returned" ,schema=@Schema()) @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken
) {
        return getDelegate().getAus(namespace, limit, continuationToken);
    }


    @Operation(summary = "Marks the AUID for bulk artifact transfer", description = "", tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Bulk operation succeeded"),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/aus/{auid}/bulk",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    default ResponseEntity<Void> handleBulkAuOp(@Parameter(in = ParameterIn.PATH, description = "Archival Unit ID", required=true, schema=@Schema()) @PathVariable("auid") String auid
, @NotNull @Parameter(in = ParameterIn.QUERY, description = "" ,required=true,schema=@Schema(allowableValues={ "start", "finish" }
)) @Valid @RequestParam(value = "op", required = true) String op
, @Parameter(in = ParameterIn.QUERY, description = "Namespace of the artifacts" ,schema=@Schema( defaultValue="lockss")) @Valid @RequestParam(value = "namespace", required = false, defaultValue="lockss") String namespace
) {
        return getDelegate().handleBulkAuOp(auid, op, namespace);
    }

}

