/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.rs.api;

import org.springframework.core.io.Resource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface WaybackApi {

    WaybackApiDelegate getDelegate();

    @Operation(summary = "Get OpenWayback CDX records", description = "Get the OpenWayback CDX records of a URL in a namespace", tags={ "wayback" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The OpenWayback CDX records of the URL in the namespace", content = @Content(mediaType = "application/xml", schema = @Schema(implementation = String.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/wayback/cdx/owb/{namespace}",
        produces = { "application/xml", "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<String> getCdxOwb(@Parameter(in = ParameterIn.PATH, description = "Namespace of the artifacts", required=true, schema=@Schema()) @PathVariable("namespace") String namespace
, @Parameter(in = ParameterIn.QUERY, description = "Query string. Supported fields are url, type (urlqueryprefixquery), offset and limit." ,schema=@Schema()) @Valid @RequestParam(value = "q", required = false) String q
, @Parameter(in = ParameterIn.QUERY, description = "." ,schema=@Schema()) @Valid @RequestParam(value = "count", required = false) Integer count
, @Parameter(in = ParameterIn.QUERY, description = "." ,schema=@Schema()) @Valid @RequestParam(value = "start_page", required = false) Integer startPage
, @Parameter(in = ParameterIn.HEADER, description = "The Accept header" ,schema=@Schema()) @RequestHeader(value="Accept", required=false) String accept
, @Parameter(in = ParameterIn.HEADER, description = "The Accept-Encoding header" ,schema=@Schema()) @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding
) {
        return getDelegate().getCdxOwb(namespace, q, count, startPage, accept, acceptEncoding);
    }


    @Operation(summary = "Get PyWayback CDX records", description = "Get the PyWayback CDX records of a URL in a namespace", tags={ "wayback" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The PyWayback CDX records of the URL in the namespace", content = @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/wayback/cdx/pywb/{namespace}",
        produces = { "text/plain", "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<String> getCdxPywb(@Parameter(in = ParameterIn.PATH, description = "Namespace of the artifacts", required=true, schema=@Schema()) @PathVariable("namespace") String namespace
, @Parameter(in = ParameterIn.QUERY, description = "The URL for which the CDX records are requested" ,schema=@Schema()) @Valid @RequestParam(value = "url", required = false) String url
, @Parameter(in = ParameterIn.QUERY, description = "." ,schema=@Schema()) @Valid @RequestParam(value = "limit", required = false) Integer limit
, @Parameter(in = ParameterIn.QUERY, description = "" ,schema=@Schema(allowableValues={ "exact", "prefix", "host", "domain", "range" }
)) @Valid @RequestParam(value = "matchType", required = false) String matchType
, @Parameter(in = ParameterIn.QUERY, description = "" ,schema=@Schema(allowableValues={ "default", "closest", "reverse" }
)) @Valid @RequestParam(value = "sort", required = false) String sort
, @Parameter(in = ParameterIn.QUERY, description = "Timestamp for sort=closest mode" ,schema=@Schema()) @Valid @RequestParam(value = "closest", required = false) String closest
, @Parameter(in = ParameterIn.QUERY, description = "Output format" ,schema=@Schema(allowableValues={ "cdx", "json" }
)) @Valid @RequestParam(value = "output", required = false) String output
, @Parameter(in = ParameterIn.QUERY, description = "Comma-separated list of fields to include in output" ,schema=@Schema()) @Valid @RequestParam(value = "fl", required = false) String fl
, @Parameter(in = ParameterIn.HEADER, description = "The Accept header" ,schema=@Schema()) @RequestHeader(value="Accept", required=false) String accept
, @Parameter(in = ParameterIn.HEADER, description = "The Accept-Encoding header" ,schema=@Schema()) @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding
) {
        return getDelegate().getCdxPywb(namespace, url, limit, matchType, sort, closest, output, fl, accept, acceptEncoding);
    }


    @Operation(summary = "Get a WARC archive", description = "Get the contents of a single WARC record as a WARC archive", tags={ "wayback" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The contents of the requested WARC archive", content = @Content(mediaType = "application/warc", schema = @Schema(implementation = Resource.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))) })
    @RequestMapping(value = "/wayback/warcs/{fileName}",
        produces = { "application/warc", "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getWarcArchive(@Parameter(in = ParameterIn.PATH, description = "Name of the WARC archive", required=true, schema=@Schema()) @PathVariable("fileName") String fileName
, @Parameter(in = ParameterIn.HEADER, description = "The Accept header" ,schema=@Schema()) @RequestHeader(value="Accept", required=false) String accept
, @Parameter(in = ParameterIn.HEADER, description = "The Accept-Encoding header" ,schema=@Schema()) @RequestHeader(value="Accept-Encoding", required=false) String acceptEncoding
, @Parameter(in = ParameterIn.HEADER, description = "The Range header" ,schema=@Schema()) @RequestHeader(value="Range", required=false) String range
) {
        return getDelegate().getWarcArchive(fileName, accept, acceptEncoding, range);
    }

}

