package org.lockss.laaws.rs.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.core.io.Resource;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * ArchivesBody
 */
@Validated



public class ArchivesBody   {
  @JsonProperty("auid")
  private String auid = null;

  @JsonProperty("archive")
  private Resource archive = null;

  public ArchivesBody auid(String auid) {
    this.auid = auid;
    return this;
  }

  /**
   * Archival Unit ID (AUID) of new artifact
   * @return auid
   **/
  @Schema(required = true, description = "Archival Unit ID (AUID) of new artifact")
      @NotNull

    public String getAuid() {
    return auid;
  }

  public void setAuid(String auid) {
    this.auid = auid;
  }

  public ArchivesBody archive(Resource archive) {
    this.archive = archive;
    return this;
  }

  /**
   * Archive data containing artifacts
   * @return archive
   **/
  @Schema(required = true, description = "Archive data containing artifacts")
      @NotNull

    @Valid
    public Resource getArchive() {
    return archive;
  }

  public void setArchive(Resource archive) {
    this.archive = archive;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ArchivesBody archivesBody = (ArchivesBody) o;
    return Objects.equals(this.auid, archivesBody.auid) &&
        Objects.equals(this.archive, archivesBody.archive);
  }

  @Override
  public int hashCode() {
    return Objects.hash(auid, archive);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ArchivesBody {\n");
    
    sb.append("    auid: ").append(toIndentedString(auid)).append("\n");
    sb.append("    archive: ").append(toIndentedString(archive)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
